/**********************************************************************
 *  
 *  NAME:           semas.cpp
 *  
 *  DESCRIPTION:    semaphores for Task++ v. 3.00
 *  
 *  Copyright (c) 1991 J. Alan Eldridge
 *
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/13/91    J. Alan Eldridge    moved here from task.cpp
 *  
 *********************************************************************/

#include    "aedef.h"
#include    "task.h"

//------------------------------------------------------------
//  ********** CLASS SEMA MEMBER FUNCTIONS **********
//------------------------------------------------------------

//------------------------------------------------------------
//  Sema::wait()    --  wait on the semaphore, maybe blocking
//  returns 1 if it got the resource, 0 if timed out 
//------------------------------------------------------------

int
SemaBase::wait(clock_t msec)
{
    int ret = 1;
    
    if (s_value < 1) {
        s_waiting->Add(CurrTask);
        if (!(ret = CurrTask->block(msec)))
           s_waiting->Del(CurrTask);
    } else {
        --s_value;
#if SUSPEND_ON_WAIT
        CurrTask->suspend();
#endif
    }
    return ret;
}

//------------------------------------------------------------
//  SemaBase::signal()  --  signal that task is through using a 
//  a resource, possibly unblocking a task that is waiting
//------------------------------------------------------------

void
SemaBase::signal(int susp)
{
    ++s_value;
    if (s_waiting->Cnt()) {
        --s_value;
        GetNxtTask(*s_waiting)->unblock();
    }

    if (susp)
        CurrTask->suspend();
}

