/*----------------------------------------------------------------------
 *
 *  spooler.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  this is a really stupid print spooler -- but it sort of works
 *
 *  BUGS:
 *
 *  it can use up to MAX file descriptors, since it opens the
 *  file on the call to queue it
 *
 *  NOTES:
 *
 *  you can set the size of the i/o buffer in the initspooler() call;
 *  a size of 0 means to use the default size (see next note)
 *
 *  you can change the default size of the per slice i/o buffer by defining
 *  SP_BUFSIZE like "cc +l -dSP_BUFSIZE=16 -o spooler.o spooler.c" when
 *  you compile it; you can also change the size of the i/o buffer
 *  used to flush the queue; these are things you can best figure out
 *  by trial and error for each application, i'm afraid
 *
 *  same goes for SP_MAXFILES, but i wouldn't get too crazy 'cause i'm not
 *  giving you any more files than dos gives you (this is the main
 *  reason that function spool() has a return code -- no more files)
 *
 *----------------------------------------------------------------------
 */

#include "curses.h"
#include "fcntl.h"

#define SP_MAXFILES 8
#define SP_BUFSIZE 2
#define SP_MAXBUF 1024

#define MIN(a,b) ((a) < (b) ? (a) : (b))

/*----------------------------------------------------------------------
 * 
 *  private storage for spooler
 *
 *----------------------------------------------------------------------
 */

static int  spcnt=0, 
            spfiles[SP_MAXFILES], 
            spbufsiz=SP_BUFSIZE, 
            taskid = -1;

/*----------------------------------------------------------------------
 * 
 *  spooler status functions
 *
 *----------------------------------------------------------------------
 */

int
setspoolpri(pri)
int pri;
{
    return setbgpri(taskid, pri);
}

int
getspoolpri()
{
    return getbgpri(taskid);
}

int
spoolqsize()
{
    return spcnt;
}

int
setspoolbuf(bufsize)
int bufsize;
{
    spbufsiz = bufsize ? MIN(bufsize,SP_MAXBUF) : SP_BUFSIZE;
}

/*----------------------------------------------------------------------
 * 
 *  spool -- spool a file to the printer
 *
 *----------------------------------------------------------------------
 */

int
spool(fn)
char *fn;
{
    if (spcnt < SP_MAXFILES && taskid >= 0) {
        int fd;

        fd = open(fn, O_RDONLY);
        if (fd < 0)
            return -1;
        spfiles[spcnt] = fd;
        return spcnt++;
    }

    return -1;
}

/*----------------------------------------------------------------------
 * 
 *  the spooler task function
 *
 *----------------------------------------------------------------------
 */

static void
spooler()
{
    int cnt;
    char buf[SP_MAXBUF];

    if (spcnt <= 0)
        return;
    cnt = read(spfiles[0], buf, spbufsiz);
    if (cnt <= 0) {
        int n;
        char ff = 12;

        write(4, &ff, 1);
        close(spfiles[0]);
        for (n=0;n<spcnt-1;n++)
            spfiles[n]=spfiles[n+1];
        spcnt--;
    } else
        write(4, buf, cnt);
}

/*----------------------------------------------------------------------
 * 
 *  initialization and shutdown functions
 *
 *----------------------------------------------------------------------
 */

int
initspooler(pri, bufsiz)
int pri, bufsiz;
{
    if (taskid < 0) {
        spbufsiz = bufsiz ? MIN(bufsiz,SP_MAXBUF) : SP_BUFSIZE;
        taskid = addbgtask(spooler, pri);
    }

    return taskid;
}

void
spoolabort()
{
    int fdnum, ff = 12;

    if (taskid < 0 || !spcnt)
        return;

    write(4, &ff, 1);
    for (fdnum=0;fdnum<spcnt;fdnum++)
        close(spfiles[fdnum]);
    spcnt=0;
}

void
spoolflush()
{
    int fdnum;

    if (taskid < 0)
        return;

    for (fdnum = 0; fdnum < spcnt; fdnum++) {
        int cnt, ff = 12;
        char buf[SP_MAXBUF];

        while ((cnt = read(spfiles[fdnum], buf, SP_MAXBUF)) > 0)
            write(4, buf, cnt);
        close(spfiles[fdnum]);
        write(4, &ff, 1);
    }
    spcnt = 0;
}
