/*------------------------------------------------------------
 * 
 *  delwin.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  deletes a window structure, freeing malloc'ed memory
 *
 *  NOTE: deleting a subwindow does NOT free buffer space
 * 
 *----------------------------------------------------------*/

#include "curses.h"

int
delwin(win)
WINDOW *win;
{
    if (!(win->flags & _WSUBWIN)) {
        int y = getmaxr(win);
	    
        while (y >= 0)
            free(win->buf[y--]);
    }

    free(win->buf);
    free(win->firstx);
    free(win->lastx);
    free(win);

    return OK;
}

