#ifndef RHINE_WOL_H
#define RHINE_WOL_H

#include "rhine.h"
struct __rhine_info;

typedef U8	MCAM_ADDR[ETH_ALEN];

typedef
struct _arp_packet {
	U8	abyDMAC[ETH_ALEN];
	U8	abySMAC[ETH_ALEN];
	U16	wType;	
	U16	ar_hrd;		
	U16	ar_pro;	
	U8	ar_hln;	
	U8	ar_pln;	
	U16	ar_op;
	U8	ar_sha[ETH_ALEN];
	U8	ar_sip[4];
	U8	ar_tha[ETH_ALEN];
	U8	ar_tip[4];
} __attribute__ ((__packed__))
ARP_PACKET, *PARP_PACKET;

typedef
struct _magic_packet {
	U8	abyDMAC[6];
	U8	abySMAC[6];
	U16	wType;	
	U8	abyMAC[16][6];
	U8  abyPassword[6];
}
__attribute__ ((__packed__))
MAGIC_PACKET, *PMAGIC_PACKET;

typedef
struct __rhine_context {
	U8			abyMacRegs[256];
	MCAM_ADDR	aMcamAddr[MCAM_SIZE];
	U16			awVcam[VCAM_SIZE];
	U32			dwCammask[2];
	U32			dwPatCRC[2];
	U32			dwPattern[8];
} RHINE_CONTEXT, *PRHINE_CONTEXT;


BOOL rhine_set_wol(struct __rhine_info*);
void rhine_save_context(struct __rhine_info* pInfo,PRHINE_CONTEXT pContext);
void rhine_restore_context(struct __rhine_info* pInfo,PRHINE_CONTEXT pContext);
#endif
