#include <conio.h>
#include <dos.h>
#include "mpu.h"


/* Global Variable Definitions */
unsigned char	mpu_buf[MPU_BUFSIZ];	/* Receive Buffer */
int		mpu_overflow;		/* Receive overflow status */
int volatile	mpu_rindx;		/* Receive Buffer Read Index */
int volatile	mpu_windx;		/* Receive Buffer Write Index */
int		mpu_irq;		/* The IRQ being used */


/* The MPU-401 Interrupt Service Routine */
void _interrupt _far	mpu_isr(void) {
	int	tmp_windx;

	while(!(inp(MPU_STAT) & (1 << MPU_RXRDY))) {
		if(mpu_windx == MPU_BUFSIZ - 1)
			tmp_windx = 0;
		else
			tmp_windx = mpu_windx + 1;

		if(tmp_windx != mpu_rindx) {
			mpu_buf[mpu_windx] = (unsigned char) inp(MPU_DATA);
			mpu_windx = tmp_windx;
		}

		else {
			mpu_overflow = 1;
			while(!(inp(MPU_STAT) & (1 << MPU_RXRDY)))
				inp(MPU_DATA);
		}
	}

	if(mpu_irq > 7)
		outp(ICTL2_CMD, ICTL_EOI);
	outp(ICTL1_CMD, ICTL_EOI);
}

