; This file contains the bi-modal Interrupt Service Routines for servicing
; CoDec interrupts. The real-mode ISR, which is copied into DOS memory
; allocated at run-time, communicates with the protected-mode code through
; a data structure in the DOS memory area.


	.386


	; This buffersize must match the buffersize defined in SNDSCAPE.H

BUFFERSIZE	EQU 5512


	; The following is the shared DOS memory structure which contains
	; the real-mode ISR and the global data needed to communicate
	; between the ISR and the protected-mode code. This structure must
	; match the SHARED typedef in SNDSCAPE.H.

Shared	STRUCT

	rmisr		DB 128 DUP(?)
	dmabuffer_l	DW ?
	dmabuffer_u	DW ?
	nextbuffer_l	DW ?
	nextbuffer_u	DW ?
	waveport	DW ?
	waveirq		DB ?
	flipflop 	DB ?

Shared	ENDS


	; Need to define the data segment here so that the protected-mode ISR
	; can locate any global data it needs.
	
_DATA	SEGMENT DWORD PUBLIC 'DATA'

_DATA	ENDS


	; The normal protected-mode code space
	
_TEXT	SEGMENT DWORD PUBLIC 'CODE'

	EXTERN _SharedP : NEAR

	PUBLIC PmWaveIsr_


	; The protected-mode ISR ...
	
PmWaveIsr_ PROC

	push	eax			; save regs
	push	ebx
	push	edx
	push	ds
	mov	ax,SEG _DATA		; setup data selector
	mov	ds,ax

	mov	ebx,[_SharedP]		; point to shared data base

 	mov	al,0bh			; load pic in-service cmd
pmtst7:
  	cmp	[ebx.waveirq],7		; are we on irq 7?
 	jne	pmtst15
 	out	20h,al			; do in-service test for irq 7
 	in	al,21h
 	in	al,20h
 	test	al,80h
 	jz	pmex
pmtst15:
  	cmp	[ebx.waveirq],15	; are we on irq 15?
 	jne	pmsvc
 	out	0a0h,al			; do in-service test for irq 15
 	in	al,0a1h
 	in	al,0a0h
 	test	al,80h
 	jz	pmex
pmsvc:
	mov	dx,[ebx.waveport]	; read the codec status reg
	add	dx,2
	in	al,dx
	test	al,01h			; is the codec interrupting?
	jz	pmex

	out	dx,al			; clear the codec int
	
	; load nextbuffer with either dmabuff or dmabuff + 1/2 buffsize
	; and update the buffer flip-flop
	mov	eax,DWORD PTR [ebx.dmabuffer_l]
	mov	DWORD PTR [ebx.nextbuffer_l],eax
	xor	[ebx.flipflop],01h
	jnz	pmeoi
	add	DWORD PTR [ebx.nextbuffer_l],BUFFERSIZE/2
pmeoi:
	mov	al,20h			; eoi the pic(s)
	cmp	[ebx.waveirq],8
	jb	pmeoim
	out	0a0h,al
pmeoim:
	out	20h,al
pmex:
	pop	ds			; restore regs
	pop	edx
	pop	ebx
	pop	eax
	iretd				; exit

PmWaveIsr_ ENDP

_TEXT	ENDS



	; The temporary real-mode ISR space. This code will be copied to the
	; DOS shared memory after it is allocated at run-time.

_TEXT16	SEGMENT DWORD PUBLIC USE16 'CODE'

	PUBLIC RmWaveIsr_


	; The real-mode ISR ...
	
RmWaveIsr_ PROC

	push	ax			; save regs
	push	bx
	push	dx
	push	ds
	mov	ax,cs			; setup data seg
	mov	ds,ax

	xor	bx,bx			; point to shared data base

 	mov	al,0bh			; load pic in-service cmd
rmtst7:
  	cmp	[bx.waveirq],7		; are we on irq 7?
 	jne	rmtst15
 	out	20h,al			; do in-service test for irq 7
 	in	al,21h
 	in	al,20h
 	test	al,80h
 	jz	rmex
rmtst15:
  	cmp	[bx.waveirq],15		; are we on irq 15?
 	jne	rmsvc
 	out	0a0h,al			; do in-service test for irq 15
 	in	al,0a1h
 	in	al,0a0h
 	test	al,80h
 	jz	rmex
rmsvc:
	mov	dx,[bx.waveport]	; read the codec status reg
	add	dx,2
	in	al,dx
	test	al,01h			; is the codec interruptig?
	jz	rmex

	out	dx,al			; clear the codec int
	
	; load nextbuffer with either dmabuff or dmabuff + 1/2 buffsize
	; and update the buffer flip-flop
	mov	ax,[bx.dmabuffer_l]
	mov	[bx.nextbuffer_l],ax
	mov	ax,[bx.dmabuffer_u]
	mov	[bx.nextbuffer_u],ax
	xor	[bx.flipflop],01h
	jnz	rmeoi
	add	[bx.nextbuffer_l],BUFFERSIZE/2
	adc	[bx.nextbuffer_u],0
	jmp	SHORT rmeoi
rmeoi:
	mov	al,20h			; eoi the pic(s)
	cmp	[bx.waveirq],8
	jb	rmeoim
	out	0a0h,al
rmeoim:
	out	20h,al
rmex:
	pop	ds			; restore regs
	pop	dx
	pop	bx
	pop	ax
	iret				; exit

RmWaveIsr_ ENDP
					; pad isr to 128 bytes
	DB (128 - ($ - RmWaveIsr_)) DUP(?)

_TEXT16	ENDS


	END
