//
// mvp3_zlt.cpp
//
// PCI device 0 (CPU-PCI-Bridge) latency timer to 0 cycles tool
// solves problem with noisy sound playback on systems using VIA MVP chipset and nVidia graphic card
// OS: NT4 / NT5(Windows2000)
// written by Tibor Schtz (webmaster@deinmeister.de)
// March,16th,2001
//
// compile with: cl /nologo /Zp4 /ML /W3 /O1 /D "WIN32" /Fo"Release/" /Fd"Release/" /FD
// link with   : link kernel32.lib user32.lib /nologo /entry:"wmain" /subsystem:windows /pdb:none /machine:I386 /nodefaultlib
// 
// based on cxe.cpp contained in DirectNT.zip
// from the german computer magazine c't 1/97,
// written by Matthias Witthopf, Andreas Stiller


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winioctl.h>
#include "directnt.h" //contained the DirectNT package

const char *DirectNTDrvName = "\\\\.\\Dev_DirectNT";
ULONG dummy;

BOOL DrvExec(HANDLE Drv,ULONG OpCode,ULONG Par1,ULONG Par2,ULONG Par3,
             void *Result,ULONG ResultSize)
{
  TDirectNTInfo I = {OpCode,Par1,Par2,Par3};
  ULONG         ResultLen;
  if (DeviceIoControl(Drv,DWORD(IOCTL_DIRECTNT_CONTROL),&I,sizeof(I),Result,ResultSize,&ResultLen,NULL))
  {
    return TRUE;
  }
  MessageBox(0,"Error in DirectNT.sys","Error",MB_OK);
  return FALSE;
}

HANDLE Drv;

DWORD getPCI(ULONG index)
{
  DWORD wert;
  DrvExec(Drv,OP_ReadPCIDword,index,0,0,&wert,sizeof(wert));
  return wert;
}

void setPCI(ULONG index, DWORD wert)
{
  DrvExec(Drv,OP_WritePCIDword,index,0,wert,&dummy,0);
}


int WINAPI wmain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
  Drv = CreateFile(DirectNTDrvName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
  if (Drv == INVALID_HANDLE_VALUE) 
  {
    MessageBox(0,"Can't open DirectNT.sys!","Error",MB_OK);
    return -1;
  }

  DWORD state=getPCI(0x0c); //get config 0x0c - 0x0f (latency timer is at 0x0d)
  state=state&0xffff00ff;   //set latency to 0
  setPCI(0x0c,state);	    //write modified settings

  if (!CloseHandle(Drv)) MessageBox(0,"Can't close DirectNT.sys!","Error",MB_OK);
  return 0;
}
