/************************************************************************
 *     MultiSound Record Example Program
 *
 *               Records a PCM sound file based on the parameters defined at
 *               compile time:
 *
 *               SAMPLE_RATE                    44100 / 22050 / 11025
 *               BITS             16 / 8
 *               CHANNELS         2 / 1
 *
 *               The command line parameter is the full path and name of the
 *               file to record to.
 *
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <conio.h>
#include <DOS.H>
#include <msnd_dsp.h>
#include <pcontrol.h>

#define SAMPLE_RATE ( 44100 )
#define BITS        ( 16 )
#define CHANNELS    ( 2 )
#define PCM         ( 1 )

FILE *f_point;

BYTE bTerminator = 0;
BYTE bLastBank = 0xFF;
BYTE *pbHostBuffer;
WORD wTemp;
BYTE bTemp;

BYTE far *pbCurRecordBuff;

void EvalDSPMessage( WORD wDSPMessage );
void SetupRecordStruct( BYTE bBank );

main(argc, argv)
int argc;
char *argv[];
{
	bMem            = HPMEM_D000;
	bIrq            = HPIRQ_10;
	nIRQValue       = 10;
	pMEM.dw.h       = 0xD000;
	pMEM.dw.l       = 0x0000;
  wBASEIO         = 0x290;
	pbCurRecordBuff = pMEM.p;
	bIntFlag        = 0;

	if( ( pbHostBuffer=calloc(sizeof(BYTE), DAP_BUFF_SIZE ) ) == NULL ) exit(0);
	if( ( pwHostQueue = calloc( sizeof(WORD) , HOSTQ_SIZE ) ) == NULL ) exit(0);
	pwHostHead = pwHostQueue;
	pwHostTail = pwHostQueue;

  outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
  outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

	ResetProteus();
	InitializeSMA();
	ResetDSP();
	UploadDSPCode();

  while( *( pMEM.p ) );

	SetupMsndIRQ();

  SetInVolume( 0x0A , GANG );

	for( bTemp = 0 ; bTemp < 3 ; bTemp++ ) {
		SetupRecordStruct( bTemp );
		CurDARQD++;
	}

	if( ( f_point = fopen( argv[1], "wb" ) ) == NULL ) {
		printf("Unable to open file\n");
		ResetMsndIRQ();
		exit(0);
	}

	printf( "Hit the spacebar to begin recording\n" );

	while ( !kbhit() ) {}
	switch ( getch() )
	{
		case 0x71:
		case 0x51:
			ResetMsndIRQ();
			fclose( f_point );
			exit( 0 );
			break;

		default:
			break;
	}

  DARQ->wTail = DARQ_STRUCT_SIZE;       // *** This Changed ***
                                        // 2 buffers , half struct size each
                                        // in DSP sizes
	SendDSPCommand( HDEX_RECORD_START );

	while( !kbhit() && !bTerminator ) {
		if( pwHostTail != pwHostHead ) {
			if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
				pwHostHead = pwHostQueue;
				printf("Wrapping Host Queue\n");
			}
			EvalDSPMessage( *pwHostHead );
		}
  }

  ResetMsndIRQ();
  fclose( f_point );

  return(0);

}


void SetupRecordStruct( BYTE bBank )
{
	CurDARQD->wStart      = PCTODSP_BASED( (DWORD)( DAR_BUFF_SIZE * bBank ) ) + 0x4000;
  CurDARQD->wSize       = DAR_BUFF_SIZE;
	CurDARQD->wFormat     = PCM;
	CurDARQD->wSampleSize = BITS;
	CurDARQD->wChannels   = CHANNELS;
	CurDARQD->wSampleRate = SAMPLE_RATE;
	CurDARQD->wIntMsg     = HIMT_RECORD_DONE * 0x100 + bBank;
	CurDARQD->wFlags      = bBank + 1;
}


void EvalDSPMessage( WORD wMessage )
{
	switch ( HIBYTE( wMessage ) )
	{
		case HIMT_PLAY_DONE:
			switch ( LOBYTE( wMessage ) )
			{
				case 0x01:
					break;

				case 0x02:
					break;

				case 0x00:
					break;

				default:
					break;
			}
			break;

		case HIMT_DSP:
			switch ( LOBYTE( wMessage ) )
			{
				case HIDSP_INT_PLAY_UNDER:
					printf("play under flow\n");
					break;

				case HIDSP_INT_RECORD_OVER:
					printf( "HIDSP_INT_RECORD_OVER\n" );
					break;

				case HIDSP_MIDI_IN_OVER:
					printf( "HIDSP_MIDI_IN_OVER\n" );
					break;

				case HIDSP_MIDI_OVERRUN_ERR:
					printf( "HIDSP_MIDI_OVERRUN_ERR\n" );
					break;

				default:
					printf("ERROR: UNKNOWN_DSP_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
					break;
			}
			break;

		case HIMT_RECORD_DONE:
      bLastBank = LOBYTE( wMessage );

      wTemp = DARQ->wTail + ( DARQ_STRUCT_SIZE / 2 ); // *** This Changed ***

      if( wTemp > DARQ->wSize ) {
        wTemp = 0;
      }

      while( wTemp == DARQ->wHead );   // Wait if we are going to wrap the queue
      DARQ->wTail = wTemp;

      pbCurRecordBuff = ( BYTE far *)( pMEM.p + bLastBank * DAR_BUFF_SIZE );

      CLI;
      outp( wBASEIO + HP_BLKS , HPBLKSEL_1 );
      bCurrBank = 1;
      STI;

      // Do mem copy into host memory to free up DSP mem as fast as possible
      // this double buffering is a new addition
      _fmemcpy( pbHostBuffer , pbCurRecordBuff , DAR_BUFF_SIZE );

      CLI;
      outp( wBASEIO + HP_BLKS , HPBLKSEL_0 );
      bCurrBank = 0;
      STI;

      // Once the DSP memory is free we can write to disk
      // this is a new addition
      fwrite( pbHostBuffer , sizeof( BYTE ) , DAR_BUFF_SIZE , f_point );

			break;

		case HIMT_MIDI_IN_BYTE:
			printf( "HIMT_MIDI_IN_BYTE\n" );
			break;

		default:
				printf("ERROR: UNKNOWN_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
				break;

	}
}


