/************************************************************************
 *     MultiSound MIDI In/Out Example
 *
 *     Takes MIDI in from the external port, and passes it to the proteus
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <conio.h>
#include <msnd_dsp.h>
#include <pcontrol.h>


void EvalDSPMessage( WORD wDSPMessage );
void MidiInData( void );

main()
{
  bIntFlag    = 0;
  bMem        = HPMEM_D000;
  bIrq        = HPIRQ_10;
  nIRQValue   = 10;
  pMEM.dw.h   = 0xD000;
  pMEM.dw.l   = 0x0000;
  wBASEIO     = 0x290;

  outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
  outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

  if( ( pwHostQueue = calloc( sizeof(WORD) , HOSTQ_SIZE ) ) == NULL ) exit(0);
	pwHostTail = pwHostQueue;
	pwHostHead = pwHostQueue;

	ResetProteus();
	ResetDSP();
	InitializeSMA();
	UploadDSPCode();

  while( !*( pMEM.p ) );

	SetupMsndIRQ();

	SetMidiOutPort( MOP_PROTEUS );
	SetMidiInPort( MIP_EXTIN );

	SendDSPCommand( HDEX_MIDI_IN_START );
	SendDSPCommand( HDEX_MIDI_OUT_START );

	while( !kbhit() ) {
		if( pwHostTail != pwHostHead ) {
			if( ++pwHostHead >= ( pwHostQueue + HOSTQ_SIZE ) ) {
				pwHostHead = pwHostQueue;
				printf("Wrapping Host Queue\n");
			}
			EvalDSPMessage( *pwHostHead );
		}
  }

	SendDSPCommand( HDEX_MIDI_IN_STOP );

	ResetMsndIRQ();
  return(0);
}

void MidiInData( void )
{
	WORD wMidiData;
	while( MIDQ->wHead != MIDQ->wTail ) {
		wMidiData = MIDPortRead();
		if( HIBYTE( wMidiData ) == 0x00 ) {
			MODPortWrite( wMidiData );
		}
		printf( "%.2X " , LOBYTE( wMidiData ) );
	}
}

void EvalDSPMessage( WORD wMessage )
{
	switch ( HIBYTE( wMessage ) )
	{
		case HIMT_PLAY_DONE:
			break;

		case HIMT_DSP:
			switch ( LOBYTE( wMessage ) )
			{
				case HIDSP_INT_PLAY_UNDER:
					printf("play under flow\n");
					break;

				case HIDSP_INT_RECORD_OVER:
					printf( "HIDSP_INT_RECORD_OVER\n" );
					break;

				case HIDSP_MIDI_IN_OVER:
					printf( "HIDSP_MIDI_IN_OVER\n" );
					break;

				case HIDSP_MIDI_OVERRUN_ERR:
					printf( "HIDSP_MIDI_OVERRUN_ERR\n" );
					break;
			}
			break;

		case HIMT_RECORD_DONE:
			printf( "HIMT_RECORD_DONE\n" );
			break;

		case HIMT_MIDI_IN_BYTE:
			printf("\nHIMT_MIDI_IN_BYTE\n");
			MidiInData();
			break;

		default:
			printf("UNKNOWN_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
			break;

	}
}



