// Misc. Constants
//      *************************************************
//      *            Miscillanious Constants                                                            *
//      *************************************************

#define PIC1 0x20
#define PIC2 0xA0
#define EOI  0x20

#define TIME_PRO_RESET_DONE  0x028A
#define TIME_PRO_SYSEX       0x001E
#define TIME_PRO_RESET       0x0032

#define NONE   0x00
#define LEFT   0x01
#define RIGHT  0x02
#define GANG   0x03

#define AGND   0x01
#define SIGNAL 0x02

#define EXT_DSP_BIT_DCAL     0x0001
#define EXT_DSP_BIT_MIDI_CON 0x0002

#define BUFFSIZE 0x8000
#define HOSTQ_SIZE 0x40

// Start of SMA control block
#define SRAM_CNTL_START  0x7F00
#define SMA_STRUCT_START 0x7F40

// Data Buffer Sizes

#define DAP_BUFF_SIZE   0x2400
#define DAR_BUFF_SIZE   0x2000

// Queue Sizes

#define DAPQ_STRUCT_SIZE  0x10
#define DARQ_STRUCT_SIZE  0x10
#define DAPQ_BUFF_SIZE  ( 3 * 0x10 )
#define DARQ_BUFF_SIZE  ( 3 * 0x10 )
#define MODQ_BUFF_SIZE  0x400
#define MIDQ_BUFF_SIZE  0x200
#define DSPQ_BUFF_SIZE  0x40

// SMA Buffers Offsets
#define DAPQ_DATA_BUFF  0x6C00
#define DARQ_DATA_BUFF  0x6C30
#define MODQ_DATA_BUFF  0x6C60
#define MIDQ_DATA_BUFF  0x7060
#define DSPQ_DATA_BUFF  0x7260

// SMA Control block offsets
#define DAPQ_OFFSET      SRAM_CNTL_START
#define DARQ_OFFSET      (SRAM_CNTL_START + 0x08)
#define MODQ_OFFSET      (SRAM_CNTL_START + 0x10)
#define MIDQ_OFFSET      (SRAM_CNTL_START + 0x18)
#define DSPQ_OFFSET      (SRAM_CNTL_START + 0x20)

// MIDI port defs
#define  MOP_PROTEUS    0x10
#define  MOP_EXTOUT     0x32
#define  MOP_EXTTHRU    0x02
#define  MOP_OUTMASK    0x01

#define  MIP_EXTIN      0x01
#define  MIP_PROTEUS    0x00
#define  MIP_INMASK     0x32



//      *************************************************
//      *                Macro Definitions                                                                      *
//      *************************************************

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;
typedef struct DAQueueDataStruct far * LPDAQD;


#define HIWORD(l)    ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF ))
#define LOWORD(l)    ((WORD)(DWORD)(l))
#define HIBYTE(w)    ((BYTE)(((WORD)(w) >> 8 ) & 0xFF ))
#define LOBYTE(w)    ((BYTE)(w))
#define MAKELONG(low,hi) ((long)(((WORD)(low))|(((DWORD)((WORD)(hi)))<<16)))
#define MAKEWORD(low,hi) ((WORD)(((BYTE)(low))|(((WORD)((BYTE)(hi)))<<8)))


#define PCTODSP_OFFSET(w) ( w / 2 )
#define PCTODSP_BASED(w)  ( w / 2 + DSP_BASE_ADDR )

#define CLI __asm { cli }
#define STI __asm { sti }



//      *************************************************
//      *            Structure/Union Definitions                                          *
//      *************************************************

union mem_tag {
   BYTE far *p;
   struct dw_tag {
      WORD l;
      WORD h;
      } dw;
   } pMEM;


struct JobQueueStruct {
		WORD wStart;    // Start Address: DSP word X based
		WORD wSize;     // Queue size in words
		WORD wHead;     // Curr output offset
		WORD wTail;     // Curr input offset
};

struct DAQueueDataStruct {                      // typical digital audio queue data format
		WORD wStart;                            // dsp X:xxxx based buffer address
		WORD wSize;                                     // # of bytes in buffer / avail. buffer size
		WORD wFormat;                           // data format (1 = PCM, 2 = future)
		WORD wSampleSize;               // # of bits per sample
		WORD wChannels;                 // 1 = mono, 2 = stereo, etc.
		WORD wSampleRate;               // samples / sec. (ie. 44kHz = 44100)
		WORD wIntMsg;                           // TXH/TXM data @ int/completion time
		WORD wFlags;        // User Data
};

struct SMA0_CommonData {
		WORD wCurrPlayBytes;                            // # of bytes played in current play job
		WORD wCurrRecordBytes;                  // # of bytes recorded in current record job
		WORD wCurrPlayVolLeft;                  // current wave output volume - left
		WORD wCurrPlayVolRight;                 // current wave output volume - right

		WORD wUser_1;
		WORD wUser_2;
		WORD wUser_3;
		WORD wUser_4;

		DWORD dwUser_5;
		DWORD dwUser_6;

		WORD wUser_7;

		WORD wReserved_A;
		WORD wReserved_B;
		WORD wReserved_C;
		WORD wReserved_D;

		WORD wReserved_E;
		WORD wReserved_F;
		WORD wReserved_G;
		WORD wReserved_H;

		WORD wCurrDSPStatusFlags;               // current DSP status flags:
		WORD wCurrHostStatusFlags;              // current Host status flags:
		WORD wCurrInputTagBits;                         // current A/D clipping tag bits
		WORD wCurrLeftPeak;                             // current A/D left  peak value
		WORD wCurrRightPeak;                                    // current A/D right peak value

		WORD wExtDSPbits;                                                       // external DSP harware bits:

		BYTE bExtHostbits;                                              // external Host harware bits:

		BYTE bBoardLevel;                                                       // MultiSound rev level

		BYTE bInPotPosRight;                                    // input  pot left  setting (0->FF)
		BYTE bInPotPosLeft;                                             // input  pot right setting (0->FF)

		BYTE bAuxPotPosRight;                                   // aux/CD pot left  setting (0->FF)
		BYTE bAuxPotPosLeft;                                    // aux/CD pot right setting (0->FF)

		BYTE bUser_8;
		BYTE bUser_9;
		BYTE bUser_10;
		BYTE bUser_11;
		BYTE bUser_12;
		BYTE bUser_13;
		WORD wUser_14;
		WORD wUser_15;

		WORD wCalFreqAtoD;

		WORD wUser_16;
		WORD wUser_17;
};


//      *************************************************
//      *            Functional Prototypes                                                *
//      *************************************************

void InitializeSMA( void );
BYTE ResetMsndIRQ( void );
BYTE SetupMsndIRQ( void );
BYTE SetIntMap( BYTE bIrq );
BYTE UploadDSPCode( void );
BYTE uploadbin( char *szBinFileName );
BYTE uploadreb( char *szRebFileName );
BYTE SendHostWord( BYTE bHi, BYTE bMid , BYTE bLow );
BYTE SendDSPCommand( BYTE bCommand );
BYTE WaitTXDEmpty( void );
BYTE WaitHostClear( void );
BYTE ResetDSP( void );
void _interrupt _far InterruptHandler();
void SetMidiInPort( BYTE bNewMIP );
void SetMidiOutPort( BYTE bNewMop );
void SetMidiPatch( BYTE bNewPatch );
WORD MIDPortRead( void );
void MODPortWrite( WORD wMidiData );
BYTE SetAuxVolume( BYTE bVolume , BYTE bType );
BYTE SetInVolume( BYTE bVolume , BYTE bType );
WORD GetExtDSPbits( void );
void GetDelayTime( WORD wDelayTime );
void ResetProteus( void );
BYTE CalibrateAD( WORD wSampleRate , BYTE bGndType );


//      *************************************************
//      *            Global Variable Definitions                                          *
//      *************************************************

void( __interrupt __far *nDSPSaveVect )();

BYTE bIrq, bMem;
WORD wBASEIO;
int nIRQValue;
BYTE bIntFlag;
WORD *pwHostQueue , *pwHostHead , *pwHostTail;
struct SMA0_CommonData far *SMA;
struct JobQueueStruct far *DAPQ , *DARQ , *MODQ , *MIDQ , *DSPQ;
struct DAQueueDataStruct far *CurDAQD;
struct DAQueueDataStruct far *CurDARQD;
WORD far *pwDSPQData , *pwMIDQData , *pwMODQData;
BYTE bCurrBank;
BYTE far *pbDSPinit;
BYTE far *pbDSPperm;
WORD wCurrentMidiPatch;


// external variables defined in dspcode.obj

extern BYTE     bDspInitStart;
extern WORD     wDspInitSize;
extern BYTE     bDspPermStart;
extern WORD     wDspPermSize;
extern WORD     wDspPermWords;
