#include "iand.i"

#define  TALKER_IO  0x380
#define  TALKER_IRQ 0x03
#define  TALKER_INT TALKER_IRQ + 0x08

//Q %      .8086

DWORD    o1d;

char     *phoneme_q;
WORD     phoneme_q_ptr;

void t_irq( void )
{
Q %      push     ds
Q %      push     ax
G

Q %      lds      si, phoneme_q


Q %      mov      dx, TALKER_IO
Q %      outsb
G
Q %      mov      al, 0x20
Q %      out      0x20, al
G
Q %      pop      ax
Q %      pop      ds
Q %      iret
}


void talker_irq( void )
{
Z .irq:
G
Q %      push     ds
Q %      push     ax

Q %      mov      ax, 0xb800
Q %      mov      ds, ax

//Q %      push     0xb800
//Q %      pop      ds
Q %      inc      byte ptr ds:[0]
Q %      mov      al, 0x20
Q %      out      0x20, al
Q %      pop      ax
Q %      pop      ds
Q %      iret
}

void init_talker_irq( void )
{
Q %      mov      ax, 0x3500 + TALKER_INT
Q %      int      0x21
Q %      mov      o1d, bx
Q %      mov      o1d+2, es
Q %      push     cs
Q %      pop      ds
Q %      mov      dx, offset cs:.irq
Q %      mov      ah, 0x25
Q %      int      0x21
G
Q %      in       al, 0x21
Q %      and      al, NOT (1 SHL TALKER_IRQ)
Q %      out      0x21, al
}

void remove_talker_irq( void )
{
Q % push ds

Q %      mov      dx, o1d
Q %      mov      ax, o1d+2
Q %      mov      ds, ax
Q %      mov      ax, 0x2500 + TALKER_INT
Q %      int      0x21

Q % pop ds
}

void reset_talker( void )
{
Q %      mov      dx, TALKER_IO
Q %      mov      al, 0x3f
Q %      out      dx, al
}

void wait_talker( void )
{
Q %      push     0xb800
Q %      pop      ds
Q %      mov      dx, TALKER_IO
G
Z .poll:
G
Q %      in       al, dx
Q %      and      al, 0x01
Q %      cmp      al, 0
Q %      jnz      .out
Q %      inc      byte ptr ds:[2]
Q %      jmp      .poll
G
Z .out:
}

void send_phoneme( int p, int n )
{
Q %      mov      dx, TALKER_IO
Q %      mov      al, p
Q %      shl      al, 6
Q %      or       al, n
Q %      out      dx, al

//  wait_talker();
}

#include "conio.h"
#include <stdio.h>

BYTE c;

void main()
{
  clrscr();
  printf( "\n\n\n\n\n" );

  init_talker_irq();

  reset_talker();
  wait_talker();
  getch();

  for( int i = 0; i < 0x3f; i++ )
  {
     printf( "%02x ", i );
     send_phoneme( 0x03, 0x3e );
     c = getch();
     if( c == 'q' ) i = 0x3f;
     send_phoneme( 0x03, 0x2a );
     c = getch();
     if( c == 'q' ) i = 0x3f;
  }


  wait_talker();

  remove_talker_irq();
}
