#include "ems.h"

#define PAGES 4
#define LPAGES 2
union REGS r;
struct SREGS sr;
int err=0;
int h[PAGES] = { 0, 0, 0, 0 };

static near void terminal(char *);
static near void error(char *);
void termfunc(void);

void main()
{
word pfr;
int i,j,flag;
int totpage,freepage,ipct,fpct;
char v;
char *ptr;

printf("\r\nOctopus Software EMM testing programm.\r\n");
atexit(termfunc);

printf("Searching EMM driver...\r");
if (!fems1()) terminal("EMM driver not detected by handle technique");
if (!fems2()) terminal("EMM driver not detected by interrupt technique");
printf("EMM driver found in system.\r\n");

if (emmstat()) terminal("EMM status not zero");

v = emmver();
printf("EMS version: %d.%d\r\n", v>>4 , v&0x0f);

pfr = emmframe();
printf("Page frame address: %x\r\n",pfr);

emmpage(&totpage,&freepage);
printf("Logical pages total: %d, available: %d\r\n",totpage,freepage);
ipct = emmhcount();

for (i=0;i<PAGES;i++) h[i]=emmalloc(LPAGES);
printf("Logical pages allocated.\r\n");

fpct = emmhcount();
emmpage(&i,&j);
if (ipct+PAGES==fpct)
   printf("Open handle count is OK.\r\n");
else
   error("Open handle count does not match expected value");
if ( j + PAGES*LPAGES == i)
   printf("Logical page number is OK.\r\n");
else
   error("Logical page number does not match expected value");

for (i=0;i<PAGES;i++)
   if (emmlpcount(h[i])!=LPAGES)
      error("Number of pages returned does not match expected number");
printf("Get handle pages OK.\r\n");

for (flag=1,i=0;i<PAGES;i++) {
   emmmap(h[i],i,1);
   ptr = MK_FP(pfr,PAGELEN*i);
   for (j=0;j<PAGELEN;j++,ptr++) *ptr=i;
   ptr = MK_FP(pfr,PAGELEN*i);
   for (j=0;j<PAGELEN;j++,ptr++)
      if (*ptr!=i) {
         printf("Data in physical page %d does not match expected data.\r\n",i);
         err++; flag=0;
         break;
      }
}
if (flag)
   printf("Logical pages map is OK.\r\n");

for (i=0;i<PAGES;i++) emmsavemap(h[i]);
for (i=0;i<PAGES;i++) emmrestmap(h[i]);
printf("Page map saved and restored.\r\n");

emmstname(h[0],"01234567");
emmstname(h[1],"01234567");

for (i=0;i<PAGES;i++) {
   j=h[i]; h[i]=0; emmfree(j);
}
printf("Logical pages deallocated.\r\n");

return;
}

// Terminal error handler
static near void terminal(char *msg)
{
   printf("Terminal error - %s.\r\n",msg);
   err++;
   exit(1);
}

// Error handler
static near void error(char *msg)
{
   printf("Error - %s.\r\n",msg);
   err++;
}

// Termination function
void termfunc(void)
{
 int i;

 for (i=0;i<PAGES;i++)
   if (h[i]) emmfree(h[i]);
 if (err)
    printf("%d error(s) found during EMM test.\r\n",err);
 else
    printf("All EMM test passed.\r\n");
}

// Find EMM driver by open handle technique
fems1()
{
int hemm,stat,rc=0;

if ( (hemm = open(emmname,O_RDONLY)) == -1 )
  return(0);
stat = ioctl(hemm,0);
if ( stat != -1 && ( stat & 0x0080 ) ) {
   stat = ioctl(hemm,7);
   if ( stat != -1 && ((stat & 0x00ff) == 0x00ff) )
      rc=1;
}
close(hemm);
return(rc);
}

// Find EMM driver by get interrupt technique
fems2()
{
word seg;
char far *drvname;

seg=peek(0,EMMINT*4+2);
drvname=MK_FP(seg,10);
return(!strncmp(drvname,emmname,8));
}

// Return EMM driver status
emmstat()
{
r.h.ah=0x40;
int86(EMMINT,&r,&r);
return(r.h.ah);
}

// Return EMM page frame location
word emmframe()
{
r.h.ah=0x41;
int86(EMMINT,&r,&r);
if (r.h.ah) terminal("EMM status not zero");
return(r.x.bx);
}

// Return EMM page counters
void emmpage(int *totpage, int *freepage)
{
r.h.ah=0x42;
int86(EMMINT,&r,&r);
if (r.h.ah) terminal("EMM status not zero");
*totpage = r.x.dx;
*freepage = r.x.bx;
}

// Allocate EMM logical pages
int emmalloc(int pages)
{
char buf[20];

r.h.ah=0x43;
r.x.bx=pages;
int86(EMMINT,&r,&r);
if (r.h.ah) {
   sprintf(buf,"EMM Allocation error code %x",r.h.ah);
   terminal(buf);
}
return(r.x.dx);
}

// Map handle pages
void emmmap(int handle,int ppage,int lpage)
{
char buf[20];

r.h.ah=0x44;
r.h.al=ppage;
r.x.bx=lpage;
r.x.dx=handle;
int86(EMMINT,&r,&r);
if (r.h.ah) {
   sprintf(buf,"EMM Mapping error code %x",r.h.ah);
   terminal(buf);
}
}

// Deallocate EMM logical pages
void emmfree(int handle)
{
char buf[20];

r.h.ah=0x45;
r.x.dx=handle;
int86(EMMINT,&r,&r);
if (r.h.ah) {
   sprintf(buf,"EMM Deallocation error code %x",r.h.ah);
   error(buf);
}
}

// Get EMM version
char emmver(void)
{
r.h.ah=0x46;
int86(EMMINT,&r,&r);
if (r.h.ah) terminal("EMM status not zero");
return(r.h.al);
}

// Save page mapping
void emmsavemap(int handle)
{
char buf[20];

r.h.ah=0x47;
r.x.dx=handle;
int86(EMMINT,&r,&r);
if (r.h.ah) {
   sprintf(buf,"EMM saving map error code %x",r.h.ah);
   terminal(buf);
}
}

// Restore page mapping
void emmrestmap(int handle)
{
char buf[20];

r.h.ah=0x48;
r.x.dx=handle;
int86(EMMINT,&r,&r);
if (r.h.ah) {
   sprintf(buf,"EMM restoring map error code %x",r.h.ah);
   terminal(buf);
}
}

// Get handle count
int emmhcount(void)
{
r.h.ah=0x4b;
int86(EMMINT,&r,&r);
if (r.h.ah) terminal("EMM status not zero");
return(r.x.bx);
}

// Get handle pages
int  emmlpcount(int handle)
{
r.h.ah=0x4c;
r.x.dx=handle;
int86(EMMINT,&r,&r);
if (r.h.ah) terminal("EMM status not zero");
return(r.x.bx);
}

// Set handle name
void emmstname(int handle, char *name)
{
char buf[20];

r.x.ax=0x5301;
r.x.dx=handle;
r.x.si=FP_OFF(name);
sr.ds=FP_SEG(name);
int86x(EMMINT,&r,&r,&sr);
if (r.h.ah) {
   sprintf(buf,"EMM set handle name error code %x",r.h.ah);
   terminal(buf);
}
return;
}
