#include "tstmci.h"
#include "mcimpeg.h"
#include "digitalv.h"
#include "mmsystem.h" 
#include "windows.h"
#include "mcimpeg.h"


extern WORD    gwDevId;
HCURSOR 			hcCursor;


MCI_MPEG_CREATEDC_PARMS   stMciCreateDc;


/************************************************************************************
   Function: DvmciOpen

   Description: This function will open the DVMCI driver and set some of the 
                video parameters.
************************************************************************************/
DWORD FAR PASCAL DvmciOpen()
{
  DWORD                    dwStatus;
  MCI_DGV_OPEN_PARMS       stMciOpenParms;
  RECT							stRect;

  stMciOpenParms.dwCallback       = NULL;
  stMciOpenParms.lpstrAlias       = NULL;
  stMciOpenParms.lpstrDeviceType  = (LPSTR) "MpegVideo"; 
  stMciOpenParms.lpstrElementName = NULL; 


  hcCursor = LoadCursor( NULL, IDC_WAIT );
  hcCursor = SetCursor( hcCursor );
  if ( ( dwStatus = mciSendCommand ( NULL,
                                   MCI_OPEN,
                                   MCI_OPEN_TYPE,
            (DWORD)((LPMCI_OPEN_PARMS)&stMciOpenParms) ) ) != 0)
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciOpen: Could not open DVMCI driver",
               "MCI_OPEN error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }

  gwDevId = stMciOpenParms.wDeviceID;
/*********************** Create Device Context *****************************/  
  stRect.left   = 0;
  stRect.top    = 0;
  stRect.right  = 256;
  stRect.bottom = 256;
 
  stMciCreateDc.dwCallback=0;
  stMciCreateDc.dwReturn=0;
  stMciCreateDc.rc = stRect;

  if((dwStatus=mciSendCommand(gwDevId,MCI_CREATEDC,MCI_DGV_RECT,
    (DWORD)(&stMciCreateDc)))!=0L)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error creating dc","MCI_CREATEDC error",MB_OK|MB_ICONEXCLAMATION);
	}
/***************************************************************************/

 

  SetCursor( hcCursor );

  return OK;
}

/************************************************************************

   Function: DvmciPlay
   Description: I'm not sure yet...

*************************************************************************/

DWORD FAR PASCAL DvmciPlay()
{
    DWORD                    dwStatus;
    MCI_DGV_MONITOR_PARMS    stMciMonitorParms;
    MCI_DGV_WINDOW_PARMS     stMciWindowParms;
    MCI_DGV_SETVIDEO_PARMS   stMciSetVideo;
    MCI_DGV_STATUS_PARMS     stMciStatus;
    MCI_DGV_UPDATE_PARMS     stMciUpdateDC;
    MCI_DGV_PUT_PARMS        stMciPut;
    MCI_DGV_STATUS_PARMS     stMciStatusParms;
    RECT                     stRect, stUpdRect;
    HFONT                    hfont;
  
    HBRUSH OldHandle;
    int    i;
    char red[1]="R";
	 char green[1]="G";
    char blue[1]="B";
	 DWORD time1,time2, ttime;
    double frate;
    char msg[256];



  stMciWindowParms.nCmdShow  = SW_SHOWNORMAL;

  stMciSetVideo.dwItem  = MCI_DGV_SETVIDEO_SOURCE;
  stMciSetVideo.dwValue = MCI_DGV_SETVIDEO_SRC_NTSC;

  stMciMonitorParms.dwSource = MCI_DGV_MONITOR_INPUT;


  if ( ( dwStatus = mciSendCommand( gwDevId, 
                                    MCI_MONITOR, MCI_DGV_MONITOR_SOURCE,
                 (DWORD)((LPMCI_DGV_MONITOR_PARMS)&stMciMonitorParms) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_MONITOR problem",
               "MCI_MONITOR error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }


  if ( ( dwStatus = mciSendCommand( gwDevId, MCI_SETVIDEO,
							  MCI_DGV_SETVIDEO_ITEM|MCI_DGV_SETVIDEO_VALUE,
           (DWORD)((LPMCI_DGV_SETVIDEO_PARMS)&stMciSetVideo) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_SETVIDEO_ITEM problem",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }
 

 /* stMciSetVideo.dwItem  = MCI_MTX_SETVIDEO_TYPE;
  stMciSetVideo.dwValue = MCI_MTX_SETVIDEO_SRC_COMPOSITE;

  if ( ( dwStatus = mciSendCommand( gwDevId, MCI_SETVIDEO,
							  MCI_DGV_SETVIDEO_ITEM|MCI_DGV_SETVIDEO_VALUE,
           (DWORD)((LPMCI_DGV_SETVIDEO_PARMS)&stMciSetVideo) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_SETVIDEO_ITEM problem",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }
  
*/
  stMciSetVideo.dwSourceNumber = 1;


  if ( ( dwStatus = mciSendCommand( gwDevId, MCI_SETVIDEO,
												 MCI_DGV_SETVIDEO_SRC_NUMBER,
           (DWORD)((LPMCI_DGV_SETVIDEO_PARMS)&stMciSetVideo) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_SETVIDEO problem",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }


  if ( ( dwStatus = mciSendCommand( gwDevId, MCI_SETVIDEO,
												 MCI_SET_ON,
           (DWORD)((LPMCI_DGV_SETVIDEO_PARMS)&stMciSetVideo) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_SETVIDEO_SET problem",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }






/* Set Video Window size to Full Screen */
  stRect.left   = 300;
  stRect.top    = 000;
  stRect.right  = 256;
  stRect.bottom = 256;
  
  stMciPut.rc   = stRect;

  if((dwStatus=mciSendCommand(gwDevId,MCI_PUT,MCI_DGV_PUT_CLIENT|MCI_DGV_RECT,
   (DWORD)((LPMCI_DGV_PUT_PARMS)&stMciPut)))!=0)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error Putting Client","MCI_PUT error",MB_OK|MB_ICONEXCLAMATION);
	}



  stMciStatusParms.dwItem = MCI_DGV_STATUS_HWND;
  

  if ( ( dwStatus = mciSendCommand( gwDevId, MCI_STATUS,
												 MCI_STATUS_ITEM,
           (DWORD)((LPMCI_DGV_WINDOW_PARMS)&stMciStatusParms) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_SHOW_WINDOW problem",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }

  if ( ( dwStatus = mciSendCommand( gwDevId, MCI_WINDOW,
												 MCI_DGV_WINDOW_STATE,
           (DWORD)((LPMCI_DGV_WINDOW_PARMS)&stMciWindowParms) ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciPlay: MCI_SHOW_WINDOW problem",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }


  SetFocus((HWND)stMciStatusParms.dwReturn);

/********************* Select Key White As Key Color ***********************/

  stMciSetVideo.dwCallback=0;
  stMciSetVideo.dwItem=MCI_DGV_SETVIDEO_KEY_COLOR;
  stMciSetVideo.dwValue=RGB(255, 255, 255);  
  stMciSetVideo.dwOver=0;
  stMciSetVideo.lpstrQuality=0;
  stMciSetVideo.lpstrAlgorithm=0;
  stMciSetVideo.dwSourceNumber=0;

  if((dwStatus=mciSendCommand(gwDevId,MCI_SETVIDEO,MCI_DGV_SETVIDEO_ITEM|MCI_DGV_SETVIDEO_VALUE,
   (DWORD)((LPMCI_DGV_SETVIDEO_PARMS)&stMciSetVideo)))!=0)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error setting video key color","MCI_SETVIDEO error",MB_OK|MB_ICONEXCLAMATION);
	}
/***************************************************************************/




/***************************** Get Brush from DVMCI ************************/

  stMciStatus.dwCallback=0;
  stMciStatus.dwReturn=0;
  stMciStatus.dwItem= MCI_MPEG_STATUS_VIDEO_BRUSH;
  stMciStatus.dwTrack=0;

  if((dwStatus=mciSendCommand(gwDevId,MCI_STATUS,MCI_STATUS_ITEM,
   (DWORD)((LPMCI_DGV_STATUS_PARMS)&stMciStatus)))!=0)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error getting brush","MCI_STATUS error",MB_OK|MB_ICONEXCLAMATION);
	}
	
	if (stMciStatus.dwReturn = 0)
	{
	   SetCursor(hcCursor);
	   MessageBox(GetFocus(),"Got Status return of 0","status error",MB_OK);
	}
	
/***************************************************************************/
  


/******* Draw A White Square To key on *******/  


  OldHandle=SelectObject((HDC)stMciCreateDc.dwReturn,(HBRUSH)stMciStatus.dwReturn);  
  Rectangle((HDC)stMciCreateDc.dwReturn,0,0,256, 256);
  SelectObject((HDC)stMciCreateDc.dwReturn,OldHandle);

/***************************************************************************/
  hfont=CreateFont(50, 50,0,0,700,0,0,0,0,0,0,0,0,0);
  OldHandle=SelectObject((HDC)stMciCreateDc.dwReturn, hfont);
  SetBkColor((HDC)stMciCreateDc.dwReturn,RGB(255,255,255));
  SetBkMode((HDC)stMciCreateDc.dwReturn,TRANSPARENT); 
 

    time1=GetTickCount();

  for (i=0; i<1; i++)
{

/************************* Draw Text Boxes ***********************************/
	 


     SetTextColor((HDC)stMciCreateDc.dwReturn,RGB(255,255,255));
     TextOut((HDC)stMciCreateDc.dwReturn,100,150,blue,1);

     SetTextColor((HDC)stMciCreateDc.dwReturn,RGB(255,0,0));
     TextOut((HDC)stMciCreateDc.dwReturn,50,50,red,1);

/********************** Update the Device Context **************************/
   stMciUpdateDC.dwCallback=0;
	stMciUpdateDC.hDC = stMciCreateDc.dwReturn;

  if((dwStatus=mciSendCommand(gwDevId,MCI_UPDATEDC, MCI_DGV_UPDATE_HDC,
													(DWORD)&stMciUpdateDC))!=0)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error in updating dc","MCI_UPDATEDC error",MB_OK|MB_ICONEXCLAMATION);
	}
/***************************************************************************/


     SetTextColor((HDC)stMciCreateDc.dwReturn,RGB(255, 255, 255));
     TextOut((HDC)stMciCreateDc.dwReturn,50,50,red,1);

     SetTextColor((HDC)stMciCreateDc.dwReturn,RGB(0,255,0));
     TextOut((HDC)stMciCreateDc.dwReturn,180,75,green,1);

/********************** Update the Device Context **************************/
   stMciUpdateDC.dwCallback=0;
	stMciUpdateDC.hDC = stMciCreateDc.dwReturn;

  if((dwStatus=mciSendCommand(gwDevId,MCI_UPDATEDC, MCI_DGV_UPDATE_HDC,
													(DWORD)&stMciUpdateDC))!=0)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error in updating dc","MCI_UPDATEDC error",MB_OK|MB_ICONEXCLAMATION);
	}
/***************************************************************************/


     SetTextColor((HDC)stMciCreateDc.dwReturn,RGB(255, 255, 255));
     TextOut((HDC)stMciCreateDc.dwReturn,180,75,green,1);

     SetTextColor((HDC)stMciCreateDc.dwReturn,RGB(0,0,255));
     TextOut((HDC)stMciCreateDc.dwReturn,100,150,blue,1);


/********************** Update the Device Context **************************/
   stMciUpdateDC.dwCallback=0;
	stMciUpdateDC.hDC = stMciCreateDc.dwReturn;

  if((dwStatus=mciSendCommand(gwDevId,MCI_UPDATEDC, MCI_DGV_UPDATE_HDC,
													(DWORD)&stMciUpdateDC))!=0)
	{
	SetCursor(hcCursor);
	MessageBox(GetFocus(),"Error in updating dc","MCI_UPDATEDC error",MB_OK|MB_ICONEXCLAMATION);
	}
/***************************************************************************/

Yield();

}
/*	time2=GetTickCount();

	ttime=(time2-time1);
	frate=300000.0/(double)ttime;
	sprintf(msg, "Total time for 300 frames = %lu milliseconds (frame rate = %6.2f)\n",ttime, frate);

	MessageBox(GetFocus(),msg,"Frame Rate",MB_OK);

*/
  SelectObject((HDC)stMciCreateDc.dwReturn,OldHandle);
  DeleteObject(hfont);




}


/************************************************************************************
   Function: DvmciClose

   Description: Close the DVMCI driver
************************************************************************************/

DWORD FAR PASCAL DvmciClose( VOID )
{
  DWORD dwStatus;


  hcCursor = LoadCursor( NULL, IDC_WAIT );
  hcCursor = SetCursor( hcCursor );
  if ( ( dwStatus = mciSendCommand( gwDevId, 
                                    MCI_CLOSE, NULL, NULL ) ) != 0 )
  {
    SetCursor( hcCursor );
    MessageBox( GetFocus(),
               "DvmciClose: Could not Close DVMCI driver",
               "MCI_SETVIDEO error",
               MB_OK | MB_ICONEXCLAMATION );
    return( dwStatus );
  }

  SetCursor( hcCursor );
  return OK;
}


