/*********************************************************************
*
*  IPTYPE.H
*
*  Copyright (c) 1989 Matrox Electronic Systems, Ltd.
*  All rights reserved.
*
*  This file contain the specific TYPE for IP library.
*  The VG_PIXEL_PTR type and the VG_AFONT type are used as parameter in
*  some library function.
*  VG_PIXEL_8, VG_PIXEL_16, VG_PIXEL_24, VG_PIXEL_32 and VG_CONV_PIXEL are also
*  include in this file for pixel manipulation and convertion.
*  With these structures you can easily change a pixel according
*  to the type of board you have (see the board type variable in
*  IPCNST.H file).
*
*********************************************************************/

/* Note: The following structure MUST be PACKED.. */

/*********************************************************************
*
*     PIXEL manipulation structures.
*
*********************************************************************/

typedef VG_UBYTE VG_APIXEL[4];   /* VG_APIXEL must have place for the widder
                            * color definition */

/* Pointer to unknown pixel size uses in many library functions */
typedef VG_VOID VG_FAR * VG_PIXEL_PTR;
                                  

   typedef struct          /* One byte per pixel, 8 bits gray scale */
      {
      VG_UBYTE gray;          /* 8 bits gray scale (0 - 255) */
      } VG_PIXEL_8;

   typedef struct          /* Two bytes per pixel, 32 K colors */
      {
      VG_WFIELD blue  : 5;     /* Blue component  (0 - 31) */
      VG_WFIELD green : 5;     /* Green component (0 - 31) */
      VG_WFIELD red   : 5;     /* Red component   (0 - 31) */
      VG_WFIELD over  : 1;     /* Overlay bit     (0 - 1) */
      } VG_PIXEL_16;

   typedef struct          /* Three bytes per pixel, 256 K colors */
      {
      VG_UBYTE blue;          /* Blue component  (0 - 255) */
      VG_UBYTE green;         /* Green component (0 - 255) */
      VG_UBYTE red;           /* Red component   (0 - 255) */
      } VG_PIXEL_24;

   typedef struct          /* Four bytes per pixel, 16 M colors */
      {
      VG_WFIELD blue  : 8;     /* Blue component  (0 - 255) */
      VG_WFIELD green : 8;     /* Green component (0 - 255) */
      VG_WFIELD red   : 8;     /* Red component   (0 - 255) */
      VG_WFIELD blend : 7;     /* Blend memory and live (0 - 127) */
      VG_WFIELD over  : 1;     /* Overlay bit     (0 - 1) */
      } VG_PIXEL_32;

   /*
   *     Union for pixel format convertion between PIXEL 8, 16, 24 and 32
   *     format.
   */
   typedef union
      {
      VG_PIXEL_8        color_8;
      VG_PIXEL_16       color_16;
      VG_PIXEL_24       color_24;
      VG_PIXEL_32       color_32;
      } VG_CONV_PIXEL;

/*********************************************************************
*
*     LUT color manipulation structures.
*     ( also used in file function for color conversion ).
*
*********************************************************************/

   typedef struct          /* One byte per color, 8 bits gray scale */
      {
      VG_UBYTE gray;          /* 8 bits gray scale (0 - 255) */
      } VG_LUT_8;

   typedef struct          /* Two bytes per color, 32 K colors */
      {
      VG_WFIELD unused: 1;     /* Unused          (0 - 1) */
      VG_WFIELD red   : 5;     /* Red component   (0 - 31) */
      VG_WFIELD green : 5;     /* Green component (0 - 31) */
      VG_WFIELD blue  : 5;     /* Blue component  (0 - 31) */
      } VG_LUT_16;

   typedef struct          /* Three bytes per color, 256 K colors */
      {
      VG_UBYTE red;           /* Red component   (0 - 255) */
      VG_UBYTE green;         /* Green component (0 - 255) */
      VG_UBYTE blue;          /* Blue component  (0 - 255) */
      } VG_LUT_24;

   /*
   *     Union for color format convertion between LUT 8, 16, 24 and 32
   *     format.
   */
   typedef union
      {
      VG_LUT_8  color_8;
      VG_LUT_16 color_16;
      VG_LUT_24 color_24;
      } VG_CONV_LUT;

/*********************************************************************
*
*     Font header structure type
*
*********************************************************************/

/*
*     Structure of a vector font character
*/
typedef struct
   {
   VG_UBYTE width;      /* Width of character */
   VG_UWORD index;      /* Position of first stroke of character */
   } VG_ACHAR;


/*
*     Structure of a bitmapped font as loaded from disk
*/
typedef struct
   {
   VG_UBYTE  type;           /* Type of font used 0 => Raster font
                                                  1 => Vector font */
   VG_UBYTE first;           /* Value of first character in font */
   VG_UBYTE last;            /* Value of last character in font */
   VG_UBYTE defo;            /* Default character for non existant char */
   VG_UBYTE width;           /* Maximum width of character font */
   VG_UBYTE height;          /* Maximum height of charcter font */
   VG_UBYTE base;            /* Base line position of characters */
   VG_UWORD size;            /* Size of bitmap or stroke table */
   VG_ACHAR _DP_ *table;     /* Character information */
   VG_UBYTE _DP_ *chardata;  /* Character stroke or bitmap definitions */
   } VG_AFONT;


/*********************************************************************
*
*     Logical LUT structure type
*     ( also used in file function for color conversion ).
*
*********************************************************************/

/*
*     Structure for a Logical LUT.
*/
typedef struct
   {
   VG_UBYTE color_size;          /* Color size in VG_BYTE */
   VG_UWORD size;                /* Number of color in the LUT */
   VG_UBYTE offset;              /* Offset relative to the beginning of the real
                               * LUT register */
   VG_VOID _DP_ *color;          /* Color table pointer */
   } VG_ALOGLUT;


/*********************************************************************
*
*  These following TYPE are use by the IP library and by
*  the macros defined functions.
*
*********************************************************************/


/*********************************************************************
*
*     VG_APEN structure type for graphic function (internal).
*
*********************************************************************/

typedef struct
   {
   VG_UBYTE  width;
   VG_UBYTE  type;
   VG_APIXEL color;
   } VG_APEN;


/*********************************************************************
*
*     CURSOR structure type for graphic function (internal).
*
*********************************************************************/

typedef struct
   {
   VG_WORD x;
   VG_WORD y;
   } VG_ACURSOR;


/*********************************************************************
*
*     VG_AFONTATTR structure type used to describe how the font will
*     be rendered (internal).
*
*********************************************************************/

typedef struct
   {
   VG_UWORD  curx;
   VG_UWORD  cury;
   VG_UWORD  scalex;
   VG_UWORD  scaley;
   VG_UBYTE  char_rot;
   VG_UBYTE  str_rot;
   VG_AFONT  _DP_ *curfont;
   VG_APIXEL fg_color;
   VG_UBYTE  space;
   } VG_AFONTATTR;

/*********************************************************************
*
*     VG_AVIDEOPARM structure type used to keep the video parameter
*     of one input source.
*
*********************************************************************/

#ifdef IP
typedef struct
   {
   VG_UBYTE  Type;
   VG_UBYTE  Gain;
   VG_UBYTE  Offset;
   VG_WORD   XPreset;
   VG_WORD   YPreset;
   } VG_AVIDEOPARM;
#endif
#ifdef ILUM
typedef struct
   {
   VG_UBYTE  Type;
   VG_UBYTE  Gain;
   VG_UBYTE  Offset;
   VG_UBYTE  Hue;
   VG_UBYTE  Sat;
   VG_UBYTE  Contrast;
   VG_WORD   XPreset;
   VG_WORD   YPreset;
   } VG_AVIDEOPARM;
#endif

/*********************************************************************
*
*     VG_DRVLIBMEM structure used for a maping of the permanent library
*     memory allocated by the driver (internal).
*     This structure size should not go over than 512 bytes.
*
*********************************************************************/

typedef struct

   {

   struct                     
      {
      VG_BFIELD Mem : 1;      /* Permanent Memory State */
      VG_BFIELD Reserved : 6;
      VG_BFIELD VGADrv : 1;   /* VGA Driver presence */
      } LibSt;                /* Library status byte */
                 
   VG_AFONTATTR FontAtt;      /* Font attribute for text */
   VG_ACURSOR   Cursor;       /* Graphic cursor data */
   VG_APEN      Pen;          /* Default variable for all graphic functions */

   VG_UWORD AcsBufOffset[2];  /* Current byte offset in access buffer */

   /*
   *  The following variables are used to keep the relative value
   *  (user's value) for easy and faster Get... functions.
   */

   VG_UBYTE CPUFrameBuf;      /* CPU frame buffer access when multiple
                               * frame buffer are selected */
   VG_UBYTE GrabFrameBuf;     /* Grab frame buffer access when multiple
                               * frame buffer are selected */
   VG_UBYTE DispFrameBuf;     /* Displayed frame buffer when multiple
                               * frame buffer are selected */

   VG_UBYTE DispMode;         /* Keep the current relative display mode */

   VG_WORD  XDispPos;         /* Keep the current relative display
                               * position */
   VG_WORD  YDispPos;

   VG_UBYTE XZoom;            /* Keep the current zoom factor */
   VG_UBYTE YZoom;

   VG_UBYTE XZoomPan;         /* Keep the current relative zoom pan
                               * position */
   VG_UBYTE YZoomPan;

   VG_UBYTE XZoomPanOffset;   /* Keep the current offset for horizontal
                               * display position when zoompan go over
                               * then 1 position */
   VG_UBYTE YZoomPanOffset;   /* Keep the current offset for vertical
                               * display position when zoompan go over
                               * then 1 position */

   VG_WORD  XGrabSourcePos;   /* Keep the current relative grab window
                               * position and destination */
   VG_WORD  YGrabSourcePos;
   VG_UWORD XGrabSize;
   VG_UWORD YGrabSize;
   VG_WORD  XGrabDestPos;
   VG_WORD  YGrabDestPos;

   VG_UBYTE GrabField;			/* Keep the current grab field */

   VG_WORD  XVideoWinPos;     /* Keep the current relative Video window
                               * position */
   VG_WORD  YVideoWinPos;
   VG_UWORD XVideoWinSize;
   VG_UWORD YVideoWinSize;

   VG_WORD  XPreset;          /* Keep the current relative preset value */
   VG_WORD  YPreset;

   VG_BOOL XPresetSt;         /* Keep the current preset state value */
   VG_BOOL YPresetSt;

   /* 
   *  The Display variables are here to be shared between different OS. 
   */
   VG_WORD  XDispSize;        /* Display size in pixel 
                               * (independant of the zoom factor) */
   VG_WORD  YDispSize;

   VG_WORD  XDispPixel;       /* Display size in pixel 
                               * (dependant of the zoom factor) */
   VG_WORD  YDispPixel;

   VG_UBYTE VideoType;           /* Current Video Type selected */
   VG_UBYTE VideoParmGetIndex;   /* Current Video parameter get index */
   VG_UBYTE VideoParmSetIndex;   /* Current Video parameter set index */
   VG_AVIDEOPARM VideoParm[MAX_NUM_INPUTS];  /* Keep the current video parameter
                                              * for each input */

#ifdef ILUM
   VG_BOOL   BusyBoardSt;
   VG_UBYTE  InitCounter[8];

   /* Video Stabilizer Variables */

   VG_UBYTE  VideoStableMode;

   VG_UWORD  Vpreset;
   VG_UWORD  VsyncStr;
   VG_UWORD  VsyncEnd;
   VG_UWORD  VblankStr;
   VG_UWORD  VblankEnd;
   VG_UWORD  VactiveStr;
   VG_UWORD  VactiveEnd;
   VG_UWORD  Vtotal;
  
   VG_UBYTE  Reserved[120];      /* Adjust this value to have always 
                                  * 512 bytes */
#endif

#ifdef IP
   VG_UBYTE  ImageSourceFrm;     /* Keep the current relative Image window
                                  * position and destination */
   VG_WORD   XImageSourcePos;
   VG_WORD   YImageSourcePos;
   VG_UWORD  XImageSize;
   VG_UWORD  YImageSize;
   VG_UBYTE  ImageDestFrm;
   VG_WORD   XImageDestPos;
   VG_WORD   YImageDestPos;
   VG_APIXEL LObjectColor;
   VG_APIXEL HObjectColor;

   VG_UBYTE  SelectBoard;

   VG_UBYTE  InitCounter[8];

   VG_UBYTE  Reserved[363];      /* Adjust this value to have allways 
                                  * 512 bytes */
#endif
                                 
   VG_UWORD  VGAXPreset;         /* Preset value set by a external VGA 
                                  * driver for VGA overlay centering */
   VG_UWORD  VGAYPreset;

   } VG_DRVLIBMEM;


/*********************************************************************
*
*       Multicard info structure
*
*********************************************************************/

typedef struct
   {
   VG_UWORD     int_7FH[2];
   VG_UWORD     int_10H[2];
   VG_UWORD     irq_int[2];
   VG_UBYTE     irq_sel;
   VG_UBYTE     irq_ctrl;
   VG_UWORD     overlay;
   VG_UBYTE     flags;
   } VG_CARD_INFO;

typedef struct
   {
   VG_CARD_INFO card[MAX_NUM_CARDS];
   VG_UBYTE     num_cards;
   VG_UBYTE     selected_card;
   VG_UBYTE     selected_vga_trap_card;
   } VG_MULTICARD_INFO;


#ifdef IP
/*********************************************************************
*
*     VG_SETUP structure used to recover the current board setup.
*
*********************************************************************/

typedef struct

   {

   /*
   *  Video Input group setup
   */
   struct
      {
      VG_UBYTE       Gain;
      VG_UBYTE       Offset;
      VG_BOOL        GenLockSt;
      VG_APIXEL      InVideoMask;
      VG_UBYTE       VideoSource;
      VG_UBYTE       VideoParmGetIndex;
      VG_UBYTE       VideoParmSetIndex;
      VG_UBYTE       VideoType;
      VG_AVIDEOPARM  VideoParm[MAX_NUM_INPUTS];
      struct
         {
         VG_WORD     x;
         VG_WORD     y;
         }        Preset;
      struct
         {
         VG_BOOL     x;
         VG_BOOL     y;
         }        PresetSt;
      }           vin;

   /*
   *  Video Output group setup
   */
   struct
      {
      VG_APIXEL      OutVideoMask;
      VG_APIXEL      BorderColor;
      VG_BOOL        BorderSt;
      VG_UBYTE       Fade;
      VG_BOOL        InterlaceOutSt;
      VG_UBYTE       Resolution;
      VG_UBYTE       ScanClock;
      VG_UBYTE       ScanMode;
      }           vout;

   /*
   *  Video I/O group setup
   */
   struct
      {
      VG_UBYTE       DispType;
      VG_UBYTE       VideoKeyMode;
      struct
         {
         VG_WORD     x;
         VG_WORD     y;
         VG_UWORD    xsize;
         VG_UWORD    ysize;
         }        VideoWinPos;
      }           vio;

   /*
   *  VGA Overlay group setup
   */
   struct
      {
      VG_BOOL        FadeSt;
      VG_UBYTE       KeyColor[2];
      VG_BOOL        KeyColorSt[2];
      VG_UBYTE       KeyMask;
      VG_UBYTE       KeyOut;
      }           vga;

   /*
   *  Memory access group setup
   */
   struct
      {
      VG_UBYTE       FrameBufConfig;
      VG_UBYTE       FrameBuf;
      VG_UBYTE       Bank;
      VG_APIXEL      ReadMask;
      VG_APIXEL      WriteMask;
      }           mem;

   /*
   *  Memory Display group setup
   */
   struct
      {
      VG_UBYTE       FrameBuf;
      VG_UBYTE       YAxisDirection;
      VG_UBYTE       Bank;
      struct
         {
         VG_WORD     x;
         VG_WORD     y;
         }        Pos;
      struct
         {
         VG_UBYTE    x;
         VG_UBYTE    y;
         }        Mosaic;
      struct
         {
         VG_UBYTE    x;
         VG_UBYTE    y;
         }        Zoom;
      struct
         {
         VG_UBYTE    x;
         VG_UBYTE    y;
         }        ZoomPan;
      }           disp;

   /*
   *  Digital Keying group setup
   */
   struct
      {
      VG_APIXEL      Color;
      VG_UBYTE       Comp;
      VG_APIXEL      Mask;
      VG_UBYTE       Out;
      VG_UBYTE       Type;
      }           key;

   /*
   *  Grab group setup
   */
   struct
      {
      VG_BOOL        ContSt;
      VG_APIXEL      Color;
      VG_BOOL        ColorSt;
      VG_UBYTE       FrameBuf;
      VG_APIXEL      Mask;
      VG_UBYTE       Field;
      VG_UBYTE       RegUpd;
      struct
         {
         VG_WORD     x;
         VG_WORD     y;
         }        DestPos;
      struct
         {
         VG_UBYTE    x;
         VG_UBYTE    y;
         }        Mini;
      struct
         {
         VG_WORD     x;
         VG_WORD     y;
         VG_UWORD    xsize;
         VG_UWORD    ysize;
         }        SourcePos;
      }           grab;

   /*
   *  Window group setup
   */
   struct
      {
      VG_BOOL        AccessBufSt;
      VG_UBYTE       LineWidth[2];
      VG_UBYTE       Type[2];
      struct
         {
         VG_BYTE     xinc;
         VG_BYTE     yinc;
         VG_UBYTE    priority;
         VG_UBYTE    inc_ctrl;
         }        Ctrl[2];
      struct
         {
         VG_WORD     x;
         VG_WORD     y;
         }        Orig[2];
      struct
         {
         VG_UWORD    x;
         VG_UWORD    y;
         }        Size[2];
      }           win;

   /*
   *  Text group setup
   */
   struct
      {
      VG_AFONTATTR   FontAtt;
      }           text;

   /*
   *  Graphic group setup
   */
   struct
      {
      VG_APEN        Pen;
      VG_ACURSOR     Cursor;
      }           gph;

   /*
   *  LUT group setup
   */
   struct
      {
      VG_UBYTE       in[ FULL_COLOR_LUT ];
      struct
         {
         VG_UBYTE    red;
         VG_UBYTE    green;
         VG_UBYTE    blue;
         }        out[ FULL_COLOR_LUT ];

      VG_ACURSOR     Cursor;
      }           lut;

   /*
   *  Image group setup
   */
   struct
      {
      struct
         {
         VG_UBYTE    frame;
         VG_WORD     x;
         VG_WORD     y;
         }        DestPos;
      struct
         {
         VG_UBYTE    frame;
         VG_WORD     x;
         VG_WORD     y;
         VG_UWORD    xsize;
         VG_UWORD    ysize;
         }        SourcePos;
      struct
         {
         VG_APIXEL   low;
         VG_APIXEL   high;
         }        ObjectColor;
      }           img;

   }              VG_SETUP;
#endif

#ifdef ILUM

typedef struct {
   VG_UWORD  vpreset;
   VG_UWORD  vsyncstr;
   VG_UWORD  vsyncend;
   VG_UWORD  vblankstr;
   VG_UWORD  vblankend;
   VG_UWORD  vactivestr;
   VG_UWORD  vactiveend;
   VG_UWORD  vtotal;
} VG_VS_CRT;

#endif

