/********************************************************
*
*  IPDEF.H
*
*  Copyright (c) 1989 Matrox Electronic Systems, Ltd.
*  All rights reserved.
*
*  Define status an mode use in major part by the Get... and Set...
*  functions (see library reference manuel for more detail).
*
********************************************************/

#ifdef IP
#define IP_LIB_VERSION     0x1100   /* IP-LIB version code in BCD */

/* 
*  Two first digit of Driver version code compatible with this IPLIB
*  version. The Driver version must be greater or equal to the following 
*  code to work with this library.
*/
#define IP_LIB_DRIVER      0x11   
  
/* 
*  Two first digit of BIOS version code compatible with this IPLIB
*  version. The BIOS version must be greater or equal to the following 
*  code to work with this library.
*/
#define IP_LIB_BIOS        0x10   

#define MAX_NUM_CARDS      8        /* Maximum number of Board in a system */
#endif


#ifdef ILUM
#define ILUM_LIB_VERSION   0x2000   /* ILUMILIB version code in BCD */

/* 
*  Two first digit of Driver version code compatible with this ILUMILIB
*  version. The Driver version must be greater or equal to the following 
*  code to work with this library.
*/
#define ILUM_LIB_DRIVER    0x20   
  
/* 
*  Two first digit of BIOS version code compatible with this ILUMILIB
*  version. The BIOS version must be greater or equal to the following 
*  code to work with this library.
*/
#define ILUM_LIB_BIOS      0x16   

#define MAX_NUM_CARDS      1        /* Maximum number of Board in a system */
#endif

/*
*     IP board type
*/
#define IP_8          0     /* IP 8 board */
#define IP_16         1     /* IP 16 board */
#define IP_24         2     /* IP 24 board */
#define IP_32         3     /* IP 32 board */

/*
*     IP BIOS interrupt number
*/
#define IP_INT        0x7F

/*
*     Offset of the permanent library memory allocated by the driver.
*/
#define DRV_LIB_MEM_OFFSET    0x0200

/*
*     IP error code
*/
#define IP_BOARD      -1    /* IP board not connect */
#define IP_DRIVER     -2    /* IP device driver not install */
#define FULL_MODE       -3    /* IP board not in proper (full) mode */
#define MEM_POINTER     -4    /* Couldn't create POINTERs to memory 
                               * (ie. _VG_Reg.Struct, _VG_Mem.Struct, etc.) */
#define REPEAT_CALL     -5    /* Repeat call to VG_Init with no VG_Quit
                               * call */
#define IP_BUSY       -6    /* IP board is already in use.. */

/*
*     Reset table identifier
*/
#define EEPROM_TABLE    1     /* EEPROM table is used by Reset() */
#define ROM_TABLE       2     /* ROM table is used by Reset() */

/*
*     DOS operational modes
*/
#define DOS_REALMODE    0     /* Normal   DOS mode */
#define DOS_PHARLAP     1     /* Extended DOS mode under Pharlaps Run386 */
#define DOS_DMPI        2     /* Extended DOS mode under Windows 3.0 */


/*
*     Memory boundary according to memory type and page configuration.
*/
#define X_MIN_MEM       512
#define Y_MIN_MEM       512
#define X_MAX_MEM       1024
#define Y_MAX_MEM       1024

/*
*     Logical LUT definitions.
*/
#define IN_LUT_COLOR_SIZE     1
#define OUT_LUT_COLOR_SIZE    3
#define FULL_COLOR_LUT        256      /* Maximum number of color in both
                                        * (input/output) LUT */

#define SCALE_GRAY            0
#define SCALE_RED             1
#define SCALE_GREEN           2
#define SCALE_BLUE            3

/*
*     Video Parameter Access Index.
*/
#define ACTIVE_PARM     255

#ifdef IP
#define MAX_NUM_INPUTS  4        /* Maximun number of video input channel */

/*
*     Video input (camera) type for IP.
*/
#define NO_CAMERA       0
#define MONO_CAMERA     1
#define COLOR_CAMERA    2
#define SPECIAL_CAMERA  3

/*
*     Video Parameter switching Mask.
*/
#define MASK_TYPE       0x01
#define MASK_GAIN       0x02
#define MASK_OFFSET     0x04
#define MASK_PRESET     0x08
#define NO_MASK         0x00
#define ALL_MASK        0xFF
#endif

#ifdef ILUM
#define MAX_NUM_INPUTS  2        /* Maximun number of video input channel */

/*
*     Video input (camera) type for ILUM.
*/
#define NO_CAMERA             0
#define COMPOSITE_CAMERA      1
#define RGB_CAMERA            2
#define STILL_CAMERA          3
#define SPECIAL_CAMERA        4

/*
*     Video Parameter switching Mask.
*/
#define MASK_TYPE       0x01
#define MASK_GAIN       0x02
#define MASK_OFFSET     0x04
#define MASK_HUE        0x08
#define MASK_SAT        0x10
#define MASK_CONTRAST   0x20
#define MASK_PRESET     0x40
#define NO_MASK         0x00
#define ALL_MASK        0xFF
#endif

#ifdef ILUM
#define IRE_HIGH        0
#define IRE_LOW         1
#endif

#ifdef IP
/*
*     Warning code for board setup exchange.
*/
#define VIN_SETUP       -1
#define VOUT_SETUP      -2
#define VGA_SETUP       -3
#define MEM_SETUP       -4

/*
*     LUT definitions for the IP.
*/
#define IN_LUT                0
#define OUT_LUT               1

/*
*     Normalizing function for convolution.
*/
#define NORMAL_CONV           0
#define DIV_CONV              1
#define TRONC_CONV            2
#define CLIP_CONV             3

/*
*     Density function for histogram modification.
*/
#define UNI                   0
#define EXP                   1
#define RAY                   2
#define HYP_CUB               3
#define HYP_LOG               4

/*
*     Binary operator for image.
*/
#define ADD_IMAGE             0
#define SUB_TO_IMAGE          1
#define SUB_FROM_IMAGE        2
#define OR_IMAGE              3
#define AND_IMAGE             4
#define XOR_IMAGE             5
#define MIN_IMAGE             6
#define MAX_IMAGE             7

/*
*     Label select for histogram drawing.
*/
#define NO_LABEL              0
#define X_LABEL               1
#define Y_LABEL               2
#define XY_LABEL              3

/*
*     Drawing corner select for profile.
*/
#define UPPER_LEFT_PROFILE    0
#define LOWER_LEFT_PROFILE    1
#define UPPER_RIGHT_PROFILE   2
#define LOWER_RIGHT_PROFILE   3

/*
*     RamDAC Chip Type
*/
#define BT_478                0
#define BT_477                1
#endif

/*
*     Monitor type
*/
#define MONITOR_8503    2
#define MONITOR_8512    1
#define MONITOR_8513    1
#define MONITOR_8514    5

#ifdef ILUM
/*
*     Video input format
*/
#define COMPOSITE_INPUT 0
#define RGB_INPUT       1
#endif

#ifdef IP
/*
*     CRT Mode
*/
#define RS170_CRT       0
#define CCIR_CRT        1
#endif
#ifdef ILUM
/*
*     CRT Mode
*/
#define NTSC_CRT        0
#define PAL_CRT         1
#endif

#ifdef IP
/*
*     IP Video keying mode
*/
#define ONLY_VGA_OUT             0
#define ONLY_IP_OUT              4
#define TOG_KEY_VGA_OUT          3
#define TOG_KEY_IP_OUT           11
#define WIN_OUT                  5
#define INV_WIN_OUT              13
#define IP_KEY_OUT               6
#define VGA_KEY_OUT              7
#endif
#ifdef ILUM
/*
*     ILUM Video keying mode
*/
#define CMP_IN_VGA_OUT           0
#define WIN_IN_VGA_OUT           1
#define KEY_IN_VGA_OUT           2
#define TOG_IN_VGA_OUT           3
#define CMP_IN_IP_OUT          4
#define CMP_IN_WIN_OUT           5
#define CMP_IN_KEY_OUT           6
#define CMP_IN_VGA_KEY_OUT       7
#define RGB_IN_ILUM_OUT          8
#define INV_WIN_IN_ILUM_OUT      9
#define KEY_IN_ILUM_OUT          10
#define INV_TOG_IN_ILUM_OUT      11
#define RGB_IN_VGA_OUT           12
#define RGB_IN_INV_WIN_OUT       13
#define RGB_IN_KEY_OUT           14
#define RGB_IN_VGA_KEY_OUT       15
#endif

/*
*     Display output mode
*/
#define KEY_VIDEO       0
#define MEMORY_VIDEO    2
#define LIVE_VIDEO      3

/*
*     VGA keyer output
*/
#define IP_OUT        0
#define VGA_OUT         1

/*
*     Scan output mode
*/
#define REPEAT_FIELD    0
#define PROGRESSIVE     1
#define EVEN_FIELD      2
#define ODD_FIELD       3

/*
*     Field status
*/
#define EVEN            0
#define ODD             1

/*
*     Scan clock select
*/
#define OVERSCAN        0
#define UNDERSCAN       1

/*
*     Y axis direction
*/
#define Y_AXIS_DOWN     0
#define Y_AXIS_UP       1

/*
*     Frame buffer configuration
*/
#define SGLE            0
#define DBLEHORI        1
#define DBLEVERT        2
#define QUAD            3

#ifdef ILUM
/*
*     Resolution mode and screen select for memory access
*/
#define MODE_512X512    0     /* Access all pixels */
#define MODE_512X256_S0 2     /* Access only even line */
#define MODE_512X256_S1 3     /* Access only odd line */
#define MODE_256X256_S0 4     /* Access only even line and even column */
#define MODE_256X256_S1 5     /* Access only even line and odd column */
#define MODE_256X256_S2 6     /* Access only odd line and even column */
#define MODE_256X256_S3 7     /* Access only odd line and odd column */
#endif

/*
*     Resolution display mode
*/
#define RES_512X400     0
#define RES_512X480     1
#define RES_640X480     2
#define RES_1024X768    3
#ifdef ILUM
#define RES_768X576     4
#endif
#ifdef IP
#define RES_512X512     4
#define RES_768X512     5
#define RES_768X576     6
#endif

/*
*     Border state
*/
#define LIVE_BORDER     0
#define FIX_BORDER      1

/*
*     Video keying compare source and output
*/
#define MEMORY          0
#define LIVE            1

/*
*     Video keying compare type
*/
#define SPECIAL         0
#define LESSER          1
#define GREATER         2
#define EQUAL           3

/*
*     Grab field mode
*/
#define EVENBOTH        0
#define EVENONLY        1
#define ODDBOTH         2
#define ODDONLY         3

/*
*     Grab register update mode
*/
#define DIRECT          0
#define HORIZONTAL      1
#define VERTICAL        2

/*
*     Window type
*/
#define LINE_PTR        1
#define WINDOW_PTR      2

/*
*     Window step control value
*/
#define NOINC           0
#define WOINC           1
#define ROINC           2
#define RWINC           3

/*
*     Window priority control
*/
#define XPRIO           0
#define YPRIO           1

/*
*     Line buffer width
*/
#define WIDTH128        0
#define WIDTH256        1
#define WIDTH512        2
#define WIDTH1024       3

/*
*     Pen type
*/
#define ROUND           0        /* Round pen tip */
#define SQUARE          1        /* Square pen tip */

/*
*     Text attribute rotation definition
*/
#define R0              0
#define R90             1
#define R180            2
#define R270            3

/*
*     File format
*/
#define BIT_MAP         0
#define RUN_LENGTH      1

/*
*     File control error code
*/
#define OK                     0
#define FILE_NOT_FOUND        -1
#define BAD_HEADER            -2
#define ERROR_WRITING_HEADER  -2
#define ERROR_WRITING_FILE    -3
#define ERROR_READING_FILE    -3
#define ERROR_NO_MEM_AVAIL    -4

#ifdef ILUM
/*
*  Video Stabilizer mode for ILUM
*/
#define NORMAL_MODE       0
#define PAUSE_MODE        1
#define REWIND_MODE       2
#define FORWARD_MODE      3

#define NTSC_NORMAL_VTOTAL      524
#define NTSC_PAUSE_VTOTAL       516
#define NTSC_REWIND_VTOTAL      524
#define NTSC_FORWARD_VTOTAL     506
 
#define PAL_NORMAL_VTOTAL       624
#define PAL_PAUSE_VTOTAL        616
#define PAL_REWIND_VTOTAL       624
#define PAL_FORWARD_VTOTAL      590
#endif

/*
*     MACRO for register and memory backup structure access.
*/
#ifdef __HIGHC__
  #define MEM( name )     _VG_Mem.Struct->/**/name
  #define REG( name )     _VG_Reg.Struct->/**/name
#else 
 #ifdef _INTELC32_
   #define MEM( name )     _VG_Mem.Struct->name
   #define REG( name )     _VG_Reg.Struct->name
 #else
  #ifdef __WATCOMC__
   #define MEM( name )     _VG_Mem.Struct->name
   #define REG( name )     _VG_Reg.Struct->name
  #else   
   #define MEM( name )     _VG_Mem.Struct->##name
   #define REG( name )     _VG_Reg.Struct->##name
 #endif
#endif
#endif

#ifdef __WATCOMC__

   #define MEMEQREG( regname ) _VG_Mem.Struct->regname=_VG_Reg.Struct->regname

 /* RW Register Macros */

 #define GETRWREG( regname )          _VG_Reg.Struct->regname

 #define SETRWREG( regname , value )  _VG_Reg.Struct->regname=value

 /* must set MEMEQREG first */
 #define GETRWFIELD( regname , field) _VG_Mem.Struct->regname.field

 #define SETRWFIELD( regname , field , value )  MEMEQREG( regname );\
                                                _VG_Mem.Struct->regname.field=value;\
                                                _VG_Reg.Struct->regname=_VG_Mem.Struct->regname

 /* WO Register Macros */

 #define GETWOREG( regname )         _VG_Mem.Struct->regname

 #define SETWOREG( regname , value ) _VG_Mem.Struct->regname=value;\
                                     _VG_Reg.Struct->regname=value

 #define GETWOFIELD( regname , field )         _VG_Mem.Struct->regname.field

 #define SETWOFIELD( regname , field , value ) _VG_Mem.Struct->regname.field=value;\
                                               _VG_Reg.Struct->regname=_VG_Mem.Struct->regname

 /* RO Register Macros */

 #define GETROREG( regname )  _VG_Reg.Struct->regname

 /* must set MEMEQREG first */
 #define GETROFIELD( regname , field ) _VG_Mem.Struct->regname.field

#else
#ifdef _INTELC32_
 
 #define MEMEQREG( regname ) _VG_Mem.Struct->regname=_VG_Reg.Struct->regname

 /* RW Register Macros */

 #define GETRWREG( regname )          _VG_Reg.Struct->regname

 #define SETRWREG( regname , value )  _VG_Reg.Struct->regname=value

 /* must set MEMEQREG first */
 #define GETRWFIELD( regname , field) _VG_Mem.Struct->regname.field

 #define SETRWFIELD( regname , field , value )  MEMEQREG( regname );\
                                                _VG_Mem.Struct->regname.field=value;\
                                                _VG_Reg.Struct->regname=_VG_Mem.Struct->regname

 /* WO Register Macros */

 #define GETWOREG( regname )         _VG_Mem.Struct->regname

 #define SETWOREG( regname , value ) _VG_Mem.Struct->regname=value;\
                                     _VG_Reg.Struct->regname=value

 #define GETWOFIELD( regname , field )         _VG_Mem.Struct->regname.field

 #define SETWOFIELD( regname , field , value ) _VG_Mem.Struct->regname.field=value;\
                                               _VG_Reg.Struct->regname=_VG_Mem.Struct->regname

 /* RO Register Macros */

 #define GETROREG( regname )  _VG_Reg.Struct->regname

 /* must set MEMEQREG first */
 #define GETROFIELD( regname , field ) _VG_Mem.Struct->regname.field

#else

 #define MEMEQREG( regname ) 

 /* RW Register Macros */

 #define GETRWREG( regname )          _VG_Reg.Struct->##regname

 #define SETRWREG( regname , value )  _VG_Reg.Struct->##regname=value

 #define GETRWFIELD( regname , field) _VG_Reg.Struct->##regname.field

 #define SETRWFIELD( regname , field , value )  _VG_Reg.Struct->##regname.field=value\

 /* WO Register Macros */

 #define GETWOREG( regname )         _VG_Mem.Struct->##regname

 #define SETWOREG( regname , value ) _VG_Mem.Struct->##regname=value;\
                                     _VG_Reg.Struct->##regname=value

 #define GETWOFIELD( regname , field )         _VG_Mem.Struct->##regname.field

 #define SETWOFIELD( regname , field , value ) _VG_Mem.Struct->##regname.field=value;\
                                               _VG_Reg.Struct->##regname=_VG_Mem.Struct->##regname

 /* RO Register Macros */

 #define GETROREG( regname )  _VG_Reg.Struct->regname

 #define GETROFIELD( regname , field ) _VG_Reg.Struct->##regname.field

#endif
#endif

/*
*     MACRO for coverting a REAL segment:offset to a linear address
*/
#define MK_LINEAR(segment, offset)  (((VG_UDWORD )(segment) << 4L) + (offset))

/*
   Operating System defines
*/

#define VG_MAX_OS        8

#define VG_DOS_OS        0
#define VG_WIN_OS        1
#define VG_OS2_OS        2

#ifdef DOS
   #define VG_CURRENT_OS 0
#endif
#ifdef WIN30
   #define VG_CURRENT_OS 1
#endif
#ifdef OS2
   #define VG_CURRENT_OS 2
#endif

#ifdef ILUM
 #define CUSTOM_MODE       2

 #define SHIFT_DEFAULT     -1
 #define CLIP_DEFAULT      -1

 #define NTSC_INTR_SHIFT    22
 #define NTSC_NINT_SHIFT    21
 #define NTSC_INTR_CLIP     8
 #define NTSC_NINT_CLIP     0

 #define PAL_INTR_SHIFT     23
 #define PAL_NINT_SHIFT     21
 #define PAL_INTR_CLIP      14
 #define PAL_NINT_CLIP      0
#endif


