/*
    filename:   i_dll.h
    Synopsis:   Definition to support DLL for OS2 and WINDOWS 3.0
    Date:       April the 09th 1991

COPYRIGHT (c) 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_I_DLL_H__
#define __I_I_DLL_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Microsoft windows definitions. */
#if (defined (I_WINDOWS) && defined (__I_WIN_NT_H__))
   #define FTYPE _stdcall
   #define I_NOPRINTF 1
   #define _I_PTYPE far
   #define _I_HRDWTYPE far

#else
#if (defined (I_WINDOWS))
   #define FTYPE far pascal
   #define I_NOPRINTF 1
   #define _I_PTYPE far
   #define _I_HRDWTYPE far

/* OS/2 DLL definitions. */
#else
#if (defined (I_OS2) && defined (I_DLL))

   #define FTYPE _far _pascal
   #define _I_PTYPE
   #define _I_HRDWTYPE far


/* Turbo C DLL definitions. */
#else
#if defined ( __TURBOC__ ) && defined ( __DLL__ )

   #define FTYPE far pascal _export
   #define I_NOPRINTF 1
   #define _I_PTYPE far
   #define _I_HRDWTYPE far

/* MSC DLL definitions. */
#else
#if defined ( __MSC__ ) && defined ( __DLL__ )

   #define FTYPE far pascal _export
   #define I_NOPRINTF 1
   #define _I_PTYPE far
   #define _I_HRDWTYPE far

/* Default definitions. */
#else
#if defined(__WATCOMC__)

  /* SHey 94/03/07 Added WATCOM compiler support */
  /* We will define function as cdecl for Microsoft compatible */
  /* Model for compilation under WATCOM is */
  /*  small model (all pointer are near) */

   #define FTYPE cdecl
   #define I_NOPRINTF 1
   #define _I_PTYPE
   #define _I_HRDWTYPE far

#else
#if defined(I_BORLAND32)

  /* Dboivin 95/02/16 Added Borland PowerPack compiler support */

   #define FTYPE cdecl
   #define I_NOPRINTF 1
   #define _I_PTYPE
   #define _I_HRDWTYPE

#else

   #define FTYPE
   #define _I_PTYPE
   #define _I_HRDWTYPE far

#endif /* I_BORLAND32 */
#endif /* __WATCOMC__ */
#endif /* __MSC__ && __DLL__ */
#endif /* __TURBOC__ && __DLL__ */
#endif /* I_OS2 && I_DLL */
#endif /* I_WINDOWS  */
#endif /* I_WINDOWS && __I_WIN_NT_H__ */

#if (defined (PHAR_LAP) || defined (I_UNIX) || defined(I_BORLAND32))
#ifndef far
#define far
#endif
#endif

typedef union
    {
    void _I_PTYPE *vptr;
    char _I_PTYPE *bptr;
    short _I_PTYPE *wptr;
    long _I_PTYPE *lptr;
    } I_TYPE_PTR;

typedef union
    {
#ifdef PHAR_LAP
    void far *vptr;  /* SHey 93/05/03 Removed _far before each lines and moved before *  */
    unsigned char far *bptr;
    unsigned short far *wptr;
    unsigned long far *lptr;
#else
    void far *vptr;
    char far *bptr;
    short far *wptr;
    long far *lptr;
#endif
    } I_TYPE_FPTR;

#endif /* __I_I_DLL_H__ */
