
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#include "i_head.h"

/* 
 Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _pciqsys
*/

extern unsigned long i_buff[];

#define BUF_LENGTH   128

#ifdef ANSI
void FTYPE pciqsys(unsigned short option, void _I_PTYPE * retval)
#else
FTYPE pciqsys(option, retval)
unsigned short option;
void _I_PTYPE * retval;
#endif
{
    unsigned long _I_PTYPE *p;
    int char_cnt = BUF_LENGTH;
    char _I_PTYPE *ptr;

    p = i_buff;
    
    *p++ = (SECOND_DEC | PCIQSYS);
    *p++ = (unsigned long) option;

    ioputbuf((short _I_PTYPE *) i_buff, 4);

    switch( option )
    {
        case I_IQ_DCMASKS:      /* 6 16-bit values:
                                   red, green blue primary masks and red,
                                   green, blue overlay masks set by the
                                   command lsdcstrdmask().                */
                iogetbuf( (short _I_PTYPE *) retval, 6 );
                break;

        case I_IQ_LADDR:        /* (long) first invalid local ram address */
        case I_IQ_TL:           /* (long) pointer to top-left corner */
        case I_IQ_COMP_LEN:     /* (long) compression length */
        case I_IQ_DECOMP_STAT:  /* (long) decompression status */

                iogetbuf( (short _I_PTYPE *) retval, 2 );
                break;

        case I_IQ_SCRW:         /* visible screen width in pixels */
        case I_IQ_SCRH:         /* visible screen height in pixels */

#ifdef COMMENTARISE
        case I_IQ_NCOLORS:      /* number of sim colors on screen */
        case I_IQ_MAXRED:       /* maximum red intensity */
        case I_IQ_MAXGREEN:     /* maximum green intensity */
        case I_IQ_MAXBLUE:      /* maximum blue intensity */
#endif
                                /* frame buffer descriptor */
        case I_IQ_W:            /* width in pixels */
        case I_IQ_H:            /* height in pixels */
        case I_IQ_PTCH:         /* pitch in bits */
        case I_IQ_FMT:          /* fmt: 8 LSBs: # bits/pixel */
                                /*      8 MSBs: # bit planes */
        case I_IQ_BOARD_TYPE:   /* Low Byte->  1: IM1280, 2: IM640, 3: IM-LC */
                                /* High Byte-> 0: AT, 1: EISA, 2: VME */
        case I_IQ_PORTRAIT:     /* 0 = landscape, 1: portrait. */
        case I_IQ_FPU_PRESENT:  /* presence of optional 34082 FPU */
                                /* != 0 == present */
        case I_IQ_OPT_MEM:      /* presence of optional memory (!=0 == yes) */
        case I_IQ_CLD_QTY:
        case I_IQ_ASD_QTY:
        case I_IQ_RTP_QTY:
        case I_IQ_GSP_VER:      /* GSP version */
        case I_IQ_CAMW:         /* Maximum ROI width and height to be set   */
        case I_IQ_CAMH:         /* with the current selected logical camera */
        case I_IQ_ALU_QTY:
		case I_IQ_OEM_ID:
        case I_IQ_CAM_TARGET:
        case I_IQ_CAM_PIXSIZE:
        case I_IQ_CAM_PCLK:
        case I_IQ_CAM_TYPE:
        case I_IQ_CAM_COLFMT:
        case I_IQ_VGA_STAT:
                * (short _I_PTYPE *) retval = iogetw();
                break;

        case I_IQ_VERSION:      /* shell version number */
                ptr = (char _I_PTYPE *)retval;
                do
                   *ptr = (char)iogetw();
                while( (--char_cnt) && ((int)*ptr++) );
                break;

        case I_IQ_CPU_SPEED:    /* CPU speed    - not implemented yet */
                * (short _I_PTYPE *) retval = 0; /* will call routine running on host */
                break;

        default:
                break;
    }
}
