/*/  sample.c
*
*    Sample program for the IM-1280 C binding library.
*/

#include    "imseries.h"
#ifdef I_UNIX
#include    <im_series/i_head.h>
#include    <im_series/proto.h>
#include    <im_series/libfn.h>
#else
#include    "i_head.h"
#include    "proto.h"
#include    "libfn.h"
#endif

#include 	<stdio.h>

void main()

{
    int fd;     /* the file handle */
	unsigned short boardType;

    /* open device at default address, with lmapwap strap out and */
    /* adapt2 strap in. If the IMAGE SERIE board is configured to */
    /* use a different address, use a different parameter.        */
    /* For example, if the board is used with a VGA card, the     */
    /* lmapswap strap should be put in and the constant used with */
    /* ioopdevice() should be I_LIN_AIN_LOW.                      */

    if (( fd = ioopdevice ( I_LIN_AIN_LOW,0 )) == -1 )
		{
		fprintf ( stderr, "unable to open device.\n" );
		exit ( 1 );
		}

    /* select device a current device */
    iosldevice(fd);

	/* inquire for board type */
	pciqsys ( I_IQ_BOARD_TYPE, &boardType );

    /* select frame buffer organisation */
    pcstfborg(I_FB4X1KX1KX8);
    
    /* set mask */
    krhwsmsk(0xFFFF);
    
    /* select surface 2, which is fb2 in this frame buffer organisation */
    krhwslcsurf(2);
    
    /* select fb2 to be displayed */
    lsdcstdmode ( I_FB2_1K_1K_8 );
       
    /* clear visible screen */
    krhwsclr(0);
    
    scolsw(15);   /* set outline width */
    krhwsfcol(0x68); /* set foreground color */
    
    lssfont(-1);  /* select default font */ 
    sctxssf((float)2.0, (float)3.0); /* set text scaling */
    
	switch ( boardType & 0xFF )
		{
		case 1 :
		/* board is an IM-1280 */
	    scolrrect(310, 350, 940, 650, 0x14, 0x14);/* draw rounded rectangle */
    	sctxbstring(450, 450, "Matrox IM-1280");  /* draw text */
		break;

		case 2 :
		/* board is an IM-640 */
	    scolrrect( 140, 150, 500, 335, 0x14, 0x14 );/* draw rounded rectangle */
    	sctxbstring ( 170, 200, "Matrox IM-640");  /* draw text */
		break;

		case 3 :
		/* board is a Low Cost */
	    scolrrect( 155, 150, 644, 379, 0x14, 0x14 );/* draw rounded rectangle */
    	sctxbstring ( 225, 225, "Matrox Image-LC");  /* draw text */
		break;
		}		

    scolsw(1);    /* set outline width */

    /* close device */
    iocldevice(fd);
}

