/***************************************************************************
 File: sxopt.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you do not resell 
 the code and that this notice (including the above copyright notice) is 
 reproduced on all copies.  THIS SAMPLE CODE IS PROVIDED "AS IS", WITHOUT 
 WARRANTY OF ANY KIND, AND GO CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
 WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL GO 
 CORPORATION BE LIABLE TO YOU FOR ANY CONSEQUENTIAL,INCIDENTAL, OR INDIRECT 
 DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THIS SAMPLE CODE.
			  
 $Revision:   1.0  $
   $Author:   aloomis  $
     $Date:   13 Aug 1992 12:14:48  $

 This file contains the methods to create and manage an option card.

****************************************************************************/
#ifndef APPTAG_INCLUDED
#include <apptag.h>
#endif

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef POPUPCH_INCLUDED
#include <popupch.h>
#endif

#ifndef TK_INCLUDED
#include <tk.h>
#endif

#ifndef STROBJ_INCLUDED
#include <strobj.h>
#endif

#ifndef INTL_INCLUDED
#include <intl.h>
#endif

#ifndef _STDIO_H_INCLUDED
#include <stdio.h>
#endif

#ifndef SXAPP_INCLUDED
#include "sxapp.h"
#endif
#include "methods.h"

/* Serial option sheet tables */
static const TK_TABLE_ENTRY sxSerialCardEntries[] = {
	{tagSXPortStr, 0, 0, 0, tkLabelStringId},
		{0, 0, 0, tagSXPortOption, tkNoClient, clsPopupChoice},
		{pNull},
	{tagSXBaudRateStr, 0, 0, 0, tkLabelStringId},
		{0, 0, 0, tagSXBaudRateOption, tkNoClient, clsPopupChoice},
		{  tagSX300Str, 0, 0,   300, tkLabelStringId},
		{ tagSX1200Str, 0, 0,  1200, tkLabelStringId},
		{ tagSX2400Str, 0, 0,  2400, tkLabelStringId},
		{ tagSX4800Str, 0, 0,  4800, tkLabelStringId},
		{ tagSX9600Str, 0, 0,  9600, tkLabelStringId},
		{tagSX19200Str, 0, 0, 19200, tkLabelStringId},
		{pNull},

	{tagSXParityStr, 0, 0, 0, tkLabelStringId},
		{0, 0, 0, tagSXParityOption, tkNoClient, clsChoice},
		{tagSXNoneStr, 0, 0,   sioNoParity, tkLabelStringId},
		{ tagSXOddStr, 0, 0,  sioOddParity, tkLabelStringId},
		{tagSXEvenStr, 0, 0, sioEvenParity, tkLabelStringId},
		{pNull},

	{tagSXDataBitsStr, 0, 0, 0, tkLabelStringId},
		{0, 0, 0, tagSXDataBitsOption, tkNoClient, clsChoice},
		{tagSX7Str, 0, 0, sioSevenBits, tkLabelStringId},
		{tagSX8Str, 0, 0, sioEightBits, tkLabelStringId},
		{pNull},

	{tagSXStopBitsStr, 0, 0, 0, tkLabelStringId},
		{0, 0, 0, tagSXStopBitsOption, tkNoClient, clsChoice},
		{tagSX1Str, 0, 0,  sioOneStopBit, tkLabelStringId},
		{tagSX2Str, 0, 0, sioTwoStopBits, tkLabelStringId},
		{pNull},

	{tagSXFlowControlStr, 0, 0, 0, tkLabelStringId},
		{0, 0, 0, tagSXFlowControlOption, tkNoClient, clsChoice},
		{    tagSXNoneStr, 0, 0,       sioNoFlowControl, tkLabelStringId},
		{ tagSXXOnXOffStr, 0, 0,  sioXonXoffFlowControl, tkLabelStringId},
		{tagSXHardwareStr, 0, 0, sioHardwareFlowControl, tkLabelStringId},
		{pNull},

	{tagSXStatusStr, 0, 0, 0, tkLabelStringId},
		{tagSXConnectedStr, 0, 0, tagSXConnected,
			tkLabelStringId|tkNoClient|tkInputDisable|
			tkBorderMarginNone, clsLabel},
	{pNull}
};


/*
 * Respond to msgOptionAddCards.
 *
 * Add a homebrew serial option card before the system ones.
 */
MsgHandlerWithTypes(SXOptionAddCards, P_OPTION_TAG, PP_SX_APP_DATA)
{
	OPTION_CARD card;
	STATUS s;

	Dbg(Debugf(U_L("SXOptionAddCards >>"));)

	if (pArgs->tag == tagAppDocOptSheet) {

		/* Add the Serial option card to the sheet.
		 *
		 * Note that SIO already offers a standard option card for serial 
		 * metrics, which would normally be the way to present options for 
		 * serial I/O.  We create a specialized option sheet here in order 
		 * to demonstrate how to set the serial metrics and how to use 
		 * dynamic objects.
		 *
		 * To use the option sheet that clsSio provides  you just:
		 *
		 *   ObjCallWarn(msgOptionAddCards, sio-service, pArgs);
		 *
		 * The basic difference between the standard Sio option card
		 * and the one used here, is that the Sio card focuses on setting 
		 * the metrics for the current open service instance, not on 
		 * specifying a new one. Depending on your app you will have to 
		 * provide a mechanism (probably another option sheet) for the user 
		 * to select one of the possibly several serial service instances.
		 *
		 * Keep in mind that it is the service instance who manages the 
		 * card, not your application. The service instance uses the card 
		 * values to set the serial metrics directly. So, when you use the 
		 * standard Sio option card, your application does not get involved 
		 * in setting the metrics at all and is only responsible for getting 
		 * the bytes in and out of the port.
		 *
		 * This custom serial option sheet allows you to select the spooler 
		 * (only available in the SDK). This sample app doesn't distinguish 
		 * the spooler from a hardware port, so if the spooler is selected, 
		 * the application will try to set metrics for it.  Since the spooler
		 * obviously does not recognize these metrics, it will return 
		 * stsNotUnderstood.  You can ignore this.  You can not select the 
		 * spooler from the standard Sio option sheet.
		 */
		memset(&card, 0, SizeOf(OPTION_CARD));
		card.tag = tagSXAppSerialCard;
		card.win = objNull;
	
#ifdef PP1_0
		{
		RES_READ_DATA resrd;

		/* Get card name from resource file. This will go away when
		 * the bridge library is in place.
		 */
		memset(&resrd, 0, SizeOf(RES_READ_DATA));
		resrd.resId = resSXToolKit;
		resrd.heap = osProcessSharedHeapId;
		resrd.pAgentData = (P_UNKNOWN)TagNum(tagSXSerialStr);
		ObjCallWarn(msgResReadData, theProcessResList, &resrd);
		card.pName = resrd.pData;
		}
#else 
		card.pName = ResUtilAllocListString(osProcessHeapId, resGrpTK, 
				tagSXSerialStr);
#endif

		card.client = self;
		ObjCallRet(msgOptionAddCard, pArgs->option, &card, s);

	}

	Dbg(Debugf(U_L("<< SXOptionAddCards"));)

	return ObjCallAncestorWarn(msg, self, pArgs, ctx);

	MsgHandlerParametersNoWarning;
} /* SXOptionAddCards */

/*
 * Respond to msgOptionProvideCard.
 *
 * Create the actual serial card from scratch. Initialize option values.
 */
MsgHandlerWithTypes(SXOptionProvideCard, P_OPTION_CARD, PP_SX_APP_DATA)
{
	OPTION_TABLE_NEW otn;
	WIN control, choice;
	WIN_METRICS wm;
	BUTTON_NEW bn;
	LIST_ENTRY le;
	P_CHAR sername;
	U32 value;
	U16 n;
	STATUS s;

	Dbg(Debugf(U_L("SXOptionProvideCard >>"));)

	if(pArgs->tag == tagSXAppSerialCard) {

		/* Create the serial card. */
		ObjCallWarn(msgNewDefaults, clsOptionTable, &otn);
		otn.tkTable.pEntries = sxSerialCardEntries;
		otn.win.tag = tagSXAppSerialCard;
		ObjCallRet(msgNew, clsOptionTable, &otn, s);
	
		pArgs->win = otn.object.uid;
		(*pData)->sxOptWin = otn.object.uid;

		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXPortOption)) {

			/* Get the choice of the popup choice to insert buttons in,
			 * representing the various serial port devices available.
			 */
			ObjCallRet(msgPopupChoiceGetChoice, control, &choice, s);

			/* How many items in list? */
			ObjCallRet(msgListNumItems, (*pData)->sxSerialNameList, (P_ARGS)&n, s);
			Dbg(Debugf(U_L("Creating %ld choice items"), n);)

			for (le.position = 0; le.position < n; le.position++) {
				/* Get item at this position in the list */
				ObjCallRet(msgListGetItem, (*pData)->sxSerialNameList, &le, s);

				/* Get string for this object */
				ObjCallRet(msgStrObjGetStr, le.item, &sername, s);

				/* Create a button for the popup menu */
		                ObjCallWarn(msgNewDefaults, clsButton, &bn);

				/* Get defaults for this tk type */
				ObjCallWarn(msgTkTableChildDefaults, choice, &bn);

				/* Make it look like standard popup item */
				bn.label.style.decoration = lsDecorationPopup;
				bn.label.pString = sername;

				/* Give it the index in the list as tag so I can
				 * link it easily to the string list
				 */
				bn.win.tag = le.position;

				ObjCallRet(msgNew, clsButton, &bn, s);

				/* Insert it in the choice */
				Dbg(Debugf(U_L("Inserting %s"), sername);)
				wm.parent = choice;
				wm.options = wsPosTop;
				ObjCallRet(msgWinInsert, bn.object.uid, &wm, s);
			}
		}

		/* Initialize card values */
		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXPortOption)) {

			value = (*pData)->sxSerServIndex;

			ObjCallWarn(msgControlSetValue, control, (P_ARGS)value);
		}

		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXBaudRateOption)) {

			value = (*pData)->sxSerPrefs.spBaudRate;

			ObjCallWarn(msgControlSetValue, control, (P_ARGS)value);
		}

		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXParityOption)) {

			value = (*pData)->sxSerPrefs.spParity;

			ObjCallWarn(msgControlSetValue, control, (P_ARGS)value);
		}

		if (control = (WIN)ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXDataBitsOption)) {

			value = (*pData)->sxSerPrefs.spDataBits;

			ObjCallWarn(msgControlSetValue, control, (P_ARGS)value);
		}

		if (control = (WIN)ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXStopBitsOption)) {

			value = (*pData)->sxSerPrefs.spStopBits;

			ObjCallWarn(msgControlSetValue, control, (P_ARGS)value);
		}

		if (control = (WIN)ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXFlowControlOption)) {

			value =	(*pData)->sxSerPrefs.spFlowControl;

			ObjCallWarn(msgControlSetValue, control, (P_ARGS)value);
		}

		/* Set the correct resource id for the status label;
		 * connected or not.
		 */
		if ((*pData)->sxSerConnected) {
			ObjCallWarn(msgSXSetConnectStatusId, self,
				(P_ARGS)tagSXConnectedStr);
		} else {
			ObjCallWarn(msgSXSetConnectStatusId, self,
				(P_ARGS)tagSXNotConnectedStr);
		}

		/* Mark card as clean */
		ObjCallRet(msgControlSetDirty, pArgs->win, (P_ARGS) false, s);

	} else ObjCallAncestorCtxWarn(ctx);

	Dbg(Debugf(U_L("<< SXOptionProvideCard"));)

	return stsOK;

	MsgHandlerParametersNoWarning;

} /* SXOptionProvideCard */

/*
 * Respond to msgOptionUpdateCard.
 *
 * Self send msgSXResizeCard to force cards to relayout when they are
 * selected.
 */
MsgHandlerWithTypes(SXOptionUpdateCard, P_OPTION_CARD, PP_SX_APP_DATA)
{
	WIN win;
	STATUS s;

	Dbg(Debugf(U_L("SXOptionUpdateCard >>"));)

	ObjCallRet(msgFrameGetClientWin, pArgs->option, &win, s);
	/* New card is coming up, resize it */
	ObjPostU32Warn(msgSXResizeCard, self, win);

	return stsOK;

	MsgHandlerParametersNoWarning;
} /* SXOptionUpdateCard */

/*
 * Respond to msgSXResizeCard.
 *
 * Layout card.
 */
MsgHandlerWithTypes(SXResizeCard, OBJECT , PP_SX_APP_DATA)
{
	WIN_METRICS wm;
	STATUS s;

	wm.options = wsLayoutResize;
	ObjCallRet(msgWinLayout, pArgs, &wm, s);

	return stsOK;

	MsgHandlerParametersNoWarning;
} /* SXResizeCard */

/*
 * Respond to msgOptionApplyCard.
 *
 * Read card values (if dirty) and update serial settings.
 */
MsgHandlerWithTypes(SXOptionApplyCard, P_OPTION_CARD, PP_SX_APP_DATA)
{
	WIN control;
	P_SX_APP_DATA pInst = *pData;
	BOOLEAN	dirty = false;
	U32 value;
	STATUS s;

	Dbg(Debugf(U_L("SXOptionApplyCard >>"));)

	if(pArgs->tag == tagSXAppSerialCard) {
		
		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXPortOption)) {

			ObjCallWarn(msgControlGetDirty, control, &dirty);
			if (dirty) {
				LIST_ENTRY le;
				P_CHAR sername;

				ObjCallWarn(msgControlGetValue, control, &value);
				le.position = pInst->sxSerServIndex = value;

				/* Update name in SerialPrefs */
				ObjCallRet(msgListGetItem, (*pData)->sxSerialNameList, &le, s);
				ObjCallRet(msgStrObjGetStr, le.item, &sername, s);
				Ustrncpy(pInst->sxSerPrefs.spSerServ, sername,nameBufLength * SizeOf(CHAR)); 

				/* Close and reopen port */
				ObjCallWarn(msgSXCloseSerial, self, pNull);
				ObjCallRet(msgSXOpenSerial, self, pNull, s);
				/* Initialize again */
				ObjCallWarn(msgSXSetSerialMetrics, self, (P_ARGS)SET_SERIAL_ALL);
			}
		}

		/* To demonstrate the various SIO messages I'll update each
		 * setting separately. Obviously, this is not very efficient
		 * if more settings are to be changed. For clarity all serial
		 * I/O is done in sxser.c (SetSerialMetrics)
		 */
		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXBaudRateOption)) {

			ObjCallWarn(msgControlGetDirty, control, &dirty);
			if (dirty) {
				ObjCallWarn(msgControlGetValue, control, &value);
				pInst->sxSerPrefs.spBaudRate = value;
				ObjCallWarn(msgSXSetSerialMetrics, self,
					(P_ARGS)SET_SERIAL_BAUDRATE);
			}
		}

		if (control = (WIN) ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXParityOption)) {

			ObjCallWarn(msgControlGetDirty, control, &dirty);
			if (dirty) {
				ObjCallWarn(msgControlGetValue, control, &value);
				pInst->sxSerPrefs.spParity = (SIO_PARITY)value;
				ObjCallWarn(msgSXSetSerialMetrics, self,
					(P_ARGS)SET_SERIAL_LINECONTROL);
			}
		}

		if (control = (WIN)ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXDataBitsOption)) {

			ObjCallWarn(msgControlGetDirty, control, &dirty);
			if (dirty) {
				ObjCallWarn(msgControlGetValue, control, &value);
				pInst->sxSerPrefs.spDataBits = (SIO_DATA_BITS)value;
				ObjCallWarn(msgSXSetSerialMetrics, self,
					(P_ARGS)SET_SERIAL_LINECONTROL);
			}
		}
		if (control = (WIN)ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXStopBitsOption)) {

			ObjCallWarn(msgControlGetDirty, control, &dirty);
			if (dirty) {
				ObjCallWarn(msgControlGetValue, control, &value);
				pInst->sxSerPrefs.spStopBits = (SIO_STOP_BITS)value;
				ObjCallWarn(msgSXSetSerialMetrics, self,
					(P_ARGS)SET_SERIAL_LINECONTROL);
			}
		}
		if (control = (WIN)ObjectCall(msgWinFindTag, pArgs->win,
			(P_ARGS) tagSXFlowControlOption)) {

			ObjCallWarn(msgControlGetDirty, control, &dirty);
			if (dirty) {
				ObjCallWarn(msgControlGetValue, control, &value);
				pInst->sxSerPrefs.spFlowControl = (SIO_FLOW_TYPE)value;
				ObjCallWarn(msgSXSetSerialMetrics, self,
					(P_ARGS)SET_SERIAL_FLOWCONTROL);
			}
		}
	} else ObjCallAncestorCtxWarn(ctx);

	Dbg(Debugf(U_L("<< SXOptionApplyCard"));)

	return stsOK;

	MsgHandlerParametersNoWarning;
} /* SXOptionApplyCard */

/*
 * Respond to msgSXSetConnectStatusId.
 *
 * Set new resource Id for connection status label.
 * A custom handler is provided for this (instead of just calling
 * msgLabelSetStringid) because the toolkit accidently sets the 
 * infoType to zero.
 */
MsgHandlerWithTypes(SXSetConnectStatusId, P_ARGS, PP_SX_APP_DATA)
{
	P_SX_APP_DATA pInst = *pData;
	LABEL_STYLE ls;
	OBJECT label;
	STATUS s;

	Dbg(Debugf(U_L("SXSetConnectStatusId >>"));)

	/* Only update label if card has been created */
	if (pInst->sxOptWin) {
		if (label = (WIN)ObjectCall(msgWinFindTag, pInst->sxOptWin,
			(P_ARGS) tagSXConnected)) {

			/* A small bug in the toolkit makes it necessary to set the
			 * infotype back to lsInfoStringId.
			 */
			ObjCallRet(msgLabelGetStyle, label, &ls, s);

			ls.infoType = lsInfoStringId;

			ObjCallWarn(msgLabelSetStyle, label, &ls);

			/* Set new resid */
			ObjCallWarn(msgLabelSetStringId, label, pArgs);
		}
	}

	Dbg(Debugf(U_L("<< SXSetConnectStatusId"));)

	return stsOK;

	MsgHandlerParametersNoWarning;
} /* SXSetConnectStatusId */

