UNIT Maus;
INTERFACE USES crt,Dos;

CONST mausda : Boolean = False;
      LEFT = 1;
      RIGHT = 2;

FUNCTION  MausInit : Boolean;
PROCEDURE MausPic(x,y,s,o:Word);
PROCEDURE MausPage(page:Integer);
PROCEDURE MausPos(VAR x,y:Integer);
FUNCTION  MausX : Integer;
FUNCTION  MausY : Integer;
PROCEDURE SetzMaus(x,y:Integer);
FUNCTION  MausKey: Integer;
PROCEDURE MausPfeilEin;
PROCEDURE MausPfeilAus;
PROCEDURE MausOn(ja:Boolean);
PROCEDURE MausReaktion(x,y:Integer);
{PROCEDURE Swap(VAR z1,z2:Integer);}
PROCEDURE MausGrenze(x1,y1,x2,y2:Integer);
FUNCTION  MausIn(x1,y1,x2,y2:Integer) : Boolean;
FUNCTION  MausWahl(x1,y1,x2,y2,taste:Integer) : Boolean;
FUNCTION  LastMausKey : Integer;

IMPLEMENTATION
VAR reg        : Registers;
    mausvector : Pointer;

FUNCTION MausInit : Boolean;
BEGIN
  MausInit:=False;
  GetIntVec($33,mausvector);
  IF mausvector = NIL THEN Exit;
  IF Byte(mausvector^)=$CF THEN Exit;  { $CF = Code fr 'IRET' }
  reg.ax:=0;
  Intr($33,reg);
  mausda := reg.ax <> 0;
  MausInit := mausda;
END;

PROCEDURE MausPic(x,y,s,o:Word);
BEGIN
  reg.ax:=9;
  reg.bx:=x;
  reg.cx:=y;
  reg.dx:=o;
  reg.es:=s;
  Intr($33,reg);
END;

PROCEDURE MausPage(page:Integer);
BEGIN
  reg.ax := 29;
  reg.bx := page;
  Intr($33,reg);
END;

PROCEDURE MausPos(VAR x,y:Integer);
BEGIN
  reg.ax := 3;
  Intr($33,reg);
  y := reg.dx;
  x := reg.cx;
END;

FUNCTION  MausX : Integer;
BEGIN
  reg.ax := 3;
  Intr($33,reg);
  MausX := reg.cx;
END;

FUNCTION  MausY : Integer;
BEGIN
  reg.ax := 3;
  Intr($33,reg);
  MausY := reg.dx;
END;

PROCEDURE SetzMaus(x,y:Integer);
BEGIN
  reg.ax := 4;
  reg.cx := x;
  reg.dx := y;
  Intr($33,reg);
END;

FUNCTION MausKey : Integer;
BEGIN
  reg.ax := 3;
  Intr($33,reg);
  MausKey := reg.bx;
END;

PROCEDURE MausPfeilEin;
BEGIN
  reg.ax:=1;
  Intr($33,reg);
END;

PROCEDURE MausPfeilAus;
BEGIN
  reg.ax:=2;
  Intr($33,reg);
END;

PROCEDURE MausOn(ja:Boolean);
CONST aus : Boolean = True;
BEGIN
  CASE ja OF
    True:  IF aus THEN BEGIN
             MausPfeilEin;
             aus:=False;
           END;
    False: IF Not aus THEN BEGIN
             MausPfeilAus;
             aus:=True;
           END;
  END;
END;

PROCEDURE MausReaktion(x,y:Integer);
BEGIN
  reg.ax:=15;
  reg.cx:=x;
  reg.dx:=y;
  Intr($33,reg);
END;

PROCEDURE Swap(VAR z1,z2:Integer);
VAR z : Integer;
BEGIN z:=z1;
      z1:=z2;
      z2:=z;
END;

PROCEDURE MausGrenze(x1,y1,x2,y2:Integer);
BEGIN
  IF x1>x2 THEN Swap(x1,x2);
  IF y1>y2 THEN Swap(y1,y2);
  reg.ax:=7;
  reg.cx:=x1;
  reg.dx:=x2;
  Intr($33,reg);
  reg.ax:=8;
  reg.cx:=y1;
  reg.dx:=y2;
  Intr($33,reg);
END;

FUNCTION MausIn(x1,y1,x2,y2:Integer) : Boolean;
VAR mx,my : Integer;
BEGIN
  IF x1>x2 THEN Swap(x1,x2);
  IF y1>y2 THEN Swap(y1,y2);
  MausPos(mx,my);
  mx := mx shr 3;
  my := my shr 3;
  dec(mx); inc(my);
  if (mx>=x1) And (mx<=x2) And (my>=y1) And (my<=y2) then
    MausIn := true
  else
    MausIn := false;
END;

FUNCTION MausWahl(x1,y1,x2,y2,taste:Integer) : Boolean;
BEGIN
  MausWahl:=MausIn(x1,y1,x2,y2) And (MausKey=taste);
END;

FUNCTION LastMausKey : Integer;    { fr Maustaste 1 und 2 }
VAR count0, count1 : Integer;
BEGIN
  reg.ax:=6;
  reg.bx:=0;
  Intr($33,reg);
  reg.ax:=6;
  reg.bx:=1;
  Intr($33,reg);         { beide Tastenzhler auf 0 setzen }
  WHILE MausKey<>0 DO;   { warten, bis alle Tasten frei    }
  reg.ax:=6;
  reg.bx:=0;
  Intr($33,reg);
  count0:=Ord(reg.bx>0);
  reg.ax:=6;
  reg.bx:=1;
  Intr($33,reg);
  count1:=Ord(reg.bx>0);
  LastMausKey := count0 + 2*count1;
END;

END.

