
/*=========================================================================*/
/* Konzept        : DATA BECKERs Sound Blaster Superbuch                   */
/* Prog. Waves    : Simuliert Wellengerusche - ein Beispiel fr die di-   */
/*                  rekte DSP-Programmierung.                              */
/*=========================================================================*/
/* Autor          : Arthur Burda                                           */
/* Dateiname      : WAVES.C                                                */
/* entwickelt am  : 08.07.1993                                             */
/* letztes Update : 01.09.1993                                             */
/* Version        : 1.03                                                   */
/* Compiler       : Turbo C, Turbo C++, Borland C++                        */
/*=========================================================================*/

#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <stdlib.h>
#include <time.h>
#include "sbdsp.h"

/*=========================================================================*/
/* Wave: Erzeugt ein Wellengerusch mit der Ausgabe-Frequenz von 5 kHz     */
/*       (5000 Hz). Es sind insgesamt 5 verschiedene Wellengerusche mg-  */
/*       lich.                                                             */
/*=========================================================================*/
/* Eingabe: Num = Nummer des Wellengerusches (1..5)                       */
/* Ausgabe: keine                                                          */
/*-------------------------------------------------------------------------*/

void Wave(Byte Num)

{
  #define Freq 5000

  Byte    *DataBuf;                                         /* Datenpuffer */
  LongInt Count;                                             /* ein Zhler */
  float   Help;                                           /* Hilfsvariable */

  switch(Num)
  {
    case 1 :
      DataBuf = (Byte *)malloc(60000);        /* Speicherplatz reservieren */
      if (!DataBuf)
	{
	  printf("\n");
	  printf("Fehler: Kann nicht Speicherplatz reservieren.\n");
	  exit(1);                                     /* Programm beenden */
	}

      /* Wellengerusch generieren */

      for (Count = 0; Count <= 19999; Count++)
	{
	  Help = Count/(100+((20000-Count)/20));
	  DataBuf[Count] = random((int)Help);
	}
      for (Count = 20000; Count <= 59999; Count++)
	{
	  Help = (60000-Count)/200;
	  DataBuf[Count] = random((int)Help);
	}

      /* Gerusch ist jetzt zu hren. */

      PlayDirect(DataBuf, 60000, Freq, FALSE);

      free(DataBuf);                            /* Speicherplatz freigeben */
      break;
    case 2 :
      DataBuf = (Byte *)malloc(60000);
      if (!DataBuf)
	{
	  printf("\n");
	  printf("Fehler: Kann nicht Speicherplatz reservieren.\n");
	  exit(1);
	}
      for (Count = 0; Count <= 9999; Count++)
	{
	  Help = Count/200;
	  DataBuf[Count] = random((int)Help);
	}
      for (Count = 10000; Count <= 59999; Count++)
	{
	  Help = (60000-Count)/1000;
	  DataBuf[Count] = random((int)Help);
	}
      PlayDirect(DataBuf, 60000, Freq, FALSE);
      free(DataBuf);
      break;
    case 3 :
      DataBuf = (Byte *)malloc(40000);
      if (!DataBuf)
	{
	  printf("\n");
	  printf("Fehler: Kann nicht Speicherplatz reservieren.\n");
	  exit(1);
	}
      for (Count = 0; Count <= 10999; Count++)
	{
	  Help = Count/200;
	  DataBuf[Count] = random((int)Help);
	}
      for (Count = 11000; Count <= 39999; Count++)
	{
	  Help = (40000-Count)/400;
	  DataBuf[Count] = random((int)Help);
	}
      PlayDirect(DataBuf, 40000, Freq, FALSE);
      free(DataBuf);
      break;
    case 4 :
      DataBuf = (Byte *)malloc(20000);
      if (!DataBuf)
	{
	  printf("\n");
	  printf("Fehler: Kann nicht Speicherplatz reservieren.\n");
	  exit(1);
	}
      for (Count = 0; Count <= 8999; Count++)
	{
	  Help = Count/50;
	  DataBuf[Count] = random((int)Help);
	}
      for (Count = 9000; Count <= 19999; Count++)
	{
	  Help = (20000-Count)/90;
	  DataBuf[Count] = random((int)Help);
	}
      PlayDirect(DataBuf, 20000, Freq, FALSE);
      free(DataBuf);
      break;
    case 5 :
      DataBuf = (Byte *)malloc(60000);
      if (!DataBuf)
	{
	  printf("\n");
	  printf("Fehler: Kann nicht Speicherplatz reservieren.\n");
	  exit(1);
	}
      for (Count = 0; Count <= 14999; Count++)
	{
	  Help = Count/400;
	  DataBuf[Count] = random((int)Help);
	}
      for (Count = 15000; Count <= 19999; Count++)
	{
	  Help = Count/(100+((20000-Count)/10));
	  DataBuf[Count] = random((int)Help);
	}
      for (Count = 20000; Count <= 59999; Count++)
	{
	  Help = (60000-Count)/200;
	  DataBuf[Count] = random((int)Help);
	}
      PlayDirect(DataBuf, 60000, Freq, FALSE);
      free(DataBuf);
  }
}

/*-------------------------------------------------------------------------*/
/* main: Hauptprogramm                                                     */
/*-------------------------------------------------------------------------*/

void main()

{
  char Num;                                 /* Nummer des Wellengerusches */

  randomize();                    /* Zufallszahlengenerator initialisieren */
  textcolor(LIGHTGRAY);                              /* Textfarbe hellgrau */
  clrscr();                                          /* Bildschirm lschen */
  printf("  DATA BECKERs Sound Blaster Superbuch  *  WAVES  *  (c) ");
  printf("1993 by Arthur Burda\n");
  printf("");
  printf("\n");
  printf("Sie hren jetzt verschiedene Wellengerusche (Meeresrauschen).");
  printf("\n\n");
  printf("Drcken Sie irgendeine Taste, um die Demo zu beenden ...\n");
  InitDSP();                                         /* DSP initialisieren */
  while(!kbhit())     /* solange wiederholen, bis eine Taste gedrckt wird */
    {
      Num = random(5)+1; /* Nummer des Wellengerusches zufllig ermitteln */
      Wave(Num);          /* Gerusch auf der Sound Blaster-Karte ausgeben */
    }
};
