
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Programm Timer : Ein einfaches Beispiel fr die Timer-Programmierung      }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : TIMER.PAS                                                }
{ entwickelt am  : 20.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM Timer;

USES CRT;                                              { Unit CRT einbinden }

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Freq   : LongInt;                                         { akt. Frequenz }
  Factor : LongInt;                         { Frequenz-Faktor fr den Timer }

BEGIN
  ClrScr;                                              { Bildschirm lschen }
  Port[$43] := $36;                                          { Steuerbefehl }
  FOR Freq := 100 TO 2000 DO               { Frequenzen von 100 bis 2000 Hz }
    BEGIN
      Factor := 1193180 DIV Freq;               { Frequenz-Faktor bestimmen }
      Port[$40] := Lo(Factor);         { Low-Byte fr den Timer-Wert setzen }
      Port[$40] := Hi(Factor);        { High-Byte fr den Timer-Wert setzen }
      WriteLn('Akt. Timer-Frequenz: ', Freq, ' Hz    Faktor: ', Factor);
    END;

  { Original-Frequenz von 18,2 Hz einstellen }

  Factor := $FFFF;
  Port[$40] := Lo(Factor);                { Low-Byte fr die Timer-Frequenz }
  Port[$40] := Hi(Factor);               { High-Byte fr den Timer-Frequenz }
END.
