
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. HexBin   : Ein Beispielprogramm, das die Umrechnung von hexadezima- }
{                  len und binren Zahlen in Dezimalzahlen demonstriert.    }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : HEXBIN.PAS                                               }
{ entwickelt am  : 23.04.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM HexBin;

USES CRT;                                              { Unit CRT einbinden }

TYPE

  {-------------------------------------------------------------------------}
  { String-Typen                                                            }
  {-------------------------------------------------------------------------}

  String4 = String[4];
  String8 = String[8];

{===========================================================================}
{ Funktion HexToDec: Wandelt eine hexadezimale Zahl, die als String vor-    }
{                    liegt, in einen Dezimalwert um.                        }
{===========================================================================}
{ Eingabe: HexStr = hexadezimale Zahl in String-Form                        }
{ Ausgabe: eine dezimale Zahl bzw. der Wert 0, wenn der Hex-String nicht    }
{          korrekt oder leer ist                                            }
{---------------------------------------------------------------------------}

FUNCTION HexToDec(HexStr : String4) : Word;

VAR
  Len     : Byte;                                     { String-Lnge HexStr }
  Count   : Word;                                              { ein Zhler }
  Fail    : Boolean;  { TRUE, wenn ein Zeichen in dem Hex-String falsch ist }
  Mult    : LongInt;                                        { Multiplikator }
  Ch      : Char;                    { Zeichen, das gerade umgewandelt wird }
  Decimal : Word;                                             { Dezimalwert }

BEGIN
  HexToDec := 0;
  IF HexStr <> '' THEN                             { Hex-String nicht leer? }
    BEGIN                                        { nein, Umwandlung starten }
      Len := Length(HexStr);                   { Lnge von HexStr ermitteln }
      Count := Len;                                         { Zhler setzen }
      Fail := FALSE;                                      { noch alles o.k. }
      Mult := 1;                               { Multiplikator auf 1 setzen }
      Decimal := 0;                           { Dezimalwert ist am Anfang 0 }
      REPEAT                                              { Schleifenanfang }
        Ch := UpCase(HexStr[Count]);                    { Zeichen bestimmen }
        CASE Ch OF                     { die eigentliche Umwandlung beginnt }
          '0'..'9' :
            Inc(Decimal, Mult*(Byte(Ch)-48));
          'A'..'F' :
            Inc(Decimal, Mult*(Byte(Ch)-55));
        ELSE                           { ein falsches Zeichen im Hex-String }
          Fail := TRUE;                              { Umwandlung abbrechen }
        END;
        Dec(Count);                                    { Zhler erniedrigen }
        Mult := 16*Mult;                             { Multiplikator mal 16 }
      UNTIL (Count = 0) OR Fail;                            { Schleifenende }
      IF NOT Fail THEN      { wenn alles o.k., dann Dezimalwert zurckgeben }
        HexToDec := Decimal
      ELSE                                     { ein Fehler ist aufgetreten }
        HexToDec := 0;
    END;
END;

{===========================================================================}
{ Funktion BinToDec: Wandelt eine Binrzahl in Form eines Strings in einen  }
{                    Dezimalwert um. Die erste Stelle im String ist Bitwert }
{                    128 (2^7), die letzte Bitwert 1 (2^0).                 }
{===========================================================================}
{ Eingabe: Binrwert als String                                             }
{ Ausgabe: Dezimalwert bzw. 0, wenn der Binrstring nicht korrekt oder leer }
{          ist                                                              }
{---------------------------------------------------------------------------}

FUNCTION BinToDec(BinStr : String8) : Word;

VAR
  Len     : Byte;                                     { String-Lnge BinStr }
  Count   : Word;                                              { ein Zhler }
  Fail    : Boolean; { TRUE, wenn ein Zeichen in dem Binrstring falsch ist }
  BitVal  : Word;                                                 { Bitwert }
  Ch      : Char;                    { Zeichen, das gerade umgewandelt wird }
  Decimal : Word;                                             { Dezimalwert }

BEGIN
  BinToDec := 0;
  Len := Length(BinStr);                       { Lnge von BinStr ermitteln }
  IF Len = 8 THEN                          { BinStr mu 8 Zeichen lang sein }
    BEGIN
      Count := Len;                                         { Zhler setzen }
      Fail := FALSE;                                      { noch alles o.k. }
      BitVal := 1;                                   { Bitwert auf 1 setzen }
      Decimal := 0;                           { Dezimalwert ist am Anfang 0 }
      REPEAT                                              { Schleifenanfang }
        Ch := BinStr[Count];                            { Zeichen bestimmen }
        CASE Ch OF                     { die eigentliche Umwandlung beginnt }
          '0' :           { "0" gefunden, der Dezimalwert ndert sich nicht }
            BEGIN
            END;
          '1' :                        { "1" gefunden, Bitwert dazuaddieren }
            Decimal := Decimal+BitVal;
        ELSE                          { ein falsches Zeichen im Binrstring }
          Fail := TRUE;                              { Umwandlung abbrechen }
        END;
        Dec(Count);                                    { Zhler erniedrigen }
        BitVal := 2*BitVal;                            { Bitwert verdoppeln }
      UNTIL (Count = 0) OR Fail;                            { Schleifenende }
      IF NOT Fail THEN      { wenn alles o.k., dann Dezimalwert zurckgeben }
        BinToDec := Decimal
      ELSE                                     { ein Fehler ist aufgetreten }
        BinToDec := 0;
    END;
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Ch : Char;

BEGIN
  ClrScr;                                              { Bildschirm lschen }
  WriteLn('Hex-Wert: 4F2Ch    Dezimalwert: ', HexToDec('4F2C'));
  WriteLn('Hex-Wert: 01FCh    Dezimalwert: ', HexToDec('01FC'));
  WriteLn('Hex-Wert: 6F34h    Dezimalwert: ', HexToDec('6F34'));
  WriteLn('Hex-Wert: 29D1h    Dezimalwert: ', HexToDec('29D1'));
  WriteLn('Hex-Wert: 7106h    Dezimalwert: ', HexToDec('7106'));
  WriteLn;
  WriteLn('Binrwert: 01100111b    Dezimalwert: ', BinToDec('01100111'));
  WriteLn('Binrwert: 11100011b    Dezimalwert: ', BinToDec('11100011'));
  WriteLn('Binrwert: 00010011b    Dezimalwert: ', BinToDec('00010011'));
  WriteLn('Binrwert: 10000100b    Dezimalwert: ', BinToDec('10000100'));
  WriteLn('Binrwert: 11110101b    Dezimalwert: ', BinToDec('11110101'));

  { warten, bis eine Taste gedrckt wird }

  REPEAT
  UNTIL KeyPressed;

  Ch := ReadKey;                                            { Zeichen lesen }
END.
