
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. FMDemo4  : Ein Demo-Programm fr die direkte Programmierung der FM- }
{                  Kanle und des Mischer-Chips des Sound Blaster Pro.      }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : FMDEMO4.PAS                                              }
{ entwickelt am  : 08.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.02                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM FMDemo4;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$D-}                                        { keine Debugger-Informationen }
{$F-}                                        { FAR-Aufrufe sind nicht ntig }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES CRT, SBFM, SBMixer;           { CRT-, SBFM- und SBMixer-Unit einbinden }

CONST

  {-------------------------------------------------------------------------}
  { Tastaturcodes                                                           }
  {-------------------------------------------------------------------------}

  kb_Enter = #13;
  kb_Space = #32;

TYPE

  {=========================================================================}
  { TChannelParam: Parameter der Operatorzellen Modulator und Trger eines  }
  {                FM-Kanals                                                }
  {=========================================================================}

  TChannelParam = RECORD
    MultFactor   : Byte;                     { Multiplikationsfaktor (0-15) }
    EnvelopeType : TEnvelope;   { Art der Hllkurve (Dimishing, Continuing) }
    Vibrato      : Boolean;                         { Vibrato-Effekt an/aus }
    VibratoLevel : Byte;                             { Vibrato-Strke (0-1) }
    Tremolo      : Boolean;                         { Tremolo-Effekt an/aus }
    TremoloLevel : Byte;                             { Tremolo-Strke (0-1) }
    Attenuation  : Byte;                           { Dmpfungsfaktor (0-63) }
    Attack       : Byte;                          { Attack-Parameter (0-15) }
    Decay        : Byte;                                { Decay-Rate (0-15) }
    Sustain      : Byte;                         { Sustain-Parameter (0-15) }
    Release      : Byte;                         { Release-Parameter (0-15) }
    WaveForm     : Byte;                                 { Wellenform (0-3) }
    Connection   : TCellConnection;  { Zellenverknpfung (Parallel, Serial) }
    Feedback     : Byte;                          { Rckkopplungsgrad (0-7) }
    Freq         : Word;                      { Frequenz-Parameter (0-1023) }
    Octave       : Byte;                                     { Oktave (0-7) }
  END;

{===========================================================================}
{ Prozedur SetChannelParam: Setzt die Parameter der beiden Operatorzellen   }
{                           (Modulator und Trger) eines Kanals.            }
{===========================================================================}
{ Eingabe: Channel = Nummer des Kanals (0-8)                                }
{          Param   = Parameter fr die Modulator- und Trgerzelle           }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE SetChannelParam(Channel : Byte; Param : TChannelParam);

VAR
  Modulator : Byte;                             { Modulatorzelle des Kanals }
  Carrier   : Byte;                                { Trgerzelle des Kanals }

BEGIN
  Modulator := sbfm_ModCellNum[Channel];
  Carrier := sbfm_CarrCellNum[Channel];

  WITH Param DO
    BEGIN

      { Multiplikationsfaktor fr Modulator und Trger setzen }

      SetMultFactor(Modulator, Mono, MultFactor);
      SetMultFactor(Carrier, Mono, MultFactor);

      { Art der Hllkurve setzen }

      SetEnvelopeType(Modulator, Mono, EnvelopeType);
      SetEnvelopeType(Carrier, Mono, EnvelopeType);

      { Vibrato- und Tremolo-Effekt sowie deren Strke setzen }

      SetVibrato(Modulator, Mono, Vibrato, VibratoLevel);
      SetVibrato(Carrier, Mono, Vibrato, VibratoLevel);
      SetTremolo(Modulator, Mono, Tremolo, TremoloLevel);
      SetTremolo(Carrier, Mono, Tremolo, TremoloLevel);

      { Dmpfungsfaktor setzen }

      SetAttenuation(Modulator, Mono, Attenuation);
      SetAttenuation(Carrier, Mono, Attenuation);

      { Attack-Parameter setzen }

      SetAttack(Modulator, Mono, Attack);
      SetAttack(Carrier, Mono, Attack);

      { Decay-Parameter setzen }

      SetDecay(Modulator, Mono, Decay);
      SetDecay(Carrier, Mono, Decay);

      { Sustain-Parameter setzen }

      SetSustain(Modulator, Mono, Sustain);
      SetSustain(Carrier, Mono, Sustain);

      { Release-Parameter setzen }

      SetRelease(Modulator, Mono, Release);
      SetRelease(Carrier, Mono, Release);

      { Wellenform des Modulators und des Trgers setzen }

      SetWaveForm(Modulator, Mono, WaveForm);
      SetWaveForm(Carrier, Mono, WaveForm);

      SetConnection(Channel, Mono, Connection);    { Zellenverknpfungsart, }
      SetFeedback(Channel, Mono, Feedback);            { Rckkopplungsgrad, }
      SetChannelFreq(Channel, Mono, Freq);                       { Frequenz }
      SetOctave(Channel, Mono, Octave);                 { und Oktave setzen }
    END;
END;

{===========================================================================}
{ Prozedur ShowChannelParam: Zeigt die Parameter-Einstellung fr einen Ka-  }
{                            nal auf dem Bildschirm an.                     }
{===========================================================================}
{ Eingabe: Channel = Nummer des Kanals (0-8)                                }
{          Param   = Parameter fr die Modulator- und Trgerzelle           }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE ShowChannelParam(Channel : Byte; Param : TChannelParam);

VAR
  ChannelStr : String;

BEGIN
  Str(Channel, ChannelStr);
  WriteLn('Parameter-Einstellung fr den Kanal '+ChannelStr+':');
  WriteLn(''+
    '');
  GotoXY(42, 3);
  WriteLn('');
  WITH Param DO
    BEGIN
      WriteLn('Multiplikationsfaktor : ', MultFactor);
      Write('Art der Hllkurve     : ');
      CASE EnvelopeType OF
        Dimishing :
          WriteLn('abnehmend');
        Continuing :
          WriteLn('kontinuierlich');
      END;
      Write('Vibrato-Effekt        : ');
      IF Vibrato THEN
        WriteLn('an')
      ELSE
        WriteLn('aus');
      Write('Vibrato-Level         : ');
      IF VibratoLevel = 0 THEN
        WriteLn('schwach')
      ELSE
        WriteLn('stark');
      Write('Tremolo-Effekt        : ');
      IF Tremolo THEN
        WriteLn('an')
      ELSE
        WriteLn('aus');
      Write('Tremolo-Level         : ');
      IF TremoloLevel = 0 THEN
        WriteLn('schwach')
      ELSE
        WriteLn('stark');
      WriteLn('Dmpfungsparameter    : ', Attenuation);
      WriteLn('Attack-Parameter      : ', Attack);
      GotoXY(42, 4);
      WriteLn(' Decay-Parameter       : ', Decay);
      GotoXY(42, 5);
      WriteLn(' Sustain-Parameter     : ', Sustain);
      GotoXY(42, 6);
      WriteLn(' Release-Parameter     : ', Release);
      GotoXY(42, 7);
      WriteLn(' Wellenform            : ', WaveForm);
      GotoXY(42, 8);
      Write(' Zellenverknpfungsart : ');
      CASE Connection OF
        Parallel :
          WriteLn('parallel');
        Serial :
          WriteLn('seriell');
      END;
      GotoXY(42, 9);
      WriteLn(' Rckkopplungsgrad     : ', Feedback);
      GotoXY(42, 10);
      WriteLn(' Frequenz-Parameter    : ', Freq);
      GotoXY(42, 11);
      WriteLn(' Oktave                : ', Octave);
    END;
  GotoXY(42, 12);
  WriteLn('');
  WriteLn(''+
    '');
  WriteLn;
  TextAttr := 12;                                       { Textfarbe hellrot }
  GotoXY(23, 15);
  WriteLn('[Space] = Ton hren  [Enter] = Ende');
  TextAttr := 7;                                       { Textfarbe hellgrau }
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Param0 : TChannelParam;                    { Parameter fr den FM-Kanal 0 }
  Key    : Char;                                               { Tastencode }

BEGIN
  TextColor(LightGray);                                { Textfarbe hellgrau }
  ClrScr;                                              { Bildschirm lschen }
  WriteLn(' DATA BECKERs Sound Blaster Superbuch  *  FMDEMO4  *  (c) '+
    '1993 by Arthur Burda');
  WriteLn(''+
    '');
  WriteLn('Dieses Programm demonstriert nicht nur die Mglichkeiten '+
    'des FM-Synthesizers,');
  WriteLn('sondern auch des Mischer-Chips der Sound Blaster Pro-Karte. '+
    'Drcken Sie mehrmals');
  WriteLn('[Space], um die Effekte zu hren.');
  Window(1, 9, 80, 25);
  Randomize;                        { Zufallszahlengenerator initialisieren }
  MixerReset;                                     { Reset des Mischer-Chips }
  SetMasterVolume(Left_, 255);         { Gesamtlautstrke des linken Kanals }
  SetMasterVolume(Right_, 255);       { Gesamtlautstrke des rechten Kanals }

  { Parameter fr den Ton auf dem Kanal 0 setzen }

  WITH Param0 DO
    BEGIN
      MultFactor := 1;
      EnvelopeType := Continuing;
      Vibrato := FALSE;
      VibratoLevel := 0;
      Tremolo := TRUE;
      TremoloLevel := 0;
      Attenuation := 0;
      Attack := 6;
      Decay := 2;
      Sustain := 8;
      Release := 12;
      WaveForm := 2;
      Connection := Serial;
      Feedback := 2;
      Freq := 400;
      Octave := 1;
    END;

  SetChannelParam(0, Param0);
  ShowChannelParam(0, Param0);      { Parameter auf dem Bildschirm anzeigen }
  REPEAT
    Key := ReadKey;                                   { Tastencode abfragen }
    IF Key = kb_Space THEN                              { [Space] gedrckt? }
      BEGIN

        { FM-Lautstrke fr den linken und rechten Stereo-Kanal }
        { abhngig von einer Zufallszahl bestimmen              }

        CASE Random(5) OF
          0 :
            BEGIN
              SetFMVolume(Left_, 0);
              SetFMVolume(Right_, 255);
            END;
          1 :
            BEGIN
              SetFMVolume(Left_, 255);
              SetFMVolume(Right_, 0);
            END;
          2 :
            BEGIN
              SetFMVolume(Left_, 255);
              SetFMVolume(Right_, 255);
            END;
          3 :
            BEGIN
              SetFMVolume(Left_, 0);
              SetFMVolume(Right_, 152);
            END;
          4 :
            BEGIN
              SetFMVolume(Left_, 152);
              SetFMVolume(Right_, 0);
            END;
        END;

        { Output-Filter nach Zufall an- und ausschalten }

        IF Random(2) = 1 THEN
          SetOutputFilter(TRUE)
        ELSE
          SetOutputFilter(FALSE);

        SetTone(0, Mono, FALSE);        { Kanal zunchst einmal ausschalten }
        SetTone(0, Mono, TRUE);             { und danach sofort einschalten }
      END;
  UNTIL Key = kb_Enter;    { solange wiederholen, bis [Enter] gedrckt wird }
  SetTone(0, Mono, FALSE);                              { Kanal ausschalten }
  MixerReset;                 { zum Schlu noch ein Reset des Mischer-Chips }
  Window(1, 1, 80, 25);
  ClrScr;
END.
