
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. Explode  : Ein Explosionsgerusch - ein Beispiel fr die Verwendung }
{                  der Unit SBDSP.                                          }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : EXPLODE.PAS                                              }
{ entwickelt am  : 08.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.03                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM Explode;

{$D-}                                        { keine Debugger-Informationen }
{$F-}                                        { FAR-Aufrufe sind nicht ntig }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

{$M 16384,131072,655360}       { 16 KB Stack, min. 128 KB Heap, max. 640 KB }

USES CRT, SBDSP;                            { Units CRT und SBDSP einbinden }

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Count1, Count2 : Word;                                           { Zhler }

BEGIN
  Randomize;                        { Zufallszahlengenerator initialisieren }
  TextColor(LightGray);                                { Textfarbe hellgrau }
  ClrScr;                                              { Bildschirm lschen }
  WriteLn(' DATA BECKERs Sound Blaster Superbuch  *  EXPLODE  *  (c) '+
    '1993 by Arthur Burda');
  WriteLn(''+
    '');
  WriteLn('Sie hren jetzt ein Explosionsgerusch.');
  InitDSP;                                             { DSP initialisieren }

  { Explosionsgerusch erzeugen }

  Speaker_On;                                            { Lautsprecher ein }
  FOR Count1 := 10 DOWNTO 2 DO
    FOR Count2 := 1 TO 20 DO
      BEGIN
        WriteDirect(Random(100));
        Delay(Count1);
      END;
  FOR Count2 := 1 TO 1000 DO
    BEGIN
      WriteDirect(Random(200+Round(Count2/20)));
      Delay(1);
    END;
  FOR Count2 := 1 TO 1000 DO
    BEGIN
      WriteDirect(Random(40+Round((1000-Count2)/20)));
      Delay(1);
    END;
  FOR Count2 := 1 TO 1000 DO
    BEGIN
      WriteDirect(Random(200+Round(Count2/20)));
      Delay(1);
    END;
  FOR Count1 := 2 TO 10 DO
    FOR Count2 := 1 TO 20 DO
      BEGIN
        WriteDirect(Random(100));
        Delay(Count1);
      END;
  Speaker_Off;                                           { Lautsprecher aus }
END.
