
/*=========================================================================*/
/* Konzept        : DATA BECKERs Sound Blaster Superbuch                   */
/* Header DMA     : Enthlt Bitmasken zum Setzen und Lesen der Register    */
/*                  des DMA-Controllers sowie Typschemas der in dem Modul  */
/*                  DMA.C implementierten Funktionen.                      */
/*                  In einem PC-XT ist nur ein DMA-Controller vorhanden,   */
/*                  in einem PC-AT zwei. Hier werden beide Controller un-  */
/*                  tersttzt. Die Kanle 4-7 des zweiten DMA-Controllers  */
/*                  entsprechen im folgenden den Kanlen 0-3 (wie beim     */
/*                  ersten Controller).                                    */
/*=========================================================================*/
/* Autor          : Arthur Burda                                           */
/* Dateiname      : DMA.H                                                  */
/* entwickelt am  : 04.07.1993                                             */
/* letztes Update : 01.09.1993                                             */
/* Version        : 1.05                                                   */
/* Compiler       : Turbo C, Turbo C++, Borland C++                        */
/*=========================================================================*/

/*-------------------------------------------------------------------------*/
/* Bitmasken zum Setzen des Befehlsregisters (nur Schreibzugriff), das     */
/* die Auswahl verschiedener Arbeitsweisen des DMA-Controllers erlaubt.    */
/*-------------------------------------------------------------------------*/

/* Bit 0: gesetzt  = Memory-To-Memory-bertragung eingeschaltet */
/*        gelscht = Memory-To-Memory-bertragung ausgeschaltet */

#define dma_CmdReg_EnableMemToMem  0x01
#define dma_CmdReg_DisableMemToMem 0x00

/* Bit 1: gesetzt  = Kanal 0/4 liest immer von derselben Speicheradresse */
/*        gelscht = Kanal 0/4 arbeitet im normalen Modus, d.h. die      */
/*                   Speicheradresse wird je nach Programmierung in-     */
/*                   krementiert (erhht) oder dekrementiert (ernied-    */
/*                   rigt)                                               */
/*                                                                       */
/* ANMERKUNG: Dieses Bit hat nur bei Memory-To-Memory-bertragung Be-    */
/*            deutung.                                                   */

#define dma_CmdReg_SameAddrHold0   0x02
#define dma_CmdReg_ChangeAddrHold0 0x00

/* Bit 2: gesetzt  = Controller gesperrt    */
/*        gelscht = Controller freigegeben */

#define dma_CmdReg_DisableController 0x04
#define dma_CmdReg_EnableController  0x00

/* Bit 3: gesetzt  = Controller arbeitet im komprimierten Timing-Modus */
/*        gelscht = normales Timing                                   */

#define dma_CmdReg_CompressedTiming 0x08
#define dma_CmdReg_NormalTiming     0x00

/* Bit 4: gesetzt  = rotierende Prioritt                          */
/*        gelscht = normale Prioritt nach den Nummern der Kanle */

#define dma_CmdReg_RotatePriority 0x10
#define dma_CmdReg_NormalPriority 0x00

/* Bit 5: gesetzt  = Controller arbeitet im Extended Write Modus */
/*                   (erweitertes Schreiben)                     */
/*        gelscht = Late Write Modus                            */

#define dma_CmdReg_ExtendedWrite 0x20
#define dma_CmdReg_LateWrite     0x00

/* Bit 6: gesetzt  = DMA-Anforderung auf low-aktiv eingestellt  */
/*        gelscht = DMA-Anforderung auf high-aktiv eingestellt */
/*                   (DRQ sensing as high active)               */
/*                                                              */
/* ANMERKUNG: Dieses Bit hat nur Bedeutung, wenn der Controller */
/*            im normalen Timing-Modus arbeitet.                */

#define dma_CmdReg_DRQSensingLo 0x40
#define dma_CmdReg_DRQSensingHi 0x00

/* Bit 7: gesetzt  = DMA-Besttigung auf high-aktiv eingestellt */
/*                   (DACK sensing as high active)              */
/*        gelscht = DMA-Besttigung auf low-aktiv eingestellt  */
/*                                                              */
/* ANMERKUNG: Dieses Bit hat nur Bedeutung, wenn der Controller */
/*            im normalen Timing-Modus arbeitet.                */

#define dma_CmdReg_DACKSensingHi 0x80
#define dma_CmdReg_DACKSensingLo 0x00

/*-------------------------------------------------------------------------*/
/* Bitmasken zum Lesen des Statusregisters (nur Lesezugruff), das Auf-     */
/* schlu ber den aktuellen Zustand des DMA-Controllers gibt.             */
/*-------------------------------------------------------------------------*/

/* Bits 0-7 */

#define dma_StatReg_TC0          0x01                /* Terminal Count bei */
						     /* Kanal 0/4 erreicht */
#define dma_StatReg_TC1          0x02         /* TC bei Kanal 1/5 erreicht */
#define dma_StatReg_TC2          0x04         /* TC bei Kanal 2/6 erreicht */
#define dma_StatReg_TC3          0x08         /* TC bei Kanal 3/7 erreicht */
#define dma_StatReg_RequestPend0 0x10             /* Kanal 0/4 angefordert */
#define dma_StatReg_RequestPend1 0x20             /* Kanal 1/5 angefordert */
#define dma_StatReg_RequestPend2 0x40             /* Kanal 2/6 angefordert */
#define dma_StatReg_RequestPend3 0x80             /* Kanal 3/7 angefordert */

/*-------------------------------------------------------------------------*/
/* Bitmasken zum Setzen des Startregisters (auch Anforderungsregister ge-  */
/* nannt, nur Schreibzugriff), ber das dem DMA-Controller mitgeteilt      */
/* wird, da er mit der Arbeit beginnen soll.                              */
/*-------------------------------------------------------------------------*/

/* Bits 0-1 */

#define dma_ReqReg_Select0 0x00           /* DMA-Anforderung fr Kanal 0/4 */
#define dma_ReqReg_Select1 0x01           /* DMA-Anforderung fr Kanal 1/5 */
#define dma_ReqReg_Select2 0x02           /* DMA-Anforderung fr Kanal 2/6 */
#define dma_ReqReg_Select3 0x03           /* DMA-Anforderung fr Kanal 3/7 */

/* Bit 2: gesetzt  = Bit fr DMA-Anforderung setzen  */
/*        gelscht = Bit fr DMA-Anforderung lschen */

#define dma_ReqReg_SetRequestBit   0x04
#define dma_ReqReg_ClearRequestBit 0x00

/* Bits 3-7 haben keine Bedeutung. */

/*-------------------------------------------------------------------------*/
/* Bitmasken zum Setzen des Einzelmaskierungsregisters (sog. Single Mask   */
/* Register, nur Schreibzugriff). Das Maskierungsbit eines bestimmten Ka-  */
/* nals mu gelscht werden, damit die DMA-Anforderung fr diesen Kanal    */
/* erfolgen kann.                                                          */
/*-------------------------------------------------------------------------*/

/* Bits 0-1 */

#define dma_SingleMaskReg_Select0 0x00                /* Auswahl Kanal 0/4 */
#define dma_SingleMaskReg_Select1 0x01                /* Auswahl Kanal 1/5 */
#define dma_SingleMaskReg_Select2 0x02                /* Auswahl Kanal 2/6 */
#define dma_SingleMaskReg_Select3 0x03                /* Auswahl Kanal 3/7 */

/* Bit 2: gesetzt  = Maskierungsbit fr den gewhlten Kanal setzen */
/*        gelscht = Maskierungsbit lschen                        */

#define dma_SingleMaskReg_SetMaskBit   0x04
#define dma_SingleMaskReg_ClearMaskBit 0x00

/* Bits 3-7 haben keine Bedeutung. */

/*-------------------------------------------------------------------------*/
/* Bitmasken zum Setzen des Gesamtmaskierungsregisters (nur Schreibzu-     */
/* griff), ber das die Maskierungsbits fr jeden Kanal einzeln gesetzt    */
/* bzw. gelscht werden.                                                   */
/*-------------------------------------------------------------------------*/

/* Bits 0-3: jeweils gesetzt  = Maskierungsbit fr den entspr. Kanal */
/*                              setzen                               */
/*           jeweils gelscht = Maskierungsbit lschen               */

#define dma_MultiMaskReg_SetMaskBit0 0x01
#define dma_MultiMaskReg_SetMaskBit1 0x02
#define dma_MultiMaskReg_SetMaskBit2 0x04
#define dma_MultiMaskReg_SetMaskBit3 0x08

#define dma_MultiMaskReg_SetAll   0x0F     /* Setzen aller Maskierungsbits */
#define dma_MultiMaskReg_ClearAll 0x00    /* Lschen aller Maskierungsbits */

/* Bits 4-7 haben keine Bedeutung. */

/*-------------------------------------------------------------------------*/
/* Bitmasken zum Setzen des Modusregisters (nur Schreibzugriff), ber das  */
/* verschiedene Modi wie Schreiben oder Lesen der Daten gesetzt werden.    */
/*-------------------------------------------------------------------------*/

/* Bits 0-1 */

#define dma_ModeReg_Select0 0x00                      /* Auswahl Kanal 0/4 */
#define dma_ModeReg_Select1 0x01                      /* Auswahl Kanal 1/5 */
#define dma_ModeReg_Select2 0x02                      /* Auswahl Kanal 2/6 */
#define dma_ModeReg_Select3 0x03                      /* Auswahl Kanal 3/7 */

/* Bits 2-3 */

#define dma_ModeReg_Verify 0x00          /* berprfen (keine Operationen) */
#define dma_ModeReg_Write  0x04                               /* Schreiben */
#define dma_ModeReg_Read   0x08                                   /* Lesen */

/* Bit 4: gesetzt  = automatische Initialisierung einschalten */
/*        gelscht = automatische Initialisierung ausschalten */

#define dma_ModeReg_AutoInitOn  0x10
#define dma_ModeReg_AutoInitOff 0x00

/* Bit 5: gesetzt  = Speicheradresse inkrementieren (erhhen)     */
/*        gelscht = Speicheradresse dekrementieren (erniedrigen) */

#define dma_ModeReg_IncAddr 0x20
#define dma_ModeReg_DecAddr 0x00

/* Bits 6-7 */

#define dma_ModeReg_DemandMode  0x00                  /* Anforderungsmodus */
#define dma_ModeReg_SingleMode  0x40                        /* Einzelmodus */
				       /* (Datenbertragung Byte fr Byte) */
#define dma_ModeReg_BlockMode   0x80                         /* Blockmodus */
#define dma_ModeReg_CascadeMode 0xC0                 /* Kaskadierungsmodus */
				 /* (Der zweite DMA-Controller ist mit dem */
			     /* Kanal 0 des ersten Controllers verbunden.) */

/*-------------------------------------------------------------------------*/
/* Rechnertyp-Konstanten                                                   */
/*-------------------------------------------------------------------------*/

#define XT 0
#define AT 1

/*-------------------------------------------------------------------------*/
/* Typdefinitionen                                                         */
/*-------------------------------------------------------------------------*/

typedef unsigned char Byte;
typedef unsigned int  Word;
typedef long          LongInt;

/*-------------------------------------------------------------------------*/
/* Typschemas der im Modul DMA.C implementierten Funktionen                */
/*-------------------------------------------------------------------------*/

void CheckComputer(void);
void SetCommandReg(Byte, Byte);
Byte GetStatusReg(Byte);
void SetRequestReg(Byte, Byte);
void SetSingleMaskReg(Byte, Byte);
void SetMultiMaskReg(Byte, Byte);
void SetModeReg(Byte, Byte);
void StartDMA(Byte, Byte);
void SetMaskBit(Byte, Byte);
void ClearMaskBit(Byte, Byte);
void SetAllMaskBits(Byte);
void ClearAllMaskBits(Byte);
void SetDMAMode(Byte, Byte, Byte);
void MasterClear(Byte);
void ClearFlipFlop(Byte);
void SetAddrAndSideReg(Byte, Byte, void far *);
void SetBaseCountReg(Byte, Byte, Word);
Word GetCurrCountReg(Byte, Byte);
