
{...}

TYPE
  String60 = String[60];

{===========================================================================}
{ Prozedur CheckMIDI: Wertet das bergebene MIDI-Datum aus (Befehl und      }
{                     evtl. Nummer des MIDI-Kanals). Das Ergebnis der Aus-  }
{                     wertung wird in Form eines Strings zurckgeliefert.   }
{===========================================================================}
{ Eingabe: Value   = MIDI-Datum                                             }
{ Ausgabe: Command = Befehl                                                 }
{          Channel = Kanalnummer                                            }
{---------------------------------------------------------------------------}

PROCEDURE CheckMIDI(Value : Byte; VAR Command : String60;
  VAR Channel : Byte);

BEGIN
  Channel := (Value AND $0F)+1;          { MIDI-Kanalnummer (untere 4 Bits) }
  Value := Value AND $F0;                        { MIDI-Wert (obere 4 Bits) }
  IF (Value AND $80) = $00 THEN         { Handelt es sich um ein Datenbyte? }
    Command := 'Datenbyte'                                             { ja }
  ELSE                                               { nein, kein Datenbyte }
    CASE Value OF
      $80 : Command := 'Ausgabe einer Note';
      $90 : Command := 'Eingabe einer Note';
      $A0 : Command := 'Druckstrke einer Taste';
      $B0 : Command := 'Steuerbefehl';
      $C0 : Command := 'Programmwechsel';
      $D0 : Command := 'Druckstrke der Tastatur';
      $E0 : Command := 'Vernderung der Tonhhe';
      $F0 :
        BEGIN
          Command := 'System-Befehl: ';
          Dec(Channel);          { Kanalnummer dekrementieren (erniedrigen) }
          CASE Channel OF
            $00 : Command := Command+'System-Exclusive';
            $02 : Command := Command+'Songposition-Zeiger';
            $03 : Command := Command+'Anwhlen eines Songs';
            $06 : Command := Command+'Neustimmen eines Instrumentes';
            $07 : Command := Command+'End Of System-Exclusive';
            $08 : Command := Command+
                    'Einstellen der Frequenz (Timing Clock)';
            $0A : Command := Command+'Start';
            $0B : Command := Command+'Fortsetzung';
            $0C : Command := Command+'Stop';
            $0E : Command := Command+'Active Sensing';
            $0F : Command := Command+'Reset des Systems';
          ELSE
            Command := Command+'unbekannt';
          END;
        END;
    ELSE
      Command := 'Befehl unbekannt';
    END;
END;

{...}
