;****************************************************************************
;
;  File              : play8.asm
;  Date Created      : 6/89
;  Description       : Module to initializing the hardware timer on the PC
;                      for recording (non-DMA).
;
;  Last Modification : February 10, 1992
;
;  Additional Notes  :
;
;****************************************************************************
;            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved
;****************************************************************************

IFNDEF NO_DOS_SEG
  DOSSEG
ENDIF


      INCLUDE model.inc
      INCLUDE covox.inc
      INCLUDE recplay.inc


      EXTRN   RS_PlayingInBackground:WORD
      EXTRN   play_in_background:PROC
      EXTRN   stop_play_background:PROC

      EXTRN   playByteInit:PROC
      EXTRN   playByteUninit:PROC
      EXTRN   playByte:PROC
      EXTRN   _sr_stop_io:PROC

      EXTRN   _sr_header:BYTE

     .DATA

ssize_lsw    DW  0
ssize_msw    DW  0
stk_rate     DW  ?

      .CODE

      PUBLIC   play8

;*********************************************************************
;**
;**  play8:  Play an 8 bit PCM buffer.
;**
;**  Called by C as:
;**   play8(start, size, rate, port_out, treble);
;**  C declaration:
;**   int play8(void far *, long, int, unsigned int, int);
;**
;**  The returned int is either 0 for success or 1 for failure.  A failure
;**  results when one of the parameters are out of range or otherwise not
;**  suitable.  The parameters passed have the following ranges:
;**
;**   start:  Far pointer to where speech buffer is in memory.  The value
;**      must be on an even paragraph boundary.
;**   size:   A long value of the number of bytes in the file.  If the
;**      value is not divisible by 16, the remainder will be ignored.
;**      The value must be larger then 16 or an error will result.
;**   rate:   If 0, then the header is checked, if it is not zero, then
;**      it is used for playback rate.  If it's also zero, then the
;**      default (132) is used.  If greater then 229 play8 aborts.
;**      Otherwise the value is used as is.
;**   port_out: The port where sound is to come out.  If the number is 0-3
;**      then the Voice Master II ports 22f, 24f, 28f, or 2cf are used
;**      respectively.  If 4, 5 or 6 then LPT1, 2 or 3 (Speech Thing)
;**      are used.  Otherwise the value is considered to be the actual
;**      port address.
;**   treble:   A flag to indicate that differentiation is to be used on
;**      output.  0 = No, any other number means yes.
;***************************************************************************

play8      PROC \
      USES SI DI ES DS, \
      stk_start:FAR PTR BYTE, \
      stk_size:DWORD, \
      rate_in:BYTE, \
      stk_port_out:WORD, \
      stk_treble:WORD

      mov   ax, @data
      mov   ds, ax

      xor   ah, ah
      mov   al, rate_in
      mov   stk_rate, ax

      setup_play 08h                   ; macro to setup all play pointers and rate

      cmp   stk_port_out, 8            ; Test if internal speaker
      jne   SHORT normal_playback

      ;
      ; Select oversample value by the known playback rate
      ;
      cmp   stk_rate, 0
      jne   SHORT @F
      mov   ax, 2                      ; if rate unkown set oversample to standard of 2
      jmp   SHORT push_over_sample
@@:
      cmp   stk_rate, 18
      ja    SHORT @F
      mov   ax, 4                      ; for rates in range 1-17 (4680- 4993Hz)
      jmp   SHORT push_over_sample     ; use oversample rate 4
@@:
      cmp   stk_rate, 124
      ja    SHORT @F
      mov   ax, 3                      ; for rates in range 18-123 (5014- 8972Hz)
      jmp   SHORT push_over_sample     ; use oversample rate 3
@@:
      cmp   stk_rate, 196
      ja    SHORT @F
      mov   ax, 2                      ; for rates in range 124-196 (9040- 19887Hz)
      jmp   SHORT push_over_sample     ; use oversample rate 2
@@:
      mov   ax, 1                      ; for rate 197 (20224Hz) uses oversampleing of 1

push_over_sample:
      ;
      ; Setup stack frame to call play in background
      ;
      push   ax
      xor    ax, ax                    ; set system clock to max
      push   ax
      mov    ax, stk_rate
      push   ax
      mov    ax, 8                     ; set out_port to internal speaker
      push   ax

      push   WORD PTR stk_size+2       ; load DWORD size
      push   WORD PTR stk_size
      push   WORD PTR stk_start+2      ; load far pointer to buffer
      push   WORD PTR stk_start
      call   play_in_background
      add    sp, 16                    ; clear calling stack
      or     ax, ax
      je     SHORT wait_loop           ; skip return of error code
      jmp    ret_error_no_uninit

wait_loop:
      call   _sr_stop_io
      jnz    SHORT key_stop
      cmp    RS_PlayingInBackground, 0
      jne    SHORT wait_loop           ; loop until done playing

done_internal:
      xor    ax, ax
      jmp    play_ret
key_stop:
      call   stop_play_background      ; stop the playback
      xor    ax, ax
      jmp    play_ret

normal_playback:
      c_call playByteInit, <stk_port_out,stk_rate,0,stk_treble>
      or     ax, ax                    ; see if port present
      jnz    SHORT play_loop           ; jump if a non-zero port

      mov    ax, _ERROR_PORT_INIT_FAILED
      jmp    play_ret                  ; return an error if no port

play_loop:
      sub    ssize_lsw, 1              ; subtract number of bytes needed from length,
      jnc    SHORT @F              
      sub    ssize_msw, 1
      jnc    SHORT @F

j_done:
      jmp    SHORT done                ; if under flow then done

@@:
      key_pressed dx                   ; test for key press, using dx for temp storage

      jnz    SHORT j_done
      mov    al, es:[di]               ; read in byte from buffer
      add    di, 1                     ; adjust place in buffer
      cmp    di, 08000h
      jb     SHORT @F
      add    di, 08000h
      mov    si, es
      add    si, 0800h
      mov    es, si
@@:
      c_call playByte, <ax>
      jmp    play_loop                 ; loop for next byte

ret_error_no_uninit:
      jmp    SHORT play_ret
done:
      c_call playByteUninit            ; uninit the hardware
      mov    ax, _ERROR_NONE

play_ret:
      ret

play8      ENDP

      END

