/****************************************************************************

  File                  : fminit.c	
  Date                  : 3-18-91	
  Description           : Initialization function for YM3812 libraries
				

  Progammer(s)          : Don Fowler, Lance Williams	
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

/****************************************************************************

	Function	 : BYTE fmInit( _FM_INIT_DATA *fmInitData )

	Parameters: FM_INIT_DATA
					a. Port

	Actions	 :	 1.) Check for legal parameters( Port values )
					 2.) Store the port in a global variable.
					 3.) Set the wave select on bit
					 		exp: This is done so that the user can select the wave 
								  type to use with the instrument. If the bit is not
								  set the default wave type is sine wave.
					 4.) Set the mode to melodic.
					 5.) Set the global parameters( AM Depth, FM Depth )( not done yet )
					 6.) Set the _fm_Initialized flag.
					 		exp: To allow other functions to verify that the system
								  has been initialized.	

*****************************************************************************/

WORD fmInit(  _FM_INIT_DATA *fmInitData  )
{
	// Check to see if the port value is one of the legal port values
	if( ( fmInitData -> port != _FM_PORT_A ) && ( fmInitData -> port != _FM_PORT_B ) )
		return( _ERROR_INVALID_PORT );
		
	// Store the port address
	_fmGlobalParameters.port = fmInitData -> port;
	_fmPort = fmInitData -> port;

	// Set the wave select bit
	fmSetRegister( _TEST, _WAVE_SELECT_ON );

	// Clear the percussion register values
	_fmPercussionRegister = _FALSE;

	// Set the system initialized flag
	_fmGlobalParameters.systemInitialized = _TRUE;

	// Set the mode to melodic
	fmSetMode( _MELODIC );

	return( _ERROR_NONE );
}

