//*****************************************************************************
//  File              : CVXUTIL.H
//  Date              : January 10, 1992
//  Description       : Covox utilities support header file.
//
//  Last update       : March 11, 1992
//  Additional Notes  :
//*****************************************************************************
//             Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          
//*****************************************************************************

#ifndef  _CVXUTIL_DEFINED
#define  _CVXUTIL_DEFINED

#include "cvxdefs.h"

//*****************************************************************************
//   If compiled with Borland C, the header file CVXBRLND.H will be 
//   automatically included.
//*****************************************************************************
#if defined(__TURBOC__)
#include "cvxbrlnd.h"
#endif

//*****************************************************************************
// Constants for cvxFileOpen and cvxFileCreate.
//*****************************************************************************
#define _OPEN_R_ONLY    0x80
#define _OPEN_W_ONLY    0x84
#define _OPEN_RW        0x82
#define _CREATE_R_ONLY  0x0001
#define _CREATE_NORMAL  0x0000


//*****************************************************************************
// Covox utilities header information
//*****************************************************************************
#undef  _ERROR_NONE
#define _ERROR_NONE  0

//*****************************************************************************
// Error codes for Covox utilities
//*****************************************************************************
// NOTE : Starting offset for all Covox utilities errors is 9000.
enum
{
   _ERROR_NOT_ENOUGH_MEMORY = 9000,    
   _ERROR_MEMORY_ALLOC,             // Error during memory allocation.
   _ERROR_MEMORY_DEALLOC,           // Error during memory deallocation.
   _ERROR_INVALID_HANDLE,           // File not open.
   _ERROR_FILE_WRITE_FAILED,        // Unknown file write failure.
   _ERROR_FILE_READ_FAILED,         // Unknown file read failure.
   _ERROR_FILE_NOT_FOUND,           // Non-existant file given in cvxFileOpen.
   _ERROR_PATH_NOT_FOUND,           // Invalid path given.
   _ERROR_TOO_MANY_FILES_OPEN,      // No more handles available in system.
   _ERROR_ACCESS_DENIED,            // File could not be accessed.
   _ERROR_INVALID_ACCESS,           // Invalid mode during open/create.
   _ERROR_DISK_FULL,                // Destination file or disk full.
   _ERROR_FILE_CREATE,              // Unknown file creation error.
   _ERROR_FILE_OPEN                 // Unknown file open error.
};

//*****************************************************************************
//  Prototypes for all Covox utility functions.
//*****************************************************************************
#ifdef __cplusplus
extern "C" {
#endif

LPSTR cvxBufferAlloc  ( LONG, LONG * );
WORD  cvxBufferFree   ( LPSTR );
WORD  cvxFileRead     ( HANDLE, LPSTR, LONG, LONG * );
WORD  cvxFileWrite    ( HANDLE, LPSTR, LONG, LONG * );
WORD  cvxFileClose    ( HANDLE );
WORD  cvxFileOpen     ( LPSTR, BYTE, HANDLE * );
WORD  cvxFileCreate   ( LPSTR, WORD, HANDLE * );
WORD  cvxRateToHz     ( BYTE );
BYTE  cvxHzToRate     ( WORD );

VOID  cvxHeaderParse    ( LPSTR buffer, BYTE * bufferFormat, BYTE * playbackRate );
PSTR  cvxGetErrorString ( WORD errorValue ); 


#ifdef __cplusplus
}
#endif

#endif
//*****************************************************************************
// end         CVXUTIL.H
//*****************************************************************************
