// MIDIPLAY.C
// This program initializes the Covox MIDI system using the 
// midiInit function, plays a middle C using the midiOutByte 
// function, then calls the midiUninit function when finished.

#include "cvxmidi.h" 

VOID main( VOID )
{
   // Set up the MIDI system with the default port and IRQ values.
   midiInit( _MIDI_PORT_A, _IRQ_2 );

   // Turn on a middle C note.
   midiOutByte( 0x90 );
   midiOutByte(   60 );
   midiOutByte(   64 );

   // Turn the note off.
   midiOutByte(   60 );
   midiOutByte(    0 );

   // Uninitialize the MIDI system.
   midiUninit();
}



