/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2007   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: +ѯ */
/* MCS-51ƬCʾ, V3.0Aϰ汾ģ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */

#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			32		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧64,Сֵ13 */
#include "..\CH375HM.H"

/* ·ӷʽ
   Ƭ    ģ
    P0    =  D0-D7
    RD    =  RD#
    WR    =  WR#
    ?     =  CS#   ûⲿRAM,ôCS#=P26,г16KBⲿRAM,ôCS#=P27 & ! P26 & ...,CS#ƬѡַΪBXXXH
    P20   =  A0
    INT0  =  INT#  ȻӵINT0,ǱֻǲѯģINT#״̬,ԿP1ڵͨI/OŴINT0
*/
#define CH375HM_INDEX	XBYTE[0xBCF0]	/* CH375ģ˿ڵI/Oַ */
#define CH375HM_DATA	XBYTE[0xBDF1]	/* CH375ģݶ˿ڵI/Oַ */
#define CH375HM_INT_WIRE		INT0	/* ٶCH375ģINT#ӵƬINT0 */

/* ٶļݻ: ExtRAM: 0000H-7FFFH */
unsigned char xdata DATA_BUF[ 512 * 64 ] _at_ 0x0000;	/* ⲿRAMļݻ,ӸõԪʼĻȲСһζдݳ,Ϊ512ֽ */

CMD_PARAM		mCmdParam;				/* Ĭ¸ýṹռ64ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */
unsigned char	mIntStatus;				/* CH375ģж״̬߲״̬ */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ģĲڶдʱڶдʽ,޸3ӳ */
#define CH375HM_INDEX_WR( Index )	{ CH375HM_INDEX = (Index); }	/* дַ */
#define CH375HM_DATA_WR( Data )		{ CH375HM_DATA = (Data); }		/* д */
#define CH375HM_DATA_RD( )			( CH375HM_DATA )				/*  */


/* ԺΪλʱ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* ִ */
unsigned char	ExecCommandBuf( unsigned char cmd, unsigned char len, unsigned char xdata *bufstart )
/* ,ز״̬,ͷزCMD_PARAMṹ */
/* bufstartCMD_FileReadCMD_FileWrite,ָⲿRAMʼַ,ԲοжϷʽCȫֱbufferķʽ */
{
	unsigned char		i, status;
	unsigned char data	*buf;
	unsigned char xdata	*CurrentBuf;
	CH375HM_INDEX_WR( PARA_COMMAND_ADDR );
	CH375HM_DATA_WR( cmd );  /* ַPARA_COMMAND_ADDRд */
	if ( len ) {  /* в */
		i = len;
		CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
		buf = (unsigned char *)&mCmdParam;  /* ָʼַ */
		do {
			CH375HM_DATA_WR( *buf );  /* ַPARA_BUFFER_ADDRʼ,д */
			buf ++;
		} while ( -- i );
	}
	CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
	CH375HM_DATA_WR( len | PARA_CMD_BIT_ACT );  /* ַPARA_CMD_LEN_ADDRдĳ,λ֪ͨģ,˵Ѿд,ʼִ */
	CurrentBuf = bufstart;  /* ⲿRAMʼַ,FileReadFileWrite */
	while ( 1 ) {  /* ݴ,ֱɲ˳ */

#if 1
		while ( CH375HM_INT_WIRE );  /* ȴģɲ͵ƽж,ѼⷽʽǶģINT#źŽ½رؼ */
#else
		do {  /* Ҫʽд,ôԲѯģ뵥ԪѯģINT# */
			CH375HM_INDEX_WR( PARA_COMMAND_ADDR );
		} while ( CH375HM_DATA_RD( ) );  /* ģʱֵ0,ڷʽд */
#endif

		CH375HM_INDEX_WR( PARA_STATUS_ADDR );  /* дַ */
		status = CH375HM_DATA_RD( );  /* ַPARA_STATUS_ADDRȡж״̬ */
		CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
		CH375HM_DATA_WR( PARA_CMD_BIT_INACT );  /* жӦ,ȡģж */
/* ΪģյжӦ3uS֮ڲųж,,ǲѯINT#źŵĵ͵ƽ,ôڷжӦ3uS֮ڲӦٲѯINT#źŵ״̬
   51Ƭ,ĴʱѾ3uS,Բʱȴģ鳷ж */
		if ( status == ERR_SUCCESS ) {  /* ɹ */
			CH375HM_INDEX_WR( PARA_STS_LEN_ADDR );
			i = CH375HM_DATA_RD( );  /* ַPARA_STS_LEN_ADDRȡؽݵĳ, */
			if ( i ) {  /* н */
				CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
				buf = (unsigned char *)&mCmdParam;  /* ָʼַ */
				do {
					*buf = CH375HM_DATA_RD( );  /* ַPARA_BUFFER_ADDRʼ,ȡ */
					buf ++;
				} while ( -- i );
			}
//			status = ERR_SUCCESS;
			break;  /* ɹ */
		}
		else if ( status == USB_INT_DISK_READ ) {  /* ڴU̶ݿ,ݶ */
			CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
			i = 64;  /*  */
			do {  /* Ҫļݶдٶ,γûЧʸ,C51,do+whileforwhileṹЧʸ */
				*CurrentBuf = CH375HM_DATA_RD( );  /* ַ063ζ64ֽڵ */
				CurrentBuf ++;  /* ȡݱ浽ⲿ */
			} while ( -- i );  /* һСCûЧҪ߽һ */
			CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
			CH375HM_DATA_WR( PARA_CMD_BIT_ACT );  /* ֪ͨģ,˵64ֽѾȡ */
		}
		else if ( status == USB_INT_DISK_WRITE ) {  /* Uдݿ,д */
			CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
			i = 64;  /*  */
			do {
				CH375HM_DATA_WR( *CurrentBuf );  /* ַ063д64ֽڵ */
				CurrentBuf ++;  /* дⲿ */
			} while ( -- i );
			CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
			CH375HM_DATA_WR( PARA_CMD_BIT_ACT );  /* ֪ͨģ,˵64ֽѾд */
		}
		else if ( status == USB_INT_DISK_RETRY ) {  /* дݿʧ,Ӧ޸Ļָ */
			CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
			i = CH375HM_DATA_RD( );  /* ģʽΪظָֽĸ8λ,Сģʽôյǻظָֽĵ8λ */
			status = CH375HM_DATA_RD( );  /* ģʽΪظָֽĵ8λ,Сģʽôյǻظָֽĸ8λ */
			CurrentBuf -= ( (unsigned short)i << 8 ) + status;  /* ǴģʽµĻظָ,Сģʽ,Ӧ( (unsigned short)status << 8 ) + i */
			CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
			CH375HM_DATA_WR( PARA_CMD_BIT_ACT );  /* ֪ͨģ,˵״̬Ѿ */
		}
		else {  /* ʧ */
			if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) {  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
				mDelaymS( 100 );
				if ( CH375HM_INT_WIRE ) break;  /* ûж򷵻,Ȼж˵֮ǰжU̲֪ͨж,ٴж϶ݲ */
			}
			else break;  /* ʧܷ */
		}
	}
/*	while( CH375HM_INT_WIRE == 0 );  ƬٶȺܿ,пܸó򷵻ǰģδж,ôӦõȴжЧ */
	return( status );
}

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	return( ExecCommandBuf( cmd, len, 0 ) );  /* ֻCMD_FileReadCMD_FileWriteõbufstart,ûõ */
}

/* ״̬,ʾ벢ͣ,Ӧ滻ΪʵʵĴʩ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (unsigned short)iError );  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelaymS( 100 );
		led^=1;
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	i, c, SecCount;
	unsigned long	OldSize;
	unsigned short	NewSize, count;
	LED_OUT = 0;  /* LEDһʾ */
	mDelaymS( 200 );  /* ʱ100,CH375ģϵҪ100ҵĸλʱ */
	mDelaymS( 250 );
	LED_OUT = 1;
	mInitSTDIO( );
	printf( "Start\n" );
/* ·ʼ */
	while ( 1 ) {  /* ѭ */
		printf( "Wait Udisk\n" );
		while ( 1 ) {  /* ʹòѯʽUǷ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus >= DISK_CONNECT ) break;  /* UѾ */
			mDelaymS( 200 );  /* ڴдUʱٲѯ,ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( ExecCommand( CMD_DiskReady, 0 ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
/* ȡԭļ */
		printf( "Open\n" );
		memcpy( mCmdParam.Open.mPathName, "\\C51\\CH375HFT.C", MAX_PATH_LEN );  /* ļ,ļC51Ŀ¼ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* ERR_MISS_DIR˵ûҵC51Ŀ¼,ERR_MISS_FILE˵ûҵļ */
/* гĿ¼µļ */
			printf( "List file \\*\n" );
			for ( c = 0; c < 255; c ++ ) {  /* ǰ255ļ */
/*				memcpy( mCmdParam.Enumer.mPathName, "\\C51\\CH375*", MAX_PATH_LEN );*/  /* C51Ŀ¼CH375ͷļ,*Ϊͨ */
				memcpy( mCmdParam.Enumer.mPathName, "\\*", MAX_PATH_LEN );  /* ļ,*Ϊͨ,ļĿ¼ */
/*				i = strlen( mCmdParam.Enumer.mPathName );*/  /* ļĳ */
				for ( i = 0; i < MAX_PATH_LEN - 1; i ++ ) if ( mCmdParam.Enumer.mPathName[ i ] == 0 ) break;  /* ָļĽ */
				mCmdParam.Enumer.mPathName[ i ] = c;  /* 滻Ϊ,0255 */
				i = ExecCommand( CMD_FileEnumer, i+1 );  /* öļ,ļкͨ*,Ϊļ,ĳȺܺü */
				if ( i == ERR_MISS_FILE ) break;  /* Ҳƥļ,Ѿûƥļ */
				if ( i == ERR_SUCCESS ) {  /* ͨƥļ,ļ· */
					printf( "  match file %03d#: %s\n", (unsigned int)c, mCmdParam.Enumer.mPathName );  /* ʾźƥļĿ¼ */
					continue;  /* һƥļ,´ʱŻ1 */
				}
				else {  /*  */
					mStopIfError( i );
					break;
				}
			}
			strcpy( DATA_BUF, "Note: \xd\nԭǴ㽫/C51/CH375HFT.CļеСдĸתɴддµļ,Ҳļ\xd\n" );
			OldSize = 0;
			NewSize = strlen( DATA_BUF );  /* ļĳ */
			SecCount = ( NewSize + 511 ) >> 9;  /* (NewSize+511)/512, ļ,ΪдΪλ */
		}
		else {  /* ҵļ\C51\CH375HFT.C߳ */
			mStopIfError( i );
			printf( "Query\n" );
			i = ExecCommand( CMD_FileQuery, 0 );  /* ѯǰļϢ,û */
			mStopIfError( i );
			printf( "Read\n" );
			OldSize = mCmdParam.Modify.mFileSize;  /* ԭļĳ */
			if ( OldSize > (unsigned long)(64*512) ) {  /* ʾõ62256ֻ32Kֽ */
				SecCount = 64;  /* ʾõ62256ֻ32Kֽ,ֻȡ64,Ҳǲ32768ֽ */
				NewSize = 64*512;  /* RAMƳ */
			}
			else {  /* ԭļС,ôʹԭ */
				SecCount = ( OldSize + 511 ) >> 9;  /* (OldSize+511)/512, ļ,ΪдΪλ */
				NewSize = (unsigned short)OldSize;  /* ԭ */
			}
			printf( "Size=%ld, Len=%d, Sec=%d\n", OldSize, NewSize, (unsigned short)SecCount );
			mCmdParam.Read.mSectorCount = SecCount;  /* ȡȫ,60ֻȡ60 */
			i = ExecCommandBuf( CMD_FileRead, 1, &DATA_BUF );  /* ļȡ */
			mStopIfError( i );
/*
			ļȽϴ,һζ,CMD_FileReadȡ,ļָԶƶ
			while ( ʣδ ) {
				mCmdParam.Read.mSectorCount = 32;
				ExecCommandBuf( CMD_FileRead, 1, &DATA_BUF + Ѿȡĳ );   ļָԶ
				TotalLength += 32*512;  ۼļܳ
			}

		    ϣָλÿʼд,ƶļָ
			mCmdParam.Locate.mSectorOffset = 3;  ļǰ3ʼд
			i = ExecCommand( CMD_FileLocate, 4 );  ĳ4sizeof( mCmdParam.Locate.mSectorOffset )
			mCmdParam.Read.mSectorCount = 10;
			ExecCommandBuf( CMD_FileRead, 1, &DATA_BUF );   ֱӶȡļĵ(512*3)ֽڿʼ,ǰ3

			ϣӵԭļβ,ƶļָ
			i = ExecCommand( CMD_FileOpen, (unsigned char)( strlen( mCmdParam.Open.mPathName ) + 1 ) );
			mCmdParam.Locate.mSectorOffset = 0xffffffff;  Ƶļβ,Ϊλ,ԭļ3ֽ,512ֽڿʼ
			i = ExecCommand( CMD_FileLocate, sizeof( mCmdParam.Locate.mSectorOffset ) );
			mCmdParam.Write.mSectorCount = 10;
			ExecCommandBuf( CMD_FileWrite, 1, &DATA_BUF );   ԭļĺ
*/
			printf( "Close\n" );
			mCmdParam.Close.mUpdateLen = 0;
			i = ExecCommand( CMD_FileClose, 1 );  /* رļ */
			mStopIfError( i );

			i = DATA_BUF[200];
			DATA_BUF[200] = 0;  /* ַ־,ʾ200ַ */
			printf( "Line 1: %s\n", DATA_BUF );
			DATA_BUF[200] = i;  /* ָԭַ */
			for ( count=0; count < NewSize; count ++ ) {  /* ļеСдַתΪд */
				c = DATA_BUF[ count ];
				if ( c >= 'a' && c <= 'z' ) DATA_BUF[ count ] = c - ( 'a' - 'A' );
			}
		}
/* ļ */
		printf( "Create\n" );
/*		memcpy( mCmdParam.Create.mPathName, "\\NEWFILE.TXT", MAX_PATH_LEN );*/
		memcpy( mCmdParam.Create.mPathName, "\\˫Ұ.TXT", MAX_PATH_LEN );  /* ļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileCreate, MAX_PATH_LEN );  /* ½ļ,ļѾɾ½ */
		mStopIfError( i );
		printf( "Write\n" );
		mCmdParam.Write.mSectorCount = 0x1;  /* дһ512ֽ */
		i = ExecCommandBuf( CMD_FileWrite, 1, &DATA_BUF );  /* ļд */
		mStopIfError( i );
		if ( SecCount > 1 ) {  /* Ϊݲ255,ܹһд,Ϊʾ,д */
			mCmdParam.Write.mSectorCount = SecCount - 1;
/*	buffer = & DATA_BUF + 512;  Ÿղŵд,ûʼַ */
			i = ExecCommandBuf( CMD_FileWrite, 1, &DATA_BUF + 512 );  /* ļд,ǰд512ֽ֮ */
			mStopIfError( i );
		}
		printf( "Modify\n" );
		mCmdParam.Modify.mFileAttr = 0xff;  /* : µļ,Ϊ0FFH޸ */
		mCmdParam.Modify.mFileTime = 0xffff;  /* : µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ */
		mCmdParam.Modify.mFileDate = ( (2004-1980)<<9 ) + ( 5<<5 ) + 18;  /* : µļ: 2004.05.18 */
		mCmdParam.Modify.mFileSize = NewSize;  /* : ԭļС,ôµļԭļһ,RAM */
		i = ExecCommand( CMD_FileModify, 4+2+2+1 );  /* ޸ĵǰļϢ,޸ںͳ,Ϊsizeof(mCmdParam.Modify.mFileSize)+... */
		mStopIfError( i );
		printf( "Close\n" );
		mCmdParam.Close.mUpdateLen = 0;  /* ҪԶļ,Զ,ôó512ı */
		i = ExecCommand( CMD_FileClose, 1 );
		mStopIfError( i );

/* ɾĳļ */
		printf( "Erase\n" );
		memcpy( mCmdParam.Create.mPathName, "\\OLD", MAX_PATH_LEN );  /* ɾļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileErase, MAX_PATH_LEN );  /* ɾļر */
/*		mStopIfError( i );*/

/* ѯϢ */
		printf( "Disk\n" );
		i = ExecCommand( CMD_DiskQuery, 0 );
		mStopIfError( i );
		i = mCmdParam.Query.mDiskFat;
		if ( i == 1 ) i = 12;
		else if ( i == 2 ) i = 16;
		else if ( i == 3 ) i = 32;
		printf( "FatCode=FAT%d, TotalSector=%ld, FreeSector=%ld\n", (unsigned short)i, mCmdParam.Query.mTotalSector, mCmdParam.Query.mFreeSector );
/* ȴU̶Ͽ */
		printf( "Take_out\n" );
		while ( 1 ) {  /* ʹòѯʽUǷϿ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus <= DISK_DISCONNECT ) break;  /* UѾϿ */
			mDelaymS( 200 );  /* ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		LED_OUT = 1;  /* LED */
	}
}
