;CH372/CH375 USB device mode & external firmware
;by wch       2004.10,  2005.03
;$INCLUDE                 	 (reg52.h)
$INCLUDE                 	 (CH375INC.ASM)

STACK           EQU    50H             ;ջջ()
;
; ҪĲ
CH375_CMD_PORT		EQU    0BDF1H         ;CH375ڵĵַ,ַԶƬѡ
CH375_DAT_PORT		EQU    0BCF0H         ;CH375ڵĵַ,ַԶƬѡ
;

CH375_CON_ACT		BIT    P1.4

CMD_BUFFER			DATA  38H				;,ԼΪCONST_CMD_LEN

VAR_SETUP_REQUEST	EQU   72H							;USB
VAR_SETUP_LENGTH	EQU   73H							;ݳ
VAR_SETUP_DESCR		EQU   74H							;ƫƵַ
VAR_SN_STRING		EQU   75H							;Ʒкַ,ANSIַ
VAR_USB_ADDRESS		EQU   76H
	
; λ־
CH375_CON_FLAG  BIT    2FH.0	      ;375оƬɱ־
;
;****************************************************************************
;
				ORG   0000H            ;λƬ
				LJMP  START
				ORG   0003H            ;CH375ж
				LJMP  CH375_INTER

START:
; ³ʼָǱҪ,ƬָΪĬ״̬
				CLR   EA               ;ж
				MOV   SP,#STACK        ;öջֵ
				MOV   A,#0FFH
				MOV   P0,A
				MOV   P1,A             ;˿״̬
				MOV   P2,A
				MOV   P3,A
				CLR   A
				MOV   IE,A             ;жƼĴ
				MOV   IP,A             ;жȼƼĴ
				MOV   PSW,A            ;״̬
				MOV   TCON,A           ;嶨ʱ/ƼĴ
				MOV   TMOD,A           ;嶨ʱ/ʽĴ
				MOV   PCON,A           ;ԴƼĴ
				MOV   R7,#0FFH
				CALL  DELAY_MS			;ʱȴCH375ʼ
; ʼ
				CALL  CH375_INIT       ;ʼ
				setb  EA
				ljmp  $	;
;
; CH375
; : ACC Ϊ
; : DPTR Ϊݿ
; USE: ACC, DPTR
WR_CMD_TO_375:	MOV   DPTR,#CH375_CMD_PORT	;ڵַ
				MOVX  @DPTR,A				;USBģʽ
				NOP							;ʱƵʵ20MHzָʱ,30MHzҪ2ָ
				MOV   DPTR,#CH375_DAT_PORT	;ݿڵַ
				RET
;
; ʼӳ
; USE:   ACC, R7, DPTR
CH375_INIT:		MOV   A,#CMD_SET_USB_MODE	;USBģʽ
				CALL  WR_CMD_TO_375			;
;				MOV   A,#02H				;Ϊù̼ģʽ
				MOV   A,#01H				;Ϊù̼ģʽ
				MOVX  @DPTR,A				;Ϊʹù̼USB豸ʽ
				NOP							;ʱƵʵ16MHzָʱ
				NOP
CH375_INIT_WT:	MOVX  A,@DPTR				;ز״̬,ҲԵȴ20uS
				XRL   A,#CMD_RET_SUCCESS
				JNZ   CH375_INIT_WT			;ȴɹ,ͨҪȴ10uS-20uS
; ָж
				CLR   IT0					;ⲿźΪ͵ƽ
				SETB  PX0					;øȼ
				CLR   IE0					;жϱ־
				SETB  EX0					;CH375ж
				RET
;**************************************************************************************
CH375_EP2_DOWN:	MOV A,#CMD_RD_USB_DATA		;´ݶͷŶ˵
				CALL  WR_CMD_TO_375			;CH375
				MOVX A,@DPTR				;ȡݳ
				MOV R4,A				;泤
				JZ   CH375_EP2_UP			;Ϊ0
				MOV R5,A
				MOV  R0,#CMD_BUFFER			;׵ַR0
CH375_EP2_LOOP:			MOVX A,@DPTR
				MOV @R0,A
				INC R0	
				DJNZ R5,CH375_EP2_LOOP
; ʾش
CH375_EP2_UP:	MOV  A,#CMD_WR_USB_DATA7	;ʾش
				CALL  WR_CMD_TO_375
				MOV  A,R4
				MOVX @DPTR,A
				JZ   CH375_EP2_UP_RET		;Ϊ0
				MOV  R0,#CMD_BUFFER			;׵ַR0
CH375_EP2_UP_LOOP:	MOV  A,@R0
				MOVX @DPTR,A
				INC  R0
				DJNZ  R4,CH375_EP2_UP_LOOP
CH375_EP2_UP_RET:	RET
;***************************************************************************************							
				
; жϷӳ
; USE:   ջ6ֽ, Ĵ1R0,R5,R6,R7
CH375_INTER:	PUSH  PSW					;ֳ
				PUSH  ACC
				PUSH  DPL
				PUSH  	DPH
				SETB  	RS0                   		;PSW.3,лĴ1
				MOV   A,#CMD_GET_STATUS
				CALL  WR_CMD_TO_375			;ȡж״̬ȡж
				MOVX 	 A,@DPTR				;ز״̬
				ANL 	 A,#0FH				;θ4λ
				CLR   	IE0					;жϱ־,ӦINT0ж
;ж״̬з
				CJNE  A,#USB_INT_EP2_OUT,CH375_INT_06	;˵´ɹ
				LCALL CH375_EP2_DOWN		;´
				LJMP  CH375_INT_RET			; USBݽճɹ
CH375_INT_06:	CJNE  A,#USB_INT_EP2_IN,CH375_INT_07	;˵ϴɹ
				;USBݷͳɹ
				LJMP CH375_INT_ULOCK			;жϷ
CH375_INT_07:
				CJNE  	A,#USB_INT_EP0_SETUP,CH375_INT_01
				LJMP  	CH375_SETUP_OK			;USBƴ佨
CH375_INT_01:	CJNE  	A,#USB_INT_EP0_OUT,CH375_INT_02
				LJMP 	CH375_INT_ULOCK		;˵0´,жϷ
CH375_INT_02:	CJNE  	A,#USB_INT_EP0_IN,CH375_INT_03
									;˵0ϴ
				MOV 	A,VAR_SETUP_REQUEST
				CJNE 	A,#DEF_USB_GET_DESCR,CH375_EP0_IN_01
									;ϴ
				LCALL 	 CH375_DES_UPLOAD		;ϴ
				LJMP     CH375_INT_ULOCK	;жϷ

CH375_EP0_IN_01:	CJNE 	A,#DEF_USB_SET_ADDRESS,CH375_EP0_IN_02
				MOV	    A,#CMD_SET_USB_ADDR		;õַ,Աһµĵַ
				CALL  WR_CMD_TO_375
				MOV    A,VAR_USB_ADDRESS		;ȡַ
				MOVX	@DPTR,A
				LJMP    CH375_INT_ULOCK
CH375_EP0_IN_02:	LJMP    CH375_INT_ULOCK	;жϷ
CH375_INT_03:	CJNE 	 A,#USB_INT_EP1_IN,CH375_INT_04
									;˵1ϴ,ڴ˼ϴ
				LJMP 	CH375_INT_ULOCK		;жϷ

CH375_INT_04:	CJNE  A,#USB_INT_EP1_OUT,CH375_INT_05
				 					;˵1´
				MOV A,#CMD_RD_USB_DATA		;´ݶͷŶ˵
				CALL  WR_CMD_TO_375			;CH375
				MOVX A,@DPTR				;
				JZ   CH375_INT_RET			;Ϊ0
				MOV  R5,A
CH375_USB_OUT1_LOOP:		MOVX A,@DPTR				;ͷŻ
				NOP							;浽
				DJNZ  R5,CH375_USB_OUT1_LOOP		;δ
				LJMP 	CH375_INT_RET		;жϷ
CH375_INT_05:	ANL  A,#03H
				CJNE A,#03H,CH375_INT_09
				LJMP  CH375_USB_REST			;תUSBλ
CH375_INT_09:	SJMP  CH375_INT_ULOCK		;ִ֧󷵻

CH375_INT_ULOCK:	;жϷ
				MOV 	A,#CMD_UNLOCK_USB			;˵
				CALL  WR_CMD_TO_375
CH375_INT_RET:	POP   DPH
				POP   DPL
				POP   ACC
				POP   PSW					;ָĴ
				RETI

CH375_USB_REST:	;USB߸λ
				SETB CH375_CON_ACT				;ֵȣCH372 ԶUSB ַͬ־
				CLR CH375_CON_FLAG				;嵥Ƭиֱ־	
				MOV VAR_SETUP_REQUEST,#0FFH
				LJMP CH375_INT_ULOCK
;*****************************************************************************************
;***********************************USB SETUP***********************************************
CH375_SETUP_RET_ERR:
				MOV A,#CMD_SET_ENDP3			;ö˵1
				CALL  WR_CMD_TO_375
				MOV A,#0FH			;״̬ΪSTALL
				MOVX @DPTR,A
				LJMP CH375_INT_RET			;Ŀƴ

CH375_SETUP_RET:
				LJMP CH375_INT_RET			;תжϷ
CH375_SETUP_OK:	MOV  A,#CMD_RD_USB_DATA			;
				CALL  WR_CMD_TO_375			;
				MOVX A,@DPTR				;
				MOV  R6,A
				MOV  R7,A				;ȷR7
				MOV  R0,#CMD_BUFFER			;׵ַѰַ
CH375_SETUP_REC_CMD:		MOVX A,@DPTR				;
				MOV @R0,A				;ݷ
				INC R0
				DJNZ  R7,CH375_SETUP_REC_CMD  		;ȲΪ0
				CJNE R6,#8H,CH375_INT_RET		;ȲΪ8
				MOV  R0,#CMD_BUFFER
				MOV  A,CMD_BUFFER+6			;ȡƴĳ
				ANL  A,#7FH				;Ȳ128
				MOV VAR_SETUP_LENGTH,A			;洢
				MOV A,CMD_BUFFER			;жUSB
				JB  ACC.6,CH375_USB_REQ_FACT		;USB
				JB  ACC.5,CH375_USB_REQ_CLASS		;תUSB
				ANL  A,#0E0H
				CJNE A,#80H,CH375_REQUEST_OTHER1
				LJMP  CH375_REQUEST_STANDTRAD		;USB׼
CH375_REQUEST_OTHER1:		CJNE A,#00H,CH375_REQUEST_OTHER
				LJMP  CH375_REQUEST_STANDTRAD		;USB׼
CH375_REQUEST_OTHER:		LJMP  CH375_SETUP_RET_ERR		;֧
CH375_USB_REQ_FACT:		LJMP 	CH375_SETUP_RET			;
CH375_USB_REQ_CLASS:	LJMP 	CH375_SETUP_RET			;
;***************************************************************************************
;******************************USB STANDTRAD  REQUEST   STAR  **************************

;*************************************************************************************
;SELECT REQUEST
CH375_REQUEST_STANDTRAD:	MOV A,CMD_BUFFER+1			;USB׼
				MOV VAR_SETUP_REQUEST,A			;
				CJNE A,#DEF_USB_GET_STATUS,CH375_REQ_SEL_01				
				LJMP  CH375_USB_GET_STATUS
CH375_REQ_SEL_01:
				CJNE A,#DEF_USB_CLR_FEATURE,CH375_REQ_SEL_02				
				LJMP CH375_USB_CLR_FEATURE
CH375_REQ_SEL_02:
				CJNE A,#DEF_USB_SET_ADDRESS,CH375_REQ_SEL_03				
				LJMP CH375_USB_SET_ADDRES
CH375_REQ_SEL_03:
				CJNE A,#DEF_USB_GET_DESCR,CH375_REQ_SEL_04					;
				LJMP CH375_USB_GET_DESCR
CH375_REQ_SEL_04:
				CJNE A,#DEF_USB_GET_CONFIG,CH375_REQ_SEL_05				
				LJMP CH375_USB_GET_CONFIG
CH375_REQ_SEL_05:
				CJNE A,#DEF_USB_SET_CONFIG,CH375_REQ_SEL_06				
				LJMP  CH375_USB_SET_CONFIG
CH375_REQ_SEL_06:
				CJNE A,#DEF_USB_GET_INTERF,CH375_REQ_SEL_07			
				LJMP CH375_USB_GET_INTERF

CH375_REQ_SEL_07:		LJMP CH375_SETUP_RET_ERR


;*************************************************************************************************
;USB GET STATUS   õ״̬
CH375_USB_GET_STATUS:		MOV 	@R0,#00H
				INC 	R0
				MOV    @R0,#00H
				LCALL    CH375_EP0_UPLOAD		;ö˵0ϴ
				LJMP   	 CH375_SETUP_RET		;жϷ
CH375_SETUP_RET_ERR_1:		LJMP    CH375_SETUP_RET_ERR
;************************************************************************************************
;USB  CLR  FEATURE  
CH375_USB_CLR_FEATURE:         	MOV   	A,CMD_BUFFER		;ȡ
				ANL  	A,#1FH
				CJNE  	A,#02H,CH375_SETUP_RET_ERR_1	;Ƕ˵֧
				MOV  	A,CMD_BUFFER+4

				CJNE    A,#82H,CH375_USB_CLR_FEA_0
											;˵2ϴ
				MOV     A,#CMD_SET_ENDP7				;˵2ϴ
				CALL  WR_CMD_TO_375
				MOV     A,#8EH
				MOVX 	@DPTR,A
				LCALL CH375_EP0_IN_ZERO		;ϴ0Ϣ
				LJMP   CH375_SETUP_RET
						;
CH375_USB_CLR_FEA_0:		CJNE    A,#02H,CH375_USB_CLR_FEA_1
				MOV     A,#CMD_SET_ENDP6	;˵2´
				CALL  WR_CMD_TO_375
				MOV     A,#80H
				MOVX @DPTR,A
				LCALL CH375_EP0_IN_ZERO		;ϴ0Ϣ							;˵2´
				LJMP   CH375_SETUP_RET

CH375_USB_CLR_FEA_1:				CJNE    A,#81H,CH375_USB_CLR_FEA_2
				MOV     A,#CMD_SET_ENDP5	;˵1ϴ
				CALL  WR_CMD_TO_375
				MOV     A,#8EH							;˵1ϴ
				MOVX @DPTR,A
				LCALL CH375_EP0_IN_ZERO		;ϴ0Ϣ
				LJMP   CH375_SETUP_RET

CH375_USB_CLR_FEA_2:				CJNE    A,#01H,CH375_USB_CLR_FEA_3
				MOV     A,#CMD_SET_ENDP4	;˵1´
				CALL  WR_CMD_TO_375
				MOV     A,#80H							;˵1´
				MOVX @DPTR,A
				LCALL CH375_EP0_IN_ZERO		;ϴ0Ϣ
				LJMP	 CH375_SETUP_RET
CH375_USB_CLR_FEA_3:
				LJMP   CH375_SETUP_RET_ERR	;;֧
;****************************************************************************************
;USB  AET ADDRESS
CH375_USB_SET_ADDRES:		MOV A,CMD_BUFFER+2			;ȡַ
				MOV VAR_USB_ADDRESS,A			;ݴַ
				LCALL CH375_EP0_IN_ZERO		;ϴ0Ϣ
				LJMP CH375_SETUP_RET			;˳״̬ܷı

;*****************************************************************************************
;USB  GET  DESCR 
CH375_USB_GET_DESCR: 		MOV  A,CMD_BUFFER+3
				CJNE A,#1H,CH375_GET_DESCR_1	;ȡ豸
				MOV  A,#00H
				MOV  VAR_SETUP_DESCR,A		;ƫ=0
				LCALL CH375_DES_UPLOAD
				LJMP CH375_SETUP_RET
CH375_GET_DESCR_1:
				CJNE A,#2H,CH375_GET_DESCR_2
								;ȡ
				MOV  A,#USB_CFG_DESCR_TAB-USB_DEV_DESCR_TAB
				MOV  VAR_SETUP_DESCR,A		;ƫ
				LCALL CH375_DES_UPLOAD
				LJMP CH375_SETUP_RET
CH375_GET_DESCR_2:
CH375_GET_DESCR_3: 		LJMP   CH375_SETUP_RET_ERR	;֧˳

;*******************************************************************************************
;USB  GET CONFIG
CH375_USB_GET_CONFIG:		MOV  @R1,#01H			;ֵΪ01Hָ
				JB   CH375_CON_FLAG,CH375_CON_CON
				MOV  @R1,#00H			;CH375û÷00
CH375_CON_CON:			LCALL CH375_EP0_UPLOAD		;ö˵0ϴ
				LJMP  CH375_SETUP_RET

;********************************************************************************************
;USB SET  CONFIG
CH375_USB_SET_CONFIG:	MOV  A,CMD_BUFFER+2
				CLR  CH375_CON_FLAG		;ȡ
				SETB  CH375_CON_ACT
				JZ    CH375_USB_SET_CFG1
				SETB  CH375_CON_FLAG		;
				CLR   CH375_CON_ACT		;͵ƽָʾɱ־
CH375_USB_SET_CFG1:
				LCALL CH375_EP0_IN_ZERO		;ϴ0Ϣ
				LJMP  CH375_SETUP_RET
;*********************************************************************************************
;USB  GET INTER
CH375_USB_GET_INTERF:	  MOV   @R1,#01H			;һӿ
				LCALL CH375_EP0_UPLOAD		;Ϊָһӿ
				LJMP  CH375_SETUP_RET
;*********************************************************************************************
CH375_EP0_UPLOAD:		MOV  A,VAR_SETUP_LENGTH		;ȡ
				MOV R5,#08H
				CLR C
				SUBB A,R5
				MOV R5,VAR_SETUP_LENGTH		;ϴС8
				JC  CH375_EP0_UP_LEN
				MOV  VAR_SETUP_LENGTH,A		;¸
				MOV R5,#08H
CH375_EP0_UP_LEN:
				MOV R0,#CMD_BUFFER		;ϴR0
				MOV A,#CMD_WR_USB_DATA3		;룬д˵0
				CALL  WR_CMD_TO_375
				MOV  A,R5			;ϴ
				MOVX @DPTR,A			;ݳ375
CH375_EP0_UP_LOOP2:		MOV A,@R0			;ȡ			;
				MOVX @DPTR,A			;CH375
				INC R0				;ַһ
				DJNZ  R5,CH375_EP0_UP_LOOP2 	;
CH375_EP0_UP_LOOPRET:
				RET
;********************************************************************************************
CH375_DES_UPLOAD:		MOV R0,#CMD_BUFFER		;׵ַͼѰַ
				MOV R5,#08H
				MOV DPTR,#USB_DEV_DESCR_TAB	;
CH375_DES_UPLOOP:
				MOV  A,VAR_SETUP_DESCR
				LCALL CH375_TAB_TAB
				MOV @R0,A
				INC VAR_SETUP_DESCR
				INC R0
				DJNZ R5,CH375_DES_UPLOOP
				LCALL CH375_EP0_UPLOAD
				RET
;RERUEST OVER

CH375_EP0_IN_ZERO:
				MOV A,#CMD_WR_USB_DATA3  ;ϴ0ȵϢ
				CALL  WR_CMD_TO_375
				MOV A,#00H
				MOVX @DPTR,A
				RET
;********************************************************************************************


; ԺΪλʱ
; ENTRY: R7 ʱ
; USE:   ACC, R7
DELAY_MS:		MOV   A,#0FAH				;250*(1*6+2)*0.5=1000uS
DELAY_1MS:		NOP
				NOP
				NOP
				NOP
				NOP
				NOP
				DJNZ  ACC,DELAY_1MS			;ÿʱ1
				DJNZ  R7,DELAY_MS
				RET
;
;*********************************************************************************************************************
;
CH375_TAB_TAB:			MOVC A,@A+DPTR
				RET

USB_DEV_DESCR_TAB:	DB   12H							;USB豸
					DB   01H
					DB   10H
					DB   01H
					DB   0FFH							;04H, DeviceClass
					DB   80H							;05H, DeviceSubClass
					DB   37H							;06H, DeviceProtocol
					DB   08H							;˵08ֽ
					DB   48H				;08H, VendorId-L
					DB   43H				;09H, VendorId-H
					DB   37H				;0AH, ProductId-L
					DB   55H				;0BH, ProductId-H
					DB   00H							;0CH, ReleaseId-L
					DB   01H							;0DH, ReleaseId-H
					DB   00H
					DB   00H
					DB   00H							;10H, IndexSerialNumber
					DB   01H
					
USB_CFG_DESCR_TAB:	DB   09H							;USB
					DB   02H
					DB   27H							;02H, TotalLength-L
					DB   00H
					DB   01H
					DB   01H							;ֵ
					DB   00H
					DB   80H							;07H, Attributes
					DB   40H
					DB   09H							;USBӿ
					DB   04H
					DB   00H
					DB   00H
					DB   03H						;0DH, NumberEndpoints
					DB   0FFH							;0EH, InterfaceClass
					DB   80H							;0FH, InterfaceSubClass
					DB   37H							;10H, InterfaceProtocol
					DB   00H
					DB   07H
					DB   05H
					DB   82H							;˵82H/ϴ
					DB   02H							;˵
					DB   40H							;32ֽ
					DB   00H
					DB   00H
					DB   07H
					DB   05H
					DB   02H							;˵02H/´
					DB   02H							;˵
					DB   40H							;32ֽ
					DB   00H
					DB   00H
					DB   07H
					DB   05H
					DB   81H							;˵81H/ϴ
					DB   03H							;ж϶˵
					DB   08H							;8ֽ
					DB   00H
					DB   01H							;ѯʱ1
					DB   07H
					DB   05H
					DB   01H							;˵01H/´
					DB   02H							;˵
					DB   08H							;8ֽ
					DB   00H
					DB   00H
END
;
