/////////////////////////////////////////////////////////////////////////////
// GliD3D_Render.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"
#include "gl2ideal.h"

/////////////////////////////////////////////////////////////////////////////

inline void FlushAlphaBlendFunction(void)
{
	if( f_alpha_blend_function_rgb_sf == g_gr_state.alpha_blend_function_rgb_sf &&
		f_alpha_blend_function_rgb_df == g_gr_state.alpha_blend_function_rgb_df)
		return;
	f_alpha_blend_function_rgb_sf = g_gr_state.alpha_blend_function_rgb_sf;
	f_alpha_blend_function_rgb_df = g_gr_state.alpha_blend_function_rgb_df;
	glBlendFunc (src_blendmap[g_gr_state.alpha_blend_function_rgb_sf], 
				dst_blendmap[g_gr_state.alpha_blend_function_rgb_df]);
}

inline void FlushAlphaTestFunction(void)
{
	if( f_alpha_test_function == g_gr_state.alpha_test_function &&
		f_alpha_test_reference_value == g_gr_state.alpha_test_reference_value)
		return;
	f_alpha_test_function = g_gr_state.alpha_test_function;
	f_alpha_test_reference_value = g_gr_state.alpha_test_reference_value;
	glAlphaFunc (GL_NEVER + g_gr_state.alpha_test_function, g_gr_state.alpha_test_reference_value*f_255);
}

inline void FlushDepthTestFunction(void)
{
	if(f_depth_buffer_function == g_gr_state.depth_buffer_function)
		return;
	f_depth_buffer_function = g_gr_state.depth_buffer_function;
	glDepthFunc (GL_NEVER + g_gr_state.depth_buffer_function);
}

inline void FlushDepthMask(void)
{
#ifndef NO_FLUSH_DEPTHMASK
	if(f_depth_mask == g_gr_state.depth_mask)
		return;
	f_depth_mask = g_gr_state.depth_mask;
	glDepthMask (g_gr_state.depth_mask);
#endif	// NO_FLUSH_DEPTHMASK
}

inline void FlushCullMode(void)
{
	if (f_cull_mode == g_gr_state.cull_mode)
		return;
	f_cull_mode = g_gr_state.cull_mode;
	switch (g_gr_state.cull_mode) {
	case GR_CULL_DISABLE:
		glDisable (GL_CULL_FACE);
		break;
	case GR_CULL_NEGATIVE:
		glCullFace (GL_BACK);
		glEnable (GL_CULL_FACE);
		break;
	case GR_CULL_POSITIVE:
		glCullFace (GL_FRONT);
		glEnable (GL_CULL_FACE);
		break;
	}
}

inline void FlushTexEnvi(void)
{
	if(f_texenv == g_gr_texenv)
		return;
	f_texenv = g_gr_texenv;

	switch(g_gr_texenv){
	case GL_COMBINE_ALPHA_EXT:	// Hacking-Env
		glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_MODULATE);
		glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA_EXT, GL_REPLACE);
		glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
		return;
	case GL_COMBINE_EXT:
		glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_REPLACE);
		glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA_EXT, GL_MODULATE);
		break;
	case GL_COMBINE4_NV:
		glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_ADD);
		glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA_EXT, GL_ADD);
		break;
	}
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, g_gr_texenv);
}

inline void ColorAlphaCombineSetup ()
{
	if(!(noTexColor & noTexAlpha)) {
		if(combine_color_mode == 1){
			if(g_gr_bUseTexEnvCombine){
				combine_color_mode = 0;		// skip CheckColorMode()
				g_gr_texenv = GL_COMBINE_EXT;
			}else if(g_gr_bUseTexEnvBlendEmu){
				// Do same-color-blending to emulate this.
				// It is not perfect. (when local color is iterated)
				g_gr_texenv = GL_BLEND;		// or Reverse_Blend
			}
		}else if(noTexAlpha && g_gr_texenv == GL_MODULATE && g_gr_bUseTexEnvCombine){
			g_gr_texenv = GL_COMBINE_ALPHA_EXT;	// Hacking-Env
		}
		FlushTexEnvi();
		EnableTexture2D();
	}else{
		combine_color_mode = 0;		// skip CheckColorMode()
		DisableTexture2D();
	}
}

inline void FlushDrawState(bool doFlush = false)
{
	if(!flushDrawState)
		return;
	flushDrawState = 0;

	if(doFlush)
		FlushTriangleVertex();
	ColorAlphaCombineSetup();

	if (g_gr_state.alpha_blend_function_rgb_df == GR_BLEND_ZERO &&
		g_gr_state.alpha_blend_function_rgb_sf == GR_BLEND_ONE){
		DisableBlend();
	}else{
		FlushAlphaBlendFunction();
		EnableBlend();
	}
	if (g_gr_state.alpha_test_function == GR_CMP_ALWAYS ||
		g_gr_state.alpha_combine_other != GR_COMBINE_OTHER_TEXTURE)
		DisableAlphaTest();
	else{
		FlushAlphaTestFunction();
		EnableAlphaTest();
	}
	FlushDepthMask();
	FlushDepthTestFunction();
	FlushCullMode();
}

void InitDrawState(void)
{
	f_texenv = g_gr_texenv;
	f_alpha_blend_function_rgb_sf = g_gr_state.alpha_blend_function_rgb_sf;
	f_alpha_blend_function_rgb_df = g_gr_state.alpha_blend_function_rgb_df;
	f_alpha_test_function = g_gr_state.alpha_test_function;
	f_alpha_test_reference_value = g_gr_state.alpha_test_reference_value;
	f_depth_mask = g_gr_state.depth_mask;
	f_depth_buffer_function = g_gr_state.depth_buffer_function;
	f_cull_mode = g_gr_state.cull_mode;
	flushDrawState = 0;
}


inline void CheckColorMode(const GrVertex * a, bool colorConv = true)
{
	if(combine_color_mode == 0)
		return;

	if( combine_color_mode == 2) {
		const GL2IDE_COLOR	color = { {a->r*f_255, a->g*f_255, a->b*f_255}, a->a*f_255 };
		SetTexEnvColor(color);
	}else /*if(combine_color_mode == 1)*/{
		if(g_gr_texenv == GL_BLEND) {
			if(colorConv)
				ColorConvFromGrVertex(ptlv[0].color, a);
			SetTexEnvColor(ptlv[0].color);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

#define GLID3D_ANTIALIAS_ENABLE
#define GLID3D_ANTIALIAS_DISABLE

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY void FX_CALL grDrawLine (const GrVertex * a, const GrVertex * b)
{
	TRACEFUNCTION ("grDrawLine");

	FlushTriangleVertex();
	FlushDrawState();

	grsubSetVertexFromGrVertex (ptlv[0].cord, ptlv[0].color, ptlv[0].tcord, a);
	grsubSetVertexFromGrVertex (ptlv[1].cord, ptlv[1].color, ptlv[1].tcord, b);
	glBegin (GL_LINES);
	glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
	glColor4fv ((const GLfloat *)&ptlv[0].color);
#ifdef PRJ_PERSPECTIVE
	glVertex3fv ((const GLfloat *)&ptlv[0].cord);
#else
	glVertex4fv ((const GLfloat *)&ptlv[0].cord);
#endif // PRJ_PERSPECTIVE
	glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
	glColor4fv ((const GLfloat *)&ptlv[1].color);
#ifdef PRJ_PERSPECTIVE
	glVertex3fv ((const GLfloat *)&ptlv[1].cord);
#else
	glVertex4fv ((const GLfloat *)&ptlv[1].cord);
#endif // PRJ_PERSPECTIVE
	glEnd ();

}

FX_ENTRY void FX_CALL grDrawPlanarPolygon (int nverts, const int ilist[], const
	GrVertex vlist[])
{
	TRACEFUNCTION ("grDrawPlannarPolygon");

	FlushTriangleVertex();
	FlushDrawState();
	CheckColorMode(&vlist[ilist[0]]);

	int	i;

#ifdef USEVERTEXARRAY
	for (i = 0; i < nverts; i++) {
		grsubSetVertexFromGrVertex (CoordArray[i], ColorArray[i], TexCoordArray[i], &vlist[ilist[i]]);
	}
	glTexCoordPointer (2, GL_FLOAT, 0, TexCoordArray);
	glColorPointer( 4, GL_FLOAT, 0, ColorArray);
	glVertexPointer( 4, GL_FLOAT, 0, CoordArray);
	glDrawArrays( GL_POLYGON, 0, i);
#else
	glBegin (GL_POLYGON);
	for (i = 0; i < nverts; i++) {
		grsubSetVertexFromGrVertex (ptlv[0].cord, ptlv[0].color, ptlv[0].tcord, &vlist[ilist[i]]);
		glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
#ifdef PRJ_PERSPECTIVE
		glVertex3fv ((const GLfloat *)&ptlv[0].cord);
#else
		glVertex4fv ((const GLfloat *)&ptlv[0].cord);
#endif // PRJ_PERSPECTIVE
	}
	glEnd ();
#endif	//USEVERTEXARRAY
}

FX_ENTRY void FX_CALL grDrawPlanarPolygonVertexList (int nverts, const
	GrVertex vlist[])
{
	TRACEFUNCTION ("grPlanarPolygonVertexList");

	grDrawPolygonVertexList (nverts, vlist);
}

FX_ENTRY void FX_CALL grDrawPoint (const GrVertex * pt)
{
	TRACEFUNCTION ("grDrawPoint");

	FlushTriangleVertex();
	FlushDrawState();

	grsubSetVertexFromGrVertex (ptlv[0].cord, ptlv[0].color, ptlv[0].tcord, pt);
	glBegin (GL_POINTS);
	glColor4fv ((const GLfloat *)&ptlv[0].color);
#ifdef PRJ_PERSPECTIVE
	glVertex3fv ((const GLfloat *)&ptlv[0].cord);
#else
	glVertex4fv ((const GLfloat *)&ptlv[0].cord);
#endif // PRJ_PERSPECTIVE
	glEnd ();
}

// Untested
FX_ENTRY void FX_CALL grDrawPolygon (int nverts, const int ilist[], const
	GrVertex vlist[])
{
	TRACEFUNCTION ("grDrawPolygon");

	grDrawPlanarPolygon (nverts, ilist, vlist);
}

// Untested
FX_ENTRY void FX_CALL grDrawPolygonVertexList (int nverts, const GrVertex
	vlist[])
{
	TRACEFUNCTION ("grDrawPolygonVertexList");

	FlushTriangleVertex();
	FlushDrawState();
	CheckColorMode(&vlist[0]);

	int	i;

#ifdef USEVERTEXARRAY
	for (i = 0; i < nverts; i++) {
		grsubSetVertexFromGrVertex (CoordArray[i], ColorArray[i], TexCoordArray[i], &vlist[i]);
	}
	glTexCoordPointer (2, GL_FLOAT, 0, TexCoordArray);
	glColorPointer( 4, GL_FLOAT, 0, ColorArray);
	glVertexPointer( 4, GL_FLOAT, 0, CoordArray);
	glDrawArrays( GL_POLYGON, 0, i);
#else
	glBegin (GL_POLYGON);
	for (i = 0; i < nverts; i++) {
		grsubSetVertexFromGrVertex (ptlv[0].cord, ptlv[0].color, ptlv[0].tcord, &vlist[i]);
		glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
#ifdef PRJ_PERSPECTIVE
		glVertex3fv ((const GLfloat *)&ptlv[0].cord);
#else
		glVertex4fv ((const GLfloat *)&ptlv[0].cord);
#endif // PRJ_PERSPECTIVE
	}
	glEnd ();
#endif	//USEVERTEXARRAY
}

FX_ENTRY void FX_CALL grDrawTriangle (const GrVertex * a, const GrVertex *
	 b, const GrVertex * c)
{
	TRACEFUNCTION ("grDrawTriangle");

	FlushDrawState(true);

#ifdef USEVERTEXARRAY
	CheckColorMode(a);

	grsubSetVertexFromGrVertex(CoordArray[ArrayCount],
	  ColorArray[ArrayCount], TexCoordArray[ArrayCount], a);
	ArrayCount++;
	grsubSetVertexFromGrVertex(CoordArray[ArrayCount],
	  ColorArray[ArrayCount], TexCoordArray[ArrayCount], b);
	ArrayCount++;
	grsubSetVertexFromGrVertex(CoordArray[ArrayCount],
	  ColorArray[ArrayCount], TexCoordArray[ArrayCount], c);
	ArrayCount++;

	if (ArrayCount==MAXVERTEX)
		FlushTriangleVertex();

#else
#if 0
	ColorConvFromGrVertex(ptlv[0].color, a);
	ColorConvFromGrVertex(ptlv[1].color, b);
	ColorConvFromGrVertex(ptlv[2].color, c);
#else
	if(!g_gr_fix1){
		if(static_color_mode == GR_COMBINE_LOCAL_ITERATED){
			if(g_gr_state.alpha_combine_local == GR_COMBINE_LOCAL_ITERATED){
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_ITERATED, 0);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_ITERATED, 0);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_ITERATED, 0);
			}else{
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_CONSTANT, 0);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_CONSTANT, 0);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_CONSTANT, 0);
			}
		}else{
			if(g_gr_state.alpha_combine_local == GR_COMBINE_LOCAL_ITERATED){
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_ITERATED, 0);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_ITERATED, 0);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_ITERATED, 0);
			}else{
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_CONSTANT, 0);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_CONSTANT, 0);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_CONSTANT, 0);
			}
		}
	}else{
		if(static_color_mode == GR_COMBINE_LOCAL_ITERATED){
			if(g_gr_state.alpha_combine_local == GR_COMBINE_LOCAL_ITERATED){
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_ITERATED, 1);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_ITERATED, 1);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_ITERATED, 1);
			}else{
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_CONSTANT, 1);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_CONSTANT, 1);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_LOCAL_CONSTANT, 1);
			}
		}else{
			if(g_gr_state.alpha_combine_local == GR_COMBINE_LOCAL_ITERATED){
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_ITERATED, 1);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_ITERATED, 1);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_ITERATED, 1);
			}else{
				ColorConvFromGrVertex(ptlv[0].color, a, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_CONSTANT, 1);
				ColorConvFromGrVertex(ptlv[1].color, b, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_CONSTANT, 1);
				ColorConvFromGrVertex(ptlv[2].color, c, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_LOCAL_CONSTANT, 1);
			}
		}
	}
#endif
	CheckColorMode(a, false);

#ifdef CACHETRIANGLES
	if(!g_gr_DrawingTriangles){
		g_gr_DrawingTriangles = TRUE;
		glBegin(GL_TRIANGLES);
	}
#else
	glBegin(GL_TRIANGLES);
#endif	//CACHETRIANGLES
#ifdef PRJ_PERSPECTIVE
	if(g_gr_Texture2DOn){
		CoordConvFromGrVertex(ptlv[0].cord, ptlv[0].tcord, a, TRUE);
		CoordConvFromGrVertex(ptlv[1].cord, ptlv[1].tcord, b, TRUE);
		CoordConvFromGrVertex(ptlv[2].cord, ptlv[2].tcord, c, TRUE);
		glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
		glVertex3fv ((const GLfloat*)&ptlv[0].cord);
		glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
		glColor4fv ((const GLfloat*)&ptlv[1].color);
		glVertex3fv ((const GLfloat*)&ptlv[1].cord);
		glTexCoord2fv ((const GLfloat *)&ptlv[2].tcord);
		glColor4fv ((const GLfloat*)&ptlv[2].color);
		glVertex3fv ((const GLfloat*)&ptlv[2].cord);
	}else{
		CoordConvFromGrVertex(ptlv[0].cord, ptlv[0].tcord, a, FALSE);
		CoordConvFromGrVertex(ptlv[1].cord, ptlv[1].tcord, b, FALSE);
		CoordConvFromGrVertex(ptlv[2].cord, ptlv[2].tcord, c, FALSE);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
		glVertex3fv ((const GLfloat*)&ptlv[0].cord);
		glColor4fv ((const GLfloat*)&ptlv[1].color);
		glVertex3fv ((const GLfloat*)&ptlv[1].cord);
		glColor4fv ((const GLfloat*)&ptlv[2].color);
		glVertex3fv ((const GLfloat*)&ptlv[2].cord);
	}
#else
	if(g_gr_Texture2DOn){
		CoordConvFromGrVertex(ptlv[0].cord, ptlv[0].tcord, a, TRUE);
		CoordConvFromGrVertex(ptlv[1].cord, ptlv[1].tcord, b, TRUE);
		CoordConvFromGrVertex(ptlv[2].cord, ptlv[2].tcord, c, TRUE);
		glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
		glVertex4fv ((const GLfloat*)&ptlv[0].cord);
		glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
		glColor4fv ((const GLfloat*)&ptlv[1].color);
		glVertex4fv ((const GLfloat*)&ptlv[1].cord);
		glTexCoord2fv ((const GLfloat *)&ptlv[2].tcord);
		glColor4fv ((const GLfloat*)&ptlv[2].color);
		glVertex4fv ((const GLfloat*)&ptlv[2].cord);
	}else{
		CoordConvFromGrVertex(ptlv[0].cord, ptlv[0].tcord, a, FALSE);
		CoordConvFromGrVertex(ptlv[1].cord, ptlv[1].tcord, b, FALSE);
		CoordConvFromGrVertex(ptlv[2].cord, ptlv[2].tcord, c, FALSE);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
		glVertex4fv ((const GLfloat*)&ptlv[0].cord);
		glColor4fv ((const GLfloat*)&ptlv[1].color);
		glVertex4fv ((const GLfloat*)&ptlv[1].cord);
		glColor4fv ((const GLfloat*)&ptlv[2].color);
		glVertex4fv ((const GLfloat*)&ptlv[2].cord);
	}
#endif // PRJ_PERSPECTIVE
#ifdef CACHETRIANGLES
#else
	glEnd();
#endif	//CACHETRIANGLES

#endif	//USEVERTEXARRAY
}

FX_ENTRY void FX_CALL guAADrawTriangleWithClip (const GrVertex * a, const GrVertex
	 * b, const GrVertex * c)
{
	 TRACEFUNCTION ("guAADrawTriangleWithClip");

	 GLID3D_ANTIALIAS_ENABLE
	 guDrawTriangleWithClip (a, b, c);
	 GLID3D_ANTIALIAS_DISABLE
}

FX_ENTRY void FX_CALL guDrawTriangleWithClip (const GrVertex * a,
	 const GrVertex * b,
	 const GrVertex * c
)
{
	 TRACEFUNCTION ("guDrawTriangleWithClip");
	 grDrawTriangle (a, b, c);
}

FX_ENTRY void FX_CALL guDrawPolygonVertexListWithClip (int nverts, const
	 GrVertex vlist[])
{
	 TRACEFUNCTION ("guDrawPolygonVertexListWithClip");
	 grDrawPolygonVertexList (nverts, vlist);
}

/////////////////////////////////////////////////////////////////////////////
