#define XGLColor uint32


struct sSettings {
	DWORD colorop_add;
	DWORD colorop_blendtexturealpha;
	DWORD alphaop_modulate;
	DWORD clamp;
	DWORD aa;
	DWORD zbits;
	DWORD vsync;
	DWORD tmumem;
	DWORD model;
	DWORD backbuffers;
	DWORD fps;
	DWORD priority;
	DWORD logging;
	DWORD atifix;
};


struct sDX {
	LPDIRECTDRAW4					DD;
	LPDIRECT3D3						D3D;

	LPDIRECTDRAWSURFACE4			DDSPrimary;
	LPDIRECTDRAWSURFACE4			DDSRender;
	LPDIRECTDRAWSURFACE4			DDSZBuffer;
	D3DDEVICEDESC					D3DHD;
	D3DDEVICEDESC					D3DSD;
	HWND							hWnd;
	LPDIRECT3DDEVICE3				D3DD;

	LPDIRECT3DVIEWPORT3				D3DViewport;

};

class Tex;

struct sVoodoo {
	uint32				tmumem;
	uint32				width;
	uint32				height;
	uint32				refresh;
	PALETTEENTRY		palette[256];
	int					palnum;			// Unique palette identifier
	Tex					*curtex;
	D3DVIEWPORT2		viewport;

	uint32				origin;
	uint32				dbmode;
	uint32				colorFormat;
	uint32				texture;
	uint32				Zdepth;

	D3DCOLOR			constantColor;
	DWORD				colorKey;
	int					colorkeyon;

	float				CCR, CCG, CCB, CCA;

	uint32				ccLocal;
	uint32				ccFunc;

	int					uclamp;
	int					vclamp;

	int					openwindow;

//	int					multitexture;

//	int					lastpolytype;
};


struct XGLTmuVertex{
  float sow, tow, oow;
};

struct XGLVertex {
  float			x, y, z;
  float			r, g, b;
  float			ooz;
  float			a;
  float			oow;
  XGLTmuVertex	tmuvertex[XGLNUM_TMU];
};


struct XGLTmuConfig {
	uint32	revision;
	uint32	mem;
};

struct XGLBoardConfig {
	uint32			num;

    uint32			type;

	uint32			mem;
	uint32			revision;
	uint32			numtmu;
	uint32			sli;
	XGLTmuConfig	tmu[XGLNUM_TMU];
};


struct XGL3dfInfo {
	uint32	width, height;
	uint32	smalllod, largelod;
	uint32	aspect;
	uint32	format;
	uint32	palette[256];
	uchar	*data;
	uint32	mem;
};



struct XGLTexture {
    uint32	smalllod;
    uint32	largelod;
    uint32	aspect;
    uint32	format;
    uint8	*data;
};


struct XGLLock {
    uint32	size;
    void	*surface;
    uint32	pitch;        
    uint32	mode;
    uint32	origin;
};

struct XGLCCState {
	uint8			set;
	D3DCOLOR		(*getcolor)(const XGLVertex &);
	D3DTEXTUREOP	colorop;
	uint32			colorarg1;
	uint32			colorarg2;
};

struct XGLTexFormat {
	DDPIXELFORMAT	pixelformat;
	void			(*ckcolorconv)(uchar *, uchar *);
	void			(*texcolorconv)(uchar *, uchar *);
	uint32			paletted;
	uint32			sbpp;
	uint32			dbpp;

};
