


extern "C" {


// buffer.cpp
XGLLINK void XGLCALL grBufferSwap(uint32);
XGLLINK void XGLCALL grRenderBuffer(uint32);
XGLLINK void XGLCALL grDepthBufferFunction(uint32);
XGLLINK void XGLCALL grClipWindow(uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL grDepthBufferMode(uint32);
XGLLINK void XGLCALL grBufferClear(uint32, uint32, uint32);
XGLLINK uint32 XGLCALL grBufferNumPending();

// color.cpp
XGLLINK void XGLCALL grAlphaControlsITRGBLighting(uint32);
XGLLINK void XGLCALL grChromakeyValue(uint32);
XGLLINK void XGLCALL grChromakeyMode(uint32);
XGLLINK void XGLCALL grAlphaTestReferenceValue(uint8);
XGLLINK void XGLCALL grAlphaBlendFunction(uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL grAlphaTestFunction(uint32);
XGLLINK void XGLCALL grColorMask(uint32, uint32);
XGLLINK void XGLCALL grAlphaCombine(uint32, uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL grConstantColorValue(uint32);
XGLLINK void XGLCALL grConstantColorValue4(float, float, float, float);
XGLLINK void XGLCALL grColorCombine(uint32, uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL guAlphaSource(uint32);
XGLLINK void XGLCALL guColorCombineFunction(uint32);

// fog.cpp
XGLLINK void XGLCALL guFogGenerateExp(uint32, uint32);
XGLLINK void XGLCALL guFogGenerateExp2(uint32, uint32);
XGLLINK void XGLCALL guFogGenerateLinear(uint32, uint32, uint32);
XGLLINK void XGLCALL grFogColorValue(uint32);
XGLLINK void XGLCALL grFogTable(uint32);
XGLLINK float XGLCALL guFogTableIndexToW(uint32);
XGLLINK void XGLCALL grFogMode(uint32);


// init.cpp
XGLLINK void XGLCALL grGlideInit();
XGLLINK void XGLCALL grGlideGetVersion(char *ver);
XGLLINK void XGLCALL grGlideShutdown();
XGLLINK void XGLCALL grGlideGetState(void *);
XGLLINK void XGLCALL grGlideSetState(void *);


// lfb.cpp
XGLLINK uint32 XGLCALL grLfbLock(uint32, uint32, uint32, uint32, uint32, XGLLock *);
XGLLINK uint32 XGLCALL grLfbUnlock(uint32, uint32);
XGLLINK uint32 XGLCALL grLfbWriteRegion(uint32, uint32, uint32, uint32, uint32, uint32, uint32, uchar *);
XGLLINK uint32 XGLCALL grLfbReadRegion(uint32, uint32, uint32, uint32, uint32, uint32, uchar *);

// other.cpp
XGLLINK void XGLCALL grSstOrigin(uint32);
XGLLINK void XGLCALL grCullMode(uint32);
XGLLINK uint32 XGLCALL gu3dfGetInfo(char *, XGL3dfInfo *);
XGLLINK uint32 XGLCALL gu3dfLoad(char *, XGL3dfInfo *);
XGLLINK void XGLCALL grDepthBiasLevel(uint32);
XGLLINK void XGLCALL grDepthMask(uint32);

// polygon.cpp
XGLLINK void XGLCALL grDrawTriangle(XGLVertex *, XGLVertex *, XGLVertex *);
XGLLINK void XGLCALL grAADrawTriangle(XGLVertex *, XGLVertex *, XGLVertex *, uint32, uint32, uint32);
XGLLINK void XGLCALL guDrawTriangleWithClip(XGLVertex *, XGLVertex *, XGLVertex *);

XGLLINK void XGLCALL grDrawLine(XGLVertex *, XGLVertex *);
XGLLINK void XGLCALL grAADrawLine(XGLVertex *, XGLVertex *);

XGLLINK void XGLCALL grDrawPoint(XGLVertex *);
XGLLINK void XGLCALL grAADrawPoint(XGLVertex *);

XGLLINK void XGLCALL grDrawPolygonVertexList(uint32, XGLVertex *);
XGLLINK void XGLCALL grDrawPlanarPolygonVertexList(uint32, XGLVertex *);
XGLLINK void XGLCALL grAADrawPolygonVertexList(uint32, XGLVertex *);

XGLLINK void XGLCALL grDrawPolygon(uint32, uint32 *, XGLVertex *);
XGLLINK void XGLCALL grDrawPlanarPolygon(uint32, uint32 *, XGLVertex *);

// sst.cpp
XGLLINK uint32 XGLCALL grSstStatus();
XGLLINK void XGLCALL grSstIdle();
XGLLINK uint32 XGLCALL grSstIsBusy();
XGLLINK uint32 XGLCALL grSstWinOpen(uint32, uint32, uint32, uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL grSstWinClose();
XGLLINK void XGLCALL grSstSelect(uint32);
XGLLINK uint32 XGLCALL grSstScreenHeight();
XGLLINK uint32 XGLCALL grSstScreenWidth();
XGLLINK uint32 XGLCALL grSstQueryHardware(XGLBoardConfig *);
XGLLINK uint32 XGLCALL grSstQueryBoards(XGLBoardConfig *);
XGLLINK uint32 XGLCALL grSstControl(uint32);
XGLLINK uint32 XGLCALL grSstVRetraceOn();
XGLLINK uint32 XGLCALL grSstVideoLine();

// texture.cpp
XGLLINK void XGLCALL grTexDownloadTable(uint32, uint32, void *);
XGLLINK void XGLCALL grTexNCCTable(uint32, uint32);
XGLLINK uint32 XGLCALL grTexCalcMemRequired(uint32, uint32, uint32, uint32);
XGLLINK uint32 XGLCALL grTexTextureMemRequired(uint32, void *);
XGLLINK void XGLCALL grTexDownloadMipMap(uint32, uint32, uint32, XGLTexture *);
XGLLINK void XGLCALL grTexDownloadMipMapLevel(uint32, uint32, uint32, uint32, uint32, uint32, uint32, uchar *);
XGLLINK void XGLCALL grTexDownloadMipMapLevelPartial(uint32, uint32, uint32, uint32, uint32, uint32, uint32, void *, uint32, uint32);
XGLLINK uint32 XGLCALL grTexMinAddress(uint32);
XGLLINK uint32 XGLCALL grTexMaxAddress(uint32);
XGLLINK void XGLCALL grTexLodBiasValue(uint32, float);
XGLLINK void XGLCALL grTexClampMode(uint32, uint32, uint32);
XGLLINK void XGLCALL guTexCombineFunction(uint32, uint32);
XGLLINK void XGLCALL grTexMipMapMode(uint32, uint32, uint32);
XGLLINK void XGLCALL grTexFilterMode(uint32, uint32, uint32);
XGLLINK void XGLCALL grTexDetailControl(uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL grTexSource(uint32, uint32, uint32, XGLTexture *);
//XGLLINK uint32 XGLCALL guTexAllocateMemory(uint32, uint8, int, int, uint32, uint32, uint32, uint32, uint32, uint32,	uint32,	uint32, uint32, float, uint32);
XGLLINK void XGLCALL guTexDownloadMipMap(uint32, uint32, uint32);
XGLLINK void XGLCALL guTexSource(uint32);
XGLLINK void XGLCALL grTexCombine(uint32, uint32, uint32, uint32, uint32, uint32, uint32);
XGLLINK void XGLCALL grTexCombineFunction(uint32, uint32);
XGLLINK uint32 XGLCALL guTexAllocateMemory(uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32, uint32);

// util.cpp
XGLLINK void XGLCALL grHints(uint32, uint32);
XGLLINK void XGLCALL grGammaCorrectionValue(float);
XGLLINK void XGLCALL grErrorSetCallback(void *);
XGLLINK void XGLCALL grDitherMode(uint32);
XGLLINK void XGLCALL grDisableAllEffects();

}




D3DCOLOR colorconv(XGLColor);


D3DCOLOR iterated(const XGLVertex &);
D3DCOLOR iterated2(const XGLVertex &);
D3DCOLOR iterconst(const XGLVertex &);
D3DCOLOR constant(const XGLVertex &);
D3DCOLOR constant2(const XGLVertex &);
D3DCOLOR white(const XGLVertex &);
D3DCOLOR black(const XGLVertex &);
extern D3DCOLOR (*getcolor)(const XGLVertex &);


void vconv_D_UL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_UL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z16_UL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z24_UL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z32_UL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_Z_UL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_D_LL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_LL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z16_LL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z24_LL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z32_LL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_Z_LL_T(const XGLVertex &, D3DTLVERTEX &);
void vconv_D_UL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_UL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z16_UL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z24_UL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z32_UL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_Z_UL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_D_LL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_LL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z16_LL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z24_LL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_W_Z32_LL_NT(const XGLVertex &, D3DTLVERTEX &);
void vconv_Z_LL_NT(const XGLVertex &, D3DTLVERTEX &);
extern void (*vconv)(const XGLVertex &, D3DTLVERTEX &);

uint32 getTextureFormat(char *);
uint32 getAspectRatio(uint32, uint32);
uint32 getBytesPerPixel(uint32);
uint32 getLfbBytesPerPixel(uint32);
uint32 getMemRequired(XGL3dfInfo *, uint32, uint32, uint32, uint32);
uint32 TexMemCalc(uint32, uint32, uint32, uint32, uint32);
void table_init();
int getcaps();
int getzbuffer(DDPIXELFORMAT &);
int loadsettings();


