#include <windows.h>
#include <stdio.h>


FILE *fp;


UINT8 buf[0x800000];
INT32 bufSize;



// MIDI channel remap - 16-bit
INT16 patch1Scan[] =
{
	0x8B, 0xDF,

	0x4B,
	0x2E, 0x80, 0xBF, 0x100, 0x100, 0xFF,
	0x75, 0xF7,

	0x8B, 0xFB,
	0x2E, 0x8A, 0x84, 0x101, 0x101,
	0x2E, 0x88, 0x85, 0x102, 0x102,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00,
	0xD1, 0xEB,
	0xD1, 0xEB
};


INT16 patch1Raw[] =
{
	0x4F,
	0x83, 0xFF, 0x09,
	0x74, 0xFA,

	0x2E, 0x80, 0xBD, 0x100, 0x100, 0xFF,
	0x75, 0xF2,

	0x2E, 0x8A, 0x84, 0x101, 0x101,
	0x2E, 0x88, 0x85, 0x102, 0x102,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00,
	0xC1, 0xEB, 0x02,
};



// MIDI channel remap - 32-bit
INT16 patch2Scan[] =
{
	0x66, 0x8B, 0xDF,
	0x81, 0xE3, 0xFF, 0xFF, 0x00, 0x00,

	0x66, 0x4B,
	0x80, 0xBB, 0x200, 0x200, 0x200, 0x200, 0xFF,
	0x75, 0xF5,

	0x66, 0x8B, 0xFB,
	0x8A, 0x86, 0x201, 0x201, 0x201, 0x201,
	0x88, 0x87, 0x202, 0x202, 0x202, 0x202,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00, 0x00, 0x00,
	0x66, 0xD1, 0xEB,
	0x66, 0xD1, 0xEB,
};


INT16 patch2Raw[] =
{
	0x90, 0x90, 0x90,

	0x66, 0x4F,
	0x66, 0x83, 0xFF, 0x09,
	0x74, 0xF8,

	0x80, 0xBF, 0x200, 0x200, 0x200, 0x200, 0xFF,
	0x75, 0xEF,

	0x90, 0x90, 0x90,
	0x8A, 0x86, 0x201, 0x201, 0x201, 0x201,
	0x88, 0x87, 0x202, 0x202, 0x202, 0x202,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00, 0x00, 0x00,
	0x66, 0xC1, 0xEB, 0x02,
	0x90, 0x90
};



// 8-bit DAC conversion  (32-bit)
INT16 patch3Scan[] =
{
	0x66, 0xAD,
	0xB0, 0x80,
	0x2A, 0xC4,
	0xAA,
	0xE2, 0xF7
};


INT16 patch3Raw[] =
{
	0xAC, 0xAC,
	0x04, 0x80,
	0xAA, 0xE2,
	0xF9, 0x90,
	0x90
};



// 16-bit DAC conversion  (32-bit)
INT16 patch3aScan[] =
{
	0xAC,
	0xB4, 0x80,
	0x2A, 0xE0,
	0x72, 0x04,
	0xB0, 0x00,
	0xEB, 0x02,

	0xB0, 0xFF,
	0x66, 0xAB,
	0xE2, 0xEF,
};


INT16 patch3aRaw[] =
{
	0xAC,
	0x04, 0x80,
	0x66,	0xC1,
	0xE0, 0x08,
	0x66, 0xAB,
	0xE2, 0xF5,
	0x90, 0x90, 0x90, 0x90, 0x90, 0x90
};



// 8-bit DAC convert  (16-bit DOS)
INT16 patch4Scan[] =
{
	0xB0, 0x7F,
	0x2A, 0xC4,
	0xEB, 0x02,

	0x8A, 0xC4,
	0xAA
};


INT16 patch4Raw[] =
{
	0x80, 0xC4, 0x80,
	0x90, 0x90, 0x90,
};



// 8-bit DAC convert  (16-bit WIN)
INT16 patch4aScan[] =
{
	0xB0, 0x7F,
	0x26, 0x2A, 0x07,
	0xEB, 0xD5
};


INT16 patch4aRaw[] =
{
	0xB0, 0x80,
	0x26, 0x02, 0x07
};



// NewRisingSun
// - enable digital for MT-32, General MIDI devices

INT16 patchKrondorScan[] =
{
	0x83, 0x3E, -1, -1, 0x04,
	0x75, 0x0A,

	0x68, -1, -1,
	0x66, 0x6A, 0x00,
	0x6A, 0x02,
	0xEB, 0x0D,

	0x68, -1, -1,
	0x66, 0x68, 0xFE, 0xFF, 0x00, 0x00,
};


INT16 patchKrondorRaw[] = 
{
	0x83, 0x3E, -1, -1, 0x04,
	0x75, 0x0A,

	0x68, -1, -1,
	0x66, 0x6A, 0x00,
	0x6A, 0x02,
	0xEB, 0x0D,

	0x68, -1, -1,
	0x66, 0x68, 0x00, 0x00, 0x00, 0x00,
};



INT Patch( INT type, INT addr, INT scanSize, INT patchSize, INT16 patchScan[], INT16 patchRaw[] )
{
	INT16 ptr[256];
	INT16 ptr32[256];


	scanSize /= sizeof( INT16 );
	patchSize /= sizeof( INT16 );



	for( INT lcv = 0; lcv < scanSize; lcv++ )
	{
		// wildcard - skip byte
		if( patchScan[ lcv ] == (INT16) -1 )
			continue;


		// wildcard - ptr 16-bit
		if( patchScan[ lcv ] >= (INT16) 0x100 &&
				patchScan[ lcv ] < (INT16) 0x200 )
		{
			ptr[ patchScan[lcv] - 0x100 ] = *( (INT16 *) ( buf + addr + lcv ) );
			lcv++;

			continue;
		}


		// wildcard - ptr 16-bit
		if( patchScan[ lcv ] >= (INT16) 0x200 &&
				patchScan[ lcv ] < (INT16) 0x300 )
		{
			ptr32[ patchScan[lcv] - 0x200 ] = *( (INT32 *) ( buf + addr + lcv ) );
			lcv += 3;

			continue;
		}


		if( (UINT8) patchScan[ lcv ] != buf[ addr + lcv ] )
			break;
	}


	// not found
	if( lcv != scanSize )
		return 0;


	// #################################################
	// #################################################
	// #################################################

	for( lcv = 0; lcv < patchSize; lcv++ )
	{
		// wildcard - skip byte
		if( patchRaw[ lcv ] == (INT16) -1 )
			continue;


		// wildcard - ptr
		if( patchRaw[ lcv ] >= (INT16) 0x100 &&
				patchRaw[ lcv ] < (INT16) 0x200 )
		{
			*( (INT16 *) ( buf + addr + lcv ) ) = ptr[ patchRaw[lcv] - 0x100 ];
			lcv++;

			continue;
		}


		// wildcard - ptr32
		if( patchRaw[ lcv ] >= (INT16) 0x200 &&
				patchRaw[ lcv ] < (INT16) 0x300 )
		{
			*( (INT32 *) ( buf + addr + lcv ) ) = ptr32[ patchRaw[lcv] - 0x200 ];
			lcv += 3;

			continue;
		}


		buf[ addr + lcv ] = (UINT8) patchRaw[ lcv ];
	}


	return 1;
}



VOID File( char *str )
{
	BOOL found;
	BOOL krondor;


	found = FALSE;
	krondor = FALSE;


	fp = fopen( str, "rb+" );
	if( !fp )
		return;



	// special
	if( strcmp( str, "KRONDOR.EXE" ) == 0 )
		krondor = TRUE;



	// file size
	fseek( fp, 0, SEEK_END );
	bufSize = ftell(fp);


	fseek( fp, 0, SEEK_SET );
	fread( buf, 1, bufSize, fp );



	// scan for pattern
	for( INT lcv = 0; lcv < bufSize; lcv++ )
	{
		// 16-bit engine
		if( Patch( 1, lcv, sizeof(patch1Scan), sizeof(patch1Raw), patch1Scan, patch1Raw ) )
			MessageBox( 0, "Patch - MIDI channel remap", str, MB_OK );


		// 32-bit engine
		if( Patch( 1, lcv, sizeof(patch2Scan), sizeof(patch2Raw), patch2Scan, patch2Raw ) )
			MessageBox( 0, "Patch - MIDI channel remap", str, MB_OK );




		// 32-bit engine
		if( Patch( 1, lcv, sizeof(patch3Scan), sizeof(patch3Raw), patch3Scan, patch3Raw ) )
			MessageBox( 0, "Patch - 8-bit DAC converter", str, MB_OK );


		if( Patch( 1, lcv, sizeof(patch3aScan), sizeof(patch3aRaw), patch3aScan, patch3aRaw ) )
			MessageBox( 0, "Patch - 16-bit DAC converter", str, MB_OK );



		// 16-bit engine
		if( Patch( 1, lcv, sizeof(patch4Scan), sizeof(patch4Raw), patch4Scan, patch4Raw ) )
			MessageBox( 0, "Patch - 8-bit DAC converter", str, MB_OK );


		if( Patch( 1, lcv, sizeof(patch4aScan), sizeof(patch4aRaw), patch4aScan, patch4aRaw ) )
			MessageBox( 0, "Patch - 8-bit DAC converter", str, MB_OK );





		if( krondor )
		{
			if( Patch( 1, lcv, sizeof(patchKrondorScan), sizeof(patchKrondorRaw), patchKrondorScan, patchKrondorRaw ) )
				MessageBox( 0, "Patch - digital sound", str, MB_OK );
		}
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// set to write mode
	fseek( fp, 0, SEEK_SET );


	fwrite( buf, 1, bufSize, fp );
	fclose( fp );
}



INT CALLBACK WinMain( HINSTANCE, HINSTANCE, LPSTR, INT )
{
	// Sierra
	File( "SIERRA.EXE" );
	File( "SIERRAW.EXE" );
	File( "SCIWV.EXE" );
	File( "SCIWIN.EXE" );


	// Sierra - 16-bit dac
	File( "AUDBLAST.DRV" );
	File( "AUDCDROM.DRV" );
	File( "AUDDISNY.DRV" );
	File( "AUDMSSYS.DRV" );
	File( "AUDNONE.DRV" );
	File( "AUDPRO.DRV" );
	File( "AUDPRO16.DRV" );
	File( "AUDPS1.DRV" );
	File( "AUDTANDY.DRV" );
	File( "AUDTHUND.DRV" );


	// Dynamix
	File( "TIM.EXE" );
	File( "TIM2.EXE" );
	File( "KRONDOR.EXE" );
	File( "TURBOSCI.EXE" );


	return 0;
}
