bool IsD3D(const void* ptr, const char* name) {
  char ClassName[255]; DWORD NameLen = 256;
  if (!ptr) return false;
  try {
     LPDIRECT3DRMOBJECT(ptr)->
               GetClassName(&NameLen, ClassName);
  } catch (EAccessViolation&) {return false;}
  if (strcmp(ClassName, name) == 0) return true;
  else return false;
}//---------------------------------------------------------
bool IsFrame(const void* ptr) {
  return IsD3D(ptr, "Frame");
}//---------------------------------------------------------
bool IsFace(const void* ptr) {
  return IsD3D(ptr, "Face");
}//---------------------------------------------------------
bool IsMesh(const void* ptr) {
  return IsD3D(ptr, "Mesh");
}//---------------------------------------------------------
bool IsBuilder(const void* ptr) {
  return IsD3D(ptr, "Builder");
}//---------------------------------------------------------
bool IsTexture(const void* ptr) {
  return IsD3D(ptr, "Texture");
}//---------------------------------------------------------
bool IsLight(const void* ptr) {
  return IsD3D(ptr, "Light");
}//---------------------------------------------------------
bool IsShadow(const void* ptr) {
  return IsD3D(ptr, "Shadow");
}//---------------------------------------------------------
bool IsVisual(const void* ptr) {
  if (!ptr) return false;
  LPDIRECT3DRMVISUAL I = NULL;
  HRESULT hr;
  try {
     hr = LPDIRECT3DRMOBJECT(ptr)->
     QueryInterface(IID_IDirect3DRMVisual, (void **) &I);
  } catch (EAccessViolation&) {return false;}
  if (HR_FAILED(hr)) {
     if (I) I->Release();
     return false;
  }
  if (I) I->Release();
  return true;
}//---------------------------------------------------------