void __fastcall TDxfXCnvForm::btnConvertClick(TObject*) {
  char buf[512];
  CountTable.Clear();
  ClearFrame(IDxfFrame);
  RELEASE(IDxfFrame);
  IRM->CreateFrame(NULL, &IDxfFrame);
  assert(IDxfFrame);

  //   :
  sops = 0;
  if (cbMaterial->Checked)  sops |= D3DRMXOFSAVE_MATERIALS;
  if (cbTemplates->Checked) sops |= D3DRMXOFSAVE_TEMPLATES;
  //    :
  DxfFile = NameEdit->Text;
  if (!FileExists(DxfFile)) {
     sprintf(buf,
        "File \"%s\" not found!\n", DxfFile.c_str());
     Application->MessageBox(buf,
        Application->Title.c_str(),
        MB_OK | MB_ICONERROR);
     return;
  }
  //     
  // :
  XFile = ChangeFileExt(DxfFile, ".X");
  if (FileExists(XFile)) {
     sprintf(buf,
        "File \"%s\" already exists!\nOk to overwrite?",
        XFile.c_str());
     if (Application->MessageBox(buf,
         Application->Title.c_str(),
         MB_YESNO | MB_ICONQUESTION) == ID_NO)
     return;
  }
  //   :
  btnConvert->Enabled = false;
  btnAbort->Enabled   = true;
  gbOptions->Enabled  = false;
  //  :
  try {
     //    DXF :
     DxfModel->ReadFromFile(DxfFile.c_str());
     //     DXF :
     IDxfFrame->SetName(ChangeFileExt(
                       ExtractFileName(XFile), "").c_str());
     BlockToFrame(DxfModel->BlockTable.data("Entities"),
                                                 IDxfFrame);
     //    X :
     SaveFrame(IDxfFrame, XFile.c_str(), D3DRMXOF_TEXT, sops);
  } catch(Exception &exception) {
     //     , 
     //    
     Application->ShowException(&exception);
  }
  //      :
  btnConvert->Enabled   = true;
  btnAbort->Enabled     = false;
  gbOptions->Enabled    = true;
  ProgressBar->Position = 0;
}//---------------------------------------------------------
