import Sav.Z.*;
import java.io.*;
/**
 * The example sequentially prints information about each user.
 */
public class ScriptDemo {
  public static void main(String arg[]) throws IOException {
    Session ss = new Session();
    String text0 =
      "$base Users ~;" +
      "$readTable() <" +
        "User  ; Name   ; Resource     \n" +
        "ann1  ; Ann    ; data1, data2 \n" +
        "dan   ; Daniel ; data1, data3 \n" +
      ">;"
    ;
    ss.z(text0);
    if (ss.hasWarnings())
      return;
    /*Demo1*****************/
    String names[] = { "Ann", "Daniel" };
    String text =
      "$mul user ~;" +
      "$user = =User/(Name:$name);"
    ;
    Script scr = new Script(text);
    ss.analyse(scr);
    if (!scr.hasErrors()) {
      ss.useBase("Users");
      for (int i = 0; i < names.length; ++i) {
        ss.set("name", names[i]);
        ss.execute(scr);
        String users[] = ss.get("user");
        System.out.println((i + 1) + ": Name: " + names[i] + ", User: " + users[0]);
      }
      ss.closeBase("Users");
    }
    /***********************/
  }
}