*********************************************************************
* SLIST.PRG - Modified version of the output from FoxPro's screen
*             builder
*********************************************************************
PARAMETER aAvail, aSelected, cTitle
IF EMPTY(cTitle)          && Supply default title
   cTitle="Make Your Selections and Place Them In Any Order"
ENDIF

DEFINE WINDOW wpicklist FROM INT((SROW()-19)/2),INT((SCOL()-58)/2) ;
 TO INT((SROW()-19)/2)+18,INT((SCOL()-58)/2)+57 TITLE cTitle ;
      FLOAT NOCLOSE SHADOW DOUBLE COLOR SCHEME 5

nBarctr = 0               && BAR index counter, never decrements
                          &&  as the popup is relative
nSelected = 0             && counter for the Selected array
nAvail = ALEN(aAvail)     && number of items in the Available array
nAvailpos = 1             && initial/current position of bar in Available list
nSelpos = 0               && initial/current position of bar in Selected list
cOKCancel = ""            && return value of OK and Cancel buttons
DEFINE POPUP pSelected RELATIVE MOVER SCROLL MARGIN MARK ""

ACTIVATE WINDOW wpicklist NOSHOW

@ 0,7 SAY "Available"
@ 0,39 SAY "Selected"

@ 1,1 GET nAvailpos PICTURE "@&N" FROM aAvail RANGE 1, nAvail ;
   SIZE 16,22 DEFAULT 1 VALID fnAdd(nAvailpos) COLOR SCHEME 6

@ 1,33 GET nSelpos PICTURE "@&N" POPUP pSelected SIZE 16,22 ;
   DEFAULT " " VALID fnRemove(nSelpos) DISABLE COLOR SCHEME 6

@ 11,24 GET cOKCancel PICTURE "@*VT \!\<OK;\?\<Cancel" ;
   SIZE 1,8,1 DEFAULT 1

ACTIVATE WINDOW wpicklist
READ CYCLE SHOW Slist_SHOW()
RELEASE WINDOW wpicklist

* Post-READ Cleanup code
nSelected = 0
IF cOkcancel = "OK"
   *
   * Build Selected array with prompts from the Selected box
   *
   nSelected = CNTBAR('pSelected')
   FOR n = 1 TO nSelected
     * GETBAR() returns the next bar number, PRMBAR() its prompt
     aSelected(n) = PRMBAR('pSelected',GETBAR('pSelected',n))
   ENDFOR
ENDIF
RETURN (nSelected)                   && Return number of items selected
*
* FUNCTION Slist_SHOW - Called to enable or disable controls
*
FUNCTION Slist_SHOW
IF nSelected  > 0                    && If Selected items exist,
   SHOW GET nSelpos ENABLE           && enable the Selected listbox
   SHOW GET cOkcancel,1 ENABLE
ELSE
   SHOW GET nSelpos DISABLE          && Otherwise disable it
   SHOW GET cOkcancel,1 DISABLE
ENDIF
IF nAvail > 0                        && If Available items exist,
   SHOW GET nAvailpos ENABLE         && enable the Available listbox
ELSE
   SHOW GET nAvailpos DISABLE        && Otherwise disable it
ENDIF
RETURN .T.
*
* FUNCTION fnAdd - Add an item to the Selected list
*
FUNCTION fnAdd                       && Add an item to Selected list
PARAMETER nPicked
nSelected = nSelected + 1            && Update selected array counter
nSelpos = nSelected                  && Set current pos of bar in selected
                                     &&   to the last item in list
nBarctr = nBarctr + 1                && Relative, it never decrements
* Define a new bar with prompt
* from Available list
DEFINE BAR (nBarctr) OF pSelected PROMPT aAvail(nPicked)
IF nPicked = nAvail                  && If item picked is the last one
   nAvailpos = nAvail - 1            && Make (last - one) the current item
ENDIF
=ADEL(aAvail, nPicked)               && Delete current item from Available
nAvail = nAvail - 1                  && Decrement the Available counter
IF nAvail = 0                        && If there is none left
   _curobj = 2                       && put cursor on the OK button.
ENDIF
SHOW GETS                            && Update screen
RETURN .F.
*
* FUNCTION fnRemove - Remove an item from the Selected list
*
FUNCTION fnRemove                    && Remove item from Selected list
PARAMETER nPicked
nSelected = nSelected - 1            && Decrement counter
nAvailpos = MAX(nAvailpos, 1)        && Get current position
nAvail = nAvail + 1                  && Increment it
=AINS(aAvail, nAvailpos)             && Make space and put it back
aAvail(nAvailpos) = PRMBAR('pSelected',GETBAR('pSelected',nPicked))
=ASORT(aAvail, 1, nAvail)            && Sort the array
nSelpos = MIN(nSelpos, nSelected)    && Update the Selected position
RELEASE BAR (GETBAR('pSelected',nPicked)) OF pSelected
SHOW GETS
RETURN .F.
